// $Id: be_string.h,v 1.14 1999/07/13 17:23:48 coryan Exp $

// ============================================================================
//
// = LIBRARY
//    TAO IDL
//
// = FILENAME
//    be_string.h
//
// = DESCRIPTION
//    Extension of class AST_String that provides additional means for C++
//    mapping.
//
// = AUTHOR
//    Copyright 1994-1995 by Sun Microsystems, Inc.
//    and
//    Aniruddha Gokhale
//
// ============================================================================

#ifndef BE_STRING_H
#define BE_STRING_H

#include "be_type.h"
#include "ast_string.h"

class AST_Expression;
class be_visitor;

/*
 * BE_String
 */
class be_string : public virtual AST_String,
                  public virtual be_type
{
public:
  // Operations

  be_string (void);
  //  default constructor

  be_string (AST_Expression *v);
  // constructor

  be_string (AST_Expression *v, long wide);
  // constructor

  // Visiting
  virtual int accept (be_visitor *visitor);

  // Narrowing
  DEF_NARROW_METHODS2 (be_string, AST_String, be_type);
  DEF_NARROW_FROM_DECL (be_string);

protected:
  virtual void compute_tc_name (void);
  // overridden method to compute typecode name

  virtual UTL_ScopedName * compute_tc_name (const char *prefix,
                                            const char *suffix);
  // Compute and return the value.
};

#endif
