
use Term::Cap;

require "TEST.pl";
&TEST::init;

eval "\$term = Tgetent Term::Cap { TERM => undef, OSPEED => 9600 }";
if ($@) {
    $bold = '';
    $norm = '';
}
else {
    $bold = $term->Tputs('md', 1, undef);
    $norm = $term->Tputs('me', 1, undef);
}

print "1..4\n";

#
#   TEST 1-2: throughput
#

$wmk = $ENV{WML};
$wmk =~ s/l$/k/;

&TEST::tmpfile_with_name('a.html', "x");
&TEST::tmpfile_with_name('a', <<'EOT_IN');
foo
EOT_IN
&TEST::tmpfile_with_name('a.wml', <<"EOT_IN");
#include 'a'
bar
EOT_IN
$tmpfile1 = &TEST::tmpfile(<<'EOT_IN');
foo
bar
EOT_IN

$rc = `$wmk a.wml 2>&1`;
print ($rc eq "$ENV{WML} -n -o a.html a.wml\n" ? "ok\n" : "not ok\n");
$rc = system("cmp $tmpfile1 a.html");
print ($rc == 0 ? "ok\n" : "not ok\n");

$rc = `$wmk a.wml 2>&1`;
print ($rc eq "$ENV{WML} -n -o a.html a.wml  (${bold}skipped${norm})\n" ? "ok\n" : "not ok\n");

open(OUT, ">>a");
print OUT " ";
close(OUT);
$rc = `$wmk a.wml 2>&1`;
print ($rc eq "$ENV{WML} -n -o a.html a.wml\n" ? "ok\n" : "not ok\n");

&TEST::cleanup;

