#!/usr/bin/perl

# escape.pl
# basic hack to generate a packed bitmap of characters that
# need escaping for HTTP protocol.  See RFC-1738 Section 2.2.

# Copyright 1998 Larry Doolittle   <ldoolitt@jlab.org>
# tested standalone Jan 4, 1998
# inserted into Boa Jan 11, 1998
# modifed to support 64-bit machines Nov 9, 1998

#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 1, or (at your option)
#   any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# The resulting c code is designed for cache-friendliness,
# and 32-bit (or more) machines.  This perl program can be
# run on any 32-bit (or greater) host; it does not need to
# have longs the same size as the target machine.

# Usage:   escape.pl [bitsize] >escape.h
# (above can be part of a makefile rule, but ship with a working
# escape.h in case someone doesn't happen to have perl around). 
# $Id:

if ($#ARGV != 0 || $ARGV[0] < 32 || $ARGV[0] > 256) {
	print STDERR "Usage: escape.pl bitsize >escape.h\n";
	print STDERR "  bitsize is a power of two, 32<=bitsize<=256\n";
	exit(1);
}
$order=0; $order++ while $ARGV[0]>>=1;
$bitsize=1<<$order;
$bytesize=$bitsize/8;
$mask=$bitsize-1;
$nwords=256/$bitsize;
$boost=$bitsize/32;

print <<EOT;
/* escape.h
 *  automatically generated by escape.pl
 *  this version suited for $bitsize bit machines
 *  Not copyrighted, given its size and machine-generated nature
 *
 *  defines the macro needs_escape(c), which returns non-zero when c
 *  needs escaping according to RFC-1738 section 2.2.
*/

#ifndef __NEEDS_ESCAPE__
#define __NEEDS_ESCAPE__

EOT

for $i (0..7) {$word[$i]=0xffffffff;}

# The following is the list of characters that are safe to _not_ escape:
for $c ("!", "(", ")", "*", "+", ",", "-", ".", "/",
        "0".."9", ":", "?", "A".."Z", "_",  "a".."z", "~") {
	$i=unpack("C",$c);
	# printf "%s %d\n",$c,$i;}
	$word[$i>>5]&=~(1<<($i&0x1f));
}

$delim = " ";
print "unsigned long _needs_escape[$nwords] = {\n";
for $i (1..$nwords) {
	print "$delim 0x";
	for $j (1..$boost) { printf "%x", $word[$i*$boost-$j]; }
	print "L";
	$delim=",";
}
print "\n };\n#define needs_escape(c) ";
print "(_needs_escape[(c)>>$order]&(1<<((c)&$mask)))\n";
print "#endif\n"; 

