/*
 * The contents of this file are subject to the AOLserver Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://aolserver.lcs.mit.edu/.
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is AOLserver Code and related documentation
 * distributed by AOL.
 * 
 * The Initial Developer of the Original Code is America Online,
 * Inc. Portions created by AOL are Copyright (C) 1999 America Online,
 * Inc. All Rights Reserved.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU General Public License (the "GPL"), in which case the
 * provisions of GPL are applicable instead of those above.  If you wish
 * to allow use of your version of this file only under the terms of the
 * GPL and not to allow others to use your version of this file under the
 * License, indicate your decision by deleting the provisions above and
 * replace them with the notice and other provisions required by the GPL.
 * If you do not delete the provisions above, a recipient may use your
 * version of this file under either the License or the GPL.
 */

/* 
 * proc.c --
 *
 *	Support for getting information on procs (thread routines,
 *	callbacks, scheduled procs, etc.).
 */

static const char *RCSID = "@(#) $Header: /cvsroot/aolserver/aolserver3/nsd/proc.c,v 1.1.1.1 2000/03/17 07:11:17 kriston Exp $, compiled: " __DATE__ " " __TIME__;

#include "nsd.h"

static Tcl_HashTable procTable;

typedef struct Info {
    Ns_ArgProc *proc;
    char *desc;
} Info;


struct proc {
	void *procAddr;
	char *desc;
	Ns_ArgProc *argProc;
} procs[] = {
	{(void *) NsTclThread, "tclthread", NsTclArgProc},
	{(void *) NsTclCallback, "tclcallback", NsTclArgProc},
	{(void *) NsTclSchedProc, "tclschedproc", NsTclArgProc},
	{(void *) NsTclSignalProc, "tclsigproc", NsTclArgProc},
	{(void *) NsTclSockProc, "tclsockcallback", NsTclSockArgProc},
	{(void *) NsCachePurge, "cachepurge", NsCacheArgProc},
	{(void *) NsConnThread, "connthread", NsConnArgProc},
	{NULL, NULL, NULL}
};


void
NsProcInit(void)
{
    struct proc *pPtr;

    Tcl_InitHashTable(&procTable, TCL_ONE_WORD_KEYS);
    pPtr = procs;
    while (pPtr->procAddr != NULL) {
	Ns_RegisterProcInfo(pPtr->procAddr, pPtr->desc, pPtr->argProc);
	++pPtr;
    }
}


void
Ns_RegisterProcInfo(void *procAddr, char *desc, Ns_ArgProc *argProc)
{
    Tcl_HashEntry *hPtr;
    Info *iPtr;
    int new;

    hPtr = Tcl_CreateHashEntry(&procTable, (char *) procAddr, &new);
    if (new) {
    	iPtr = ns_malloc(sizeof(Info));
    	Tcl_SetHashValue(hPtr, iPtr);
    }
    iPtr->desc = desc;
    iPtr->proc = argProc;
}


static void
AppendAddr(Tcl_DString *dsPtr, char *prefix, void *addr)
{
    char buf[30];

    if (addr == NULL) {
    	sprintf(buf, "%s:0x0", prefix);
    } else {
	sprintf(buf, "%s:%p", prefix, addr);
    }
    Tcl_DStringAppendElement(dsPtr, buf);
}


void
Ns_GetProcInfo(Tcl_DString *dsPtr, void *procAddr, void *arg)
{
    Tcl_HashEntry *hPtr;
    Info *iPtr;
    static Info nullInfo = {NULL, NULL};

    hPtr = Tcl_FindHashEntry(&procTable, (char *) procAddr);
    if (hPtr != NULL) {
	iPtr = Tcl_GetHashValue(hPtr);
    } else {
	iPtr = &nullInfo;
    }
    if (iPtr->desc != NULL) {
    	Tcl_DStringAppendElement(dsPtr, iPtr->desc);
    } else {
	AppendAddr(dsPtr, "p", procAddr);
    }
    if (iPtr->proc != NULL) {
    	(*iPtr->proc)(dsPtr, arg);
    } else {
	AppendAddr(dsPtr, "a", arg);
    }
}
