/*
 *
 * (c) Vladi Belperchinov-Shabanski "Cade" <cade@biscom.net> 1998-1999
 *
 * SEE `README',`LICENSE' OR `COPYING' FILE FOR LICENSE AND OTHER DETAILS!
 *
 */

/*
 *
 *  Vladi String lib (c) Vladi BS "Cade" <cade@biscom.net> 1998
 *
 *  NOTE: this string library is based on `cxstring' lib (c) Ivo Baylov 1998
 *
 */

#include <stdio.h>
#include <ctype.h>
#include <stdarg.h>
#include <string.h>
#include <stdlib.h>

#include "vstring.h"

#ifndef _HAVE_ITOA_
#define itoa(n,s,r) sprintf(s,"%d",n)
#endif

////////////////////////////////////////////////////////////////////////////
//
// STRING object
//

  String operator + ( const String& str1, const String& str2 )
  {
    String res = str1;
    res += str2;
    return res;
  };

  String operator + ( const String& str1, const char* ps )
  {
    String res = str1;
    res += ps;
    return res;
  };

  String operator + ( const char* ps, const String& str2 )
  {
    String res = ps;
    res += str2;
    return res;
  };

  void String::resize( size_t newsize )
  {
    newsize++; // for the trailing 0
    int bcount = newsize / BLOCKSIZE  + (newsize % BLOCKSIZE != 0);
    if( s == NULL ) // first time alloc
      {
      s = new char[ bcount * BLOCKSIZE ];
      ASSERT( s );
      memset( s, 0, bcount * BLOCKSIZE ); // vladi
      blocks = bcount;
      } else
    if ( bcount != blocks ) // expand / shrink
      {
      char* news = new char[ bcount * BLOCKSIZE ];
      ASSERT( news );
      memset( news, 0, bcount * BLOCKSIZE ); // vladi
      memcpy( news, s, (bcount < blocks ? bcount : blocks) * BLOCKSIZE );
      blocks = bcount;
      delete s;
      s = news;
      }
  };


  void String::seti( const int n )
  {
    char tmp[40]; // RTFM for itoa result buffer
    itoa( n, tmp, 10 );
    set( tmp );
  }

  void String::setl( const long n )
  {
    char tmp[40]; // RTFM for itoa result buffer
    sprintf( tmp, "%ld", n );
    set( tmp );
  }

  void String::setf( const double d )
  {
    char tmp[1024];
    sprintf( tmp, "%.10lf", d );
    int z = strlen( tmp );
    while( tmp[z-1] == '0' ) z--;
    if ( tmp[z-1] == '.' ) z--;
    tmp[z] = 0;
    set( tmp );
  }

  void String::setfi( const double d ) // sets double as int (w/o frac)
  {
    char tmp[1024];
    sprintf( tmp, "%.0lf", d );
    int z = strlen( tmp );
    // while( tmp[z-1] == '0' ) z--;
    // if ( tmp[z-1] == '.' ) z--;
    tmp[z] = 0;
    set( tmp );
  }

  void String::set( const char* ps )
  {
    if (ps == NULL || ps[0] == 0)
      {
      resize(0);
      sl = 0;
      s[0] = 0;
      }
    else
      {
      sl = strlen(ps);
      resize( sl );
      strcpy( s, ps );
      }
  };

  void String::cat( const char* ps )
  {
    if (ps == NULL) return;
    if (ps[0] == 0) return;
    int psl = strlen( ps );
    resize( sl+psl );
    //strcat( s, ps );
    for( int z = 0; z < psl; z++ ) s[sl+z] = ps[z];
    s[sl+psl] = 0;
    sl += psl;
  };

  void String::setn( const char* ps, int len )
  {
    int z = strlen( ps );
    if ( len < z ) z = len;
    sl = z;
    resize( sl );
    for ( z = 0; z < sl; z++ ) s[z] = ps[z];
    s[z] = 0;
  };

  void String::catn( const char* ps, int len )
  {
    int z = strlen( ps );
    if ( len < z ) z = len;
    sl += z;
    resize( z );
    strncat( s, ps, z );
    s[sl] = 0;
  };

////////////////////////////////////////////////////////////////////////////
//
// STRING functions
//

  char* StrMul( char* target, int n ) // multiplies the string n times, i.e. `1'*5 = `11111'
  {
    if ( n < 0 ) return target;
    if ( n == 0 )
      {
      target[0] = 0;
      return target;
      }
    // ReAllocBuffer( m_nLength * n );
    int sl = strlen( target );
    int z = (n - 1) * sl;
    while( z > 0 )
      {
      strncpy( target + z, target, sl );
      z -= sl;
      }
    // m_nLength = m_nLength * n;
    target[sl*n] = 0;
    return target;
  }

  int StrFind ( const char* target, const char  s, int startpos ) // returns first zero-based position of char, or -1 if not found
  {
    int sl = strlen( target );
    if (startpos >= sl) return -1;
    char* pcPos = strchr( target + startpos, s );
    if( ! pcPos )
      return -1;
    return  pcPos - target;
  }

  int StrRFind( const char* target, const char c ) // returns last zero-based position of char, or -1 if not found
  {
    char* pcPos = strrchr( target, c );
    if( ! pcPos )
      return -1;
    return  pcPos - target;
  }

  int StrFind ( const char* target, const char* s, int startpos ) // returns first zero-based position of string, or -1 if not found
  {
    int sl = strlen( target );
    if (startpos >= sl) return -1;
    char* pcPos = strstr( target + startpos, s );
    if( ! pcPos )
      return -1;
    return  pcPos - target;
  }

  int StrRFind( const char* target, const char* s ) // returns last zero-based position of string, or -1 if not found
  {
    int sl = strlen( target );
    int sls = strlen( s );
    int z = sl - sls;
    while ( z > 0 )
      {
      if ( strncmp( target + z, s, sls ) == 0 ) return z;
      z--;
      };
    return -1;
  }


  char* StrDelete  ( char* target, int pos, int len ) // deletes `len' chars starting from `pos'
  {
    int sl = strlen( target );
    if ( pos > sl || pos < 0 ) return target;
    int z = sl-pos-len;
    if ( pos + len < sl )
      strncpy(target+pos, target+pos+len, z+1);
    else
      target[pos] = 0;
    // m_nLength = strlen(m_pszText);
    // ReAllocBuffer( m_nLength );
    return target;
  }

  char* StrInsert  ( char* target, int pos, const char* s ) // inserts `s' in position `pos'
  {
    int sl = strlen( target );
    if ( pos > sl || pos < 0 ) return target;
    int sls = strlen( s );
    if ( sls < 1 ) return target;
    // ReAllocBuffer( m_nLength + sl );

    int z = sl - pos;
    target[pos + z + sls] = 0;
    while(z)
      {
      target[pos + z + sls - 1] = target[pos + z - 1];
      z--;
      }

    for(z = 0; z < sls; z++) target[pos+z] = s[z];
    // m_nLength += sl;
    return target;
  }

  char* StrInsertCh( char* target, int pos, char ch ) // inserts `ch' in position `pos'
  {
    char tmp[2];
    tmp[0] = ch;
    tmp[1] = 0;
    StrInsert( target, pos, tmp );
    return target;
  }

  char* StrReplace ( char* target, const char* out, const char* in ) // replace `out' w. `in'
  {
    int outl = strlen( out );
    int inl = strlen( in );
    int z = StrFind( target, out );
    while(z != -1)
      {
      StrDelete( target, z, outl );
      StrInsert( target, z, in );
      z = StrFind( target, out, z + inl );
      }
    return target;
  }


  char* StrCopy  ( char* target, const char* source, int pos, int len ) // returns `len' chars from `pos'
  {
    target[0] = 0;
    int sl = strlen( source );
    int s = pos;
    int l = len;
    if ( s < 0 || s >= sl ) return target;
    if ( s + l >= sl ) l = sl - s;

    strncpy( target, source + s, l );
    target[ l ] = 0;

    return target;
  }

  char* StrLeft  ( char* target, const char* source, int len ) // returns `len' chars from the left
  {
    return StrCopy( target, source, 0, len );
  }

  char* StrRight ( char* target, const char* source, int len ) // returns `len' chars from the right
  {
    return StrCopy( target, source, strlen(source) - len, len );
  }

  char* StrSLeft ( char* target, int len ) // SelfLeft -- just as 'Left' but works on `this'
  {
    if ( (size_t)len < strlen(target) ) target[len] = 0;
    return target;
  };

  char* StrSRight( char* target, int len ) // SelfRight -- just as 'Right' but works on `this'
  {
    int sl = strlen( target );
    if ( len < sl )
      {
      strcpy( target, target + ( sl - len ));
      target[len] = 0;
      }
    return target;
  };

  char* StrTrimL ( char* target, int len ) // trims `len' chars from the beginning (left)
  {
    int s = strlen( target ) - len;
    if ( s > 0 )  
      strcpy( target, target + len );
    else
      target[0] = 0;  
    // m_nLength -= len;
    // ReAllocBuffer( m_nLength );
    return target;
  }

  char* StrTrimR ( char* target, int len ) // trim `len' chars from the end (right)
  {
    int e = strlen(target) - len;
    if ( e > 0 ) 
      target[e] = 0;
    else
      target[0] = 0;  
    // m_nLength = e;
    // ReAllocBuffer( m_nLength );
    return target;
  }

  void StrSetCh( char* target, const int pos, const char ch ) // sets `ch' char at position `pos'
  {
    target[pos] = ch;
  };

  char StrGetCh( char* target, const int pos ) // return char at position `pos'
  {
    if ( pos >= 0 )
      return target[pos];
    else
      return target[strlen( target ) + pos];
  };

  void StrAddCh( char* target, const char ch ) // adds `ch' at the end
  {
    int sl = strlen( target );
    target[sl] = ch;
    target[sl+1] = 0;
  };



  // return first `word', i.e. from pos 0 to first found delimiter char
  // after that deletes this `word' from the string
  char* StrGetFirstWord( char* target, const char* delimiters, char* result )
  {
    int z = 0;
    int sl = strlen( target );
    while ((strchr(delimiters, target[z]) == NULL) && (target[z] != 0)) z++;
    if ( z == 0 ) return NULL;
    strncpy(result, target, z);
    result[z] = 0;
    strncpy( target, target + z + 1, sl - z + 1 );
    // m_nLength = strlen( target );
    // ReAllocBuffer( m_nLength );
    return result;
  }

  // ...same but `last' word
  char* StrGetLastWord( char* target, const char* delimiters, char* result )
  {
    result[0] = 0;
    int sl = strlen( target );
    int z = sl - 1;
    while ( strchr( delimiters, target[z] ) == NULL && z > 0 ) z--;
    if (z < 0) return NULL;
    strcpy( result, target + z + 1);
    target[z] = 0;
    // m_nLength = z;
    // ReAllocBuffer( m_nLength );
    return result;
  }


  char* StrCutL  ( char* target, const char* charlist ) // remove all chars `charlist' from the beginning (i.e. from the left)
  {
    if (strlen(target) == 0) return target;
    int z = 0;
    while ((strchr(charlist, target[z]) != NULL) && (target[z] != 0)) z++;
    if (z == 0) return target;
    strcpy( target, target + z );
    // m_nLength -= z;
    // ReAllocBuffer( z );
    return target;
  };

  char* StrCutR  ( char* target, const char* charlist ) // remove all chars `charlist' from the end (i.e. from the right)
  {
    if (strlen(target) == 0) return target;
    int z = strlen(target) - 1;
    while ((strchr(charlist, target[z]) != NULL) && (z > 0)) z--;
    target[z+1] = 0;
    // m_nLength = z+1;
    // ReAllocBuffer( m_nLength );
    return target;
  };

  char* StrCut   ( char* target, const char* charlist ) // does `CutR(charlist);CutL(charlist);'
  {
    StrCutL( target, charlist );
    StrCutR( target, charlist );
    return target;
  };

  char* StrCutSpc( char* target ) // does `Cut(" ");'
  {
    StrCutL( target, " " );
    StrCutR( target, " " );
    return target;
  };

  // expand align in a field, filled w. `ch', if len > 0 then right, else left
  char* StrPad( char* target, int len, char ch )
  {
    int sl = strlen( target );
    int _len;
    _len = (len >= 0) ? len : - len;
    if ( _len <= sl ) return target;

    char *tmp = new char[_len + 1]; // result buffer -- need len + 1
    tmp[0] = ch;
    tmp[1] = 0;
    StrMul( tmp, _len - sl );

    if ( len < 0 )
      {
      strcat( target, tmp );
      }
    else
      {
      strcat( tmp, target );
      strcpy( target, tmp );
      }
    delete tmp;
    return target;
  }


  // insert `commas' for 1000's delimiter or use another delimiter
  // string supposed to be a integer or real w/o `e' format
  char* StrComma( char* target, char delim )
  {
    int dot = StrRFind( target, '.' );
    if (dot == -1) dot = strlen( target );
    while( dot >= 4 )
      {
      StrInsertCh( target, dot - 3 , delim );
      dot -= 3;
      }
    return target;
  }


  // translate chars from `from' to `to'
  // length of `from' MUST be equal to length of `to'
  char* StrTR( char* target, const char *from, const char *to )
  {
    ASSERT(strlen( from ) == strlen( to ));
    if (strlen( from ) != strlen( to )) return target;
    int z = 0;
    int sl = strlen( target );
    for( z = 0; z < sl; z++ )
      {
      char *pc = strchr( from, target[z] );
      if (pc) target[z] = to[ pc - from ];
      }
    return target;
  }


  char* StrUpCase     ( char* target )
  {
    int sl = strlen( target );
    for( int z = 0; z < sl; z++ ) target[z] = toupper( target[z] );
    return target;
  }

  char* StrLowCase    ( char* target )
  {
    int sl = strlen( target );
    for( int z = 0; z < sl; z++ ) target[z] = tolower( target[z] );
    return target;
  }

  char* StrReverseCase( char* target ) // CUTE nali? :) // vladi
  {
    int sl = strlen( target );
    for( int z = 0; z < sl; z++ )
      {
      if ( target[z] >= 'a' && target[z] <= 'z' ) target[z] -= 32; else
      if ( target[z] >= 'A' && target[z] <= 'Z' ) target[z] += 32;
      }
    return target;
  }

  char* StrReverse( char* target ) // reverse the string: `abcde' becomes `edcba' :)
  {
    int z = 0;
    int x = strlen(target)-1;
    while( z < x )
      {
      char ch = target[ z ];
      target[ z++ ] = target[ x ];
      target[ x-- ] = ch;
      }
    return target;
  }

  int StrCount( const char* target, const char* charlist, int startpos ) // returns match count of all chars from `charlist'
  {
    int sl = strlen( target );
    if ( startpos >= sl || startpos < 0 ) return 0;
    int z = startpos;
    int cnt = 0;
    for ( z = 0; z < sl; z++ )
      cnt += ( strchr( charlist, target[z]) != NULL );
    return cnt;
  }

  int StrIsInt   ( const char* target ) // check if string is correct int value
  {
    char *tmp = strdup( target );
    StrCutSpc( tmp );
    int dc = StrCount( tmp, "0123456789" );
    int sl = strlen( tmp );
    free( tmp );
    return ( dc == sl );
  };

  int StrIsDouble( const char* target ) // check if string is correct double (w/o `e' format :( )
  {
    char *tmp = strdup( target );
    StrCutSpc( tmp );
    int dc = StrCount( tmp, "0123456789" );
    int cc = StrCount( tmp, "." );
    int sl = strlen( tmp );
    free( tmp );
    return ( (dc + cc == sl) && ( cc == 1 ) );
  }


////////////////////////////////////////////////////////////////////////////
//
// STRING change functions over's
// the only difference from the functions above is that string is resized
//

  String &StrMul( String &target, int n ) // multiplies the string n times, i.e. `1'*5 = `11111'
  {
    char* pc = target.getbuf();
    target.resize( target.len()*n );
    StrMul( pc, n );
    target.fix();
    ASSERT(target.check());
    return target;
  }

  String &StrDelete  ( String &target, int pos, int len ) // deletes `len' chars starting from `pos'
  {
    char* pc = target.getbuf();
    StrDelete( pc, pos, len );
    target.fix();
    ASSERT(target.check());
    return target;
  };

  String &StrInsert  ( String &target, int pos, const char* s ) // inserts `s' in position `pos'
  {
    char* pc = target.getbuf();
    if ( pos > target.len() || pos < 0 ) return target;
    target.resize( target.len() + strlen(s) );
    StrInsert( pc, pos, s );
    target.fixlen();
    ASSERT(target.check());
    return target;
  };

  String &StrInsertCh( String &target, int pos, char ch ) // inserts `ch' in position `pos'
  {
    char* pc = target.getbuf();
    if ( pos > target.len() || pos < 0 ) return target;
    target.resize( target.len() + 1 );
    StrInsertCh( pc, pos, ch );
    target.fixlen();
    ASSERT(target.check());
    return target;
  };

  String &StrReplace ( String &target, const char* out, const char* in ) // replace `out' w. `in'
  {
    int outl = strlen( out );
    int inl = strlen( in );
    int z = StrFind( target, out );
    while(z != -1)
      {
      StrDelete( target, z, outl );
      StrInsert( target, z, in );
      z = StrFind( target, out, z + inl );
      }
    ASSERT(target.check());
    return target;
  };

  String &StrCopy  ( String &target, const char* source, int pos, int len ) // returns `len' chars from `pos'
  {
    target = "";
    int sl = strlen( source );
    int s = pos;
    int l = len;
    if ( s < 0 || s >= sl ) return target;
    if ( s + l >= sl ) l = sl - s;

    target.setn( source + s, l );

    ASSERT(target.check());
    return target;
  };

  String &StrLeft  ( String &target, const char* source, int len ) // returns `len' chars from the left
  {
    return StrCopy( target, source, 0, len );
  };

  String &StrRight ( String &target, const char* source, int len ) // returns `len' chars from the right
  {
    return StrCopy( target, source, strlen( source ) - len, len );
  };

  String &StrSLeft ( String &target, int len ) // SelfLeft -- just as 'Left' but works on `this'
  {
    if ( len < target.len() )
      {
      (target.getbuf())[len] = 0;
      target.fix();
      }
    ASSERT(target.check());
    return target;
  };

  String &StrSRight( String &target, int len ) // SelfRight -- just as 'Right' but works on `this'
  {
    int sl = target.len();
    if ( len < sl )
      {
      char *pc = target.getbuf();
      strcpy( pc, pc + ( sl - len ));
      target.fix();
      }
    ASSERT(target.check());
    return target;
  };


  String &StrTrimL ( String &target, int len ) // trims `len' chars from the beginning (left)
  {
    int s = target.len() - len;
    if ( s > 0 )
      {
      char* pc = target.getbuf();
      strcpy( pc, pc + len );
      target.fix();
      }
    else
      target = "";  
    ASSERT(target.check());
    return target;
  };

  String &StrTrimR ( String &target, int len ) // trim `len' chars from the end (right)
  {
    int e = target.len() - len;
    if ( e > 0 )
      {
      char* pc = target.getbuf();
      pc[e] = 0;
      target.fix();
      }
    else
      target = "";  
    ASSERT(target.check());
    return target;
  };

  String &StrCutL  ( String &target, const char* charlist ) // remove all chars `charlist' from the beginning (i.e. from the left)
  {
    if (target.len() == 0) return target;
    char* pc = target.getbuf();
    int z = 0;
    while ((strchr(charlist, pc[z]) != NULL) && (pc[z] != 0)) z++;
    if (z == 0) return target;
    strcpy( pc, pc + z );
    target.fix();

    ASSERT(target.check());
    return target;
  };

  String &StrCutR  ( String &target, const char* charlist ) // remove all chars `charlist' from the end (i.e. from the right)
  {
    if (strlen(target) == 0) return target;
    char* pc = target.getbuf();
    int z = target.len() - 1;
    while ((strchr(charlist, pc[z]) != NULL) && (z > 0)) z--;
    pc[z+1] = 0;
    target.fix();

    ASSERT(target.check());
    return target;
  };

  String &StrCut   ( String &target, const char* charlist ) // does `CutR(charlist);CutL(charlist);'
  {
    StrCutL( target, charlist );
    StrCutR( target, charlist );
    ASSERT(target.check());
    return target;
  };

  String &StrCutSpc( String &target ) // does `Cut(" ");'
  {
    return StrCut( target, " " );
  };

  String &StrPad( String &target, int len, char ch )
  {
    target.resize( (len > 0)?len:-len );
    StrPad( target.getbuf(), len, ch );
    target.fixlen();
    ASSERT(target.check());
    return target;
  };

  String &StrComma( String &target, char delim )
  {
    int dot = StrRFind( target, '.' );
    if (dot == -1) dot = target.len();
    while( dot >= 4 )
      {
      StrInsertCh( target, dot - 3 , delim );
      dot -= 3;
      }
    ASSERT(target.check());
    return target;
  };

  void StrSetCh( String &target, const int pos, const char ch ) // sets `ch' char at position `pos'
  {
    if (pos < target.len()) (target.getbuf())[pos] = ch;
  };

  char StrGetCh( String &target, const int pos ) // return char at position `pos'
  {
    if ( pos >= 0 )
      return target[pos];
    else
      return target[StrLen( target ) + pos];
    return 0;
  };

  void StrAddCh( String &target, const char ch ) // adds `ch' at the end
  {
    int sl = target.len();
    target.resize(sl+1);
    (target.getbuf())[sl] = ch;
    (target.getbuf())[sl+1] = 0;
    target.fix();
    ASSERT(target.check());
  };

  char* StrGetFirstWord( String &target, const char* delimiters, char* result )
  {
    int z = 0;
    int sl = target.len();
    char* pc = target.getbuf();
    while ((strchr(delimiters, pc[z]) == NULL) && (pc[z] != 0)) z++;
    if ( z == 0 ) return NULL;
    strncpy(result, pc, z);
    result[z] = 0;
    strncpy( pc, pc + z + 1, sl - z + 1 );
    target.fix();
    ASSERT(target.check());
    return result;
  };

  char* StrGetLastWord( String &target, const char* delimiters, char* result )
  {
    result[0] = 0;
    char* pc = target.getbuf();
    int sl = target.len();
    int z = sl - 1;
    while ( strchr( delimiters, pc[z] ) == NULL && z > 0 ) z--;
    if (z < 0) return NULL;
    strcpy( result, pc + z + 1);
    pc[z] = 0;
    target.fix();
    ASSERT(target.check());
    return result;
  };


  int sprintf( int init_size, String &target, const char *format, ... )
  {
    char *tmp = new char[init_size+1];
    va_list vlist;
    va_start( vlist, format );
    int res = vsprintf( tmp, format, vlist );
    va_end( vlist );
    target = tmp;
    delete tmp;
    ASSERT(target.check());
    return res;
  };

  int sprintf( String &target, const char *format, ... )
  {
    char tmp[1024];
    va_list vlist;
    va_start( vlist, format );
    int res = vsprintf( tmp, format, vlist );
    va_end( vlist );
    target = tmp;
    ASSERT(target.check());
    return res;
  };

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////


