/*
 *
 * (c) Vladi Belperchinov-Shabanski "Cade" <cade@biscom.net> 1998-1999
 *
 * SEE `README',`LICENSE' OR `COPYING' FILE FOR LICENSE AND OTHER DETAILS!
 *
 */

#include "unicon.h"

#ifdef _TARGET_GO32_

#include <pc.h>
#include <dos.h>
#include <conio.h>
#include "vstring.h"

  int original_ta;

  text_info ti;
  int fg;
  int bg;
  int ta;

  int ConInit()
  {
    gppconio_init();
    gettextinfo( &ti );
    original_ta = ti.attribute;
    return 0;
  };

  void ConDone()
  {
    textattr( original_ta );
    return;
  };

  void ConSuspend() { return; };
  void ConRestore() { return; };

  void ConCE( int attr )
  {
    if (attr != -1)
      {
      int _ta = ta;
      textattr( attr );
      clreol();
      textattr( _ta );
      }
    else
      clreol();
  };

  void ConCS( int attr )
  {
    if (attr != -1)
      {
      int _ta = ta;
      textattr( attr );
      clrscr();
      gotoxy(1,1);
      textattr( _ta );
      }
    else
      {
      clrscr();
      gotoxy(1,1);
      }
  };

  void ConOut( int x, int y, const char *s )
  {
    gotoxy( x, y );
    ConPuts( s );
  };

  void ConOut( int x, int y, const char *s, int attr )
  {
    int _ta = ta;
    textattr( attr );
    gotoxy( x, y );
    ConPuts( s );
    textattr( _ta );
  };

  void ConPuts( const char *s )
  {
    #ifdef _TARGET_GO32_
    String str = s;
    StrReplace( str, "\n", "\r\n" );
    cputs( str );
    #else
    cputs( s );
    #endif
  };

  void ConPuts( const char *s, int attr )
  {
    int _ta = ta;
    textattr( attr );
    ConPuts( s );
    textattr( _ta );
  }

  int ConMaxX() { return ti.screenwidth; };
  int ConMaxY() { return ti.screenheight; };
  int ConX() { return wherex(); };
  int ConY() { return wherey(); };
  void ConFG( int color ) { fg = color; ta = CONCOLOR(fg,bg); textattr( ta ); };
  void ConBG( int color ) { bg = color; ta = CONCOLOR(fg,bg); textattr( ta ); };
  void ConTA( int attr ) { ta = attr; bg = COLORBG(ta); fg = COLORFG(ta); textattr( attr ); };
  void ConXY( int x, int y ) { gotoxy( x, y ); };

  void ConCHide() { _setcursortype( _NOCURSOR ); }; // cursor hide
  void ConCShow() { _setcursortype( _NORMALCURSOR ); }; // cursor show

  int ConKbHit() { return kbhit(); };
  int ConGetch()
  {
    char ch = getch();
    if ( ch == 0 )
      return 1024 + getch();
    else
      return ch;
  };

  void ConBeep()
  {
    sound(800);
    delay(1); // 1/10 second
    sound(0);
//    printf("\007"); fflush(stdout);
  };

#endif

/////////////////////

#ifdef _TARGET_UNIX_

  // Even though heavily rewritten by me
  // this part (linux/curses) of UniCon is mainly based on `linconio'
  // now follows it's original notice from linconio.h:

  /** --------------------------------------------------------------------- **/
  /** File: conio.h     Date: 03/09/1997       Version: 1.02                **/
  /** CONIO.H an implementation of the conio.h for Linux based on ncurses.  **/
  /** This is copyright (c) 1996,97 by Fractor / Mental EXPlosion.          **/
  /** If you want to copy it you must do this following the terms of the    **/
  /** GNU Library Public License                                            **/
  /** Please read the file "README" before using this library.              **/
  /** --------------------------------------------------------------------- **/
  // Thanx to the `linconio' authors mentioned above!

  int fg;
  int bg;
  int ta;
  WINDOW *conio_scr;

  #define CON_PAIR(f,b) (((b)*8)+(f)+1)

  /* Some internals... */
  int colortab(int a) /* convert UNIX/Curses Color code to DOS-standard */
  {
     switch(a) {
        case cBLACK   : return COLOR_BLACK;
        case cBLUE    : return COLOR_BLUE;
        case cGREEN   : return COLOR_GREEN;
        case cCYAN    : return COLOR_CYAN;
        case cRED     : return COLOR_RED;
        case cMAGENTA : return COLOR_MAGENTA;
        case cYELLOW  : return COLOR_YELLOW;
        case cWHITE   : return COLOR_WHITE;
     }
     return -1;
  }

  int ConInit()
  {
    initscr();
    start_color();
    nonl();
    raw();
    if (!has_colors())
       fprintf(stderr,"Attention: A color terminal may be required to run this application !\n");
    noecho();
    conio_scr=newwin(0,0,0,0);
    keypad(conio_scr,TRUE);
    meta(conio_scr,TRUE);
    idlok(conio_scr,TRUE);
    scrollok(conio_scr,TRUE);
    /* Color initialization */
    for (bg=0;bg<=7;bg++)
       for (fg=0;fg<=7;fg++)
          init_pair( CON_PAIR(fg,bg), colortab(fg), colortab(bg));
    ConTA(7);
    return 0;
  };

  void ConDone()
  {
    delwin(conio_scr);
    endwin();
    echo();
    nl();
  };

  void ConSuspend()
  {
    ConDone();
    /*
    endwin();
    */
  };

  void ConRestore()
  {
    ConInit();
    /*
    refresh();
    wrefresh(conio_scr);
    */
  };

  void ConTA( int attr )
  {
    ta = attr;
    wattrset(conio_scr,0); /* (???) My curses-version needs this ... */
    fg = COLORFG(attr);
    bg = COLORBG(attr);
    wattrset(conio_scr,COLOR_PAIR(CON_PAIR( fg%8, bg%8 )) | ( bg > 7 )*(A_BLINK) | ( fg > 7 )*(A_BOLD) );
    // this is set for background (I don't know if it's enough but it seems to be ok)
    wbkgdset( conio_scr, COLOR_PAIR(CON_PAIR( fg%8, bg%8 )) );
  };

  void ConCE( int attr )
  {
    if (attr != -1)
      {
      int _ta = ta;
      ConTA( attr );
      wclrtoeol(conio_scr);
      wrefresh(conio_scr);
      ConTA( _ta );
      }
    else
      {
      wclrtoeol(conio_scr);
      wrefresh(conio_scr);
      }
  };

  void ConCS( int attr )
  {
    if (attr != -1)
      {
      int _ta = ta;
      ConTA( attr );
      wclear(conio_scr);
      wmove(conio_scr,0,0);
      wrefresh(conio_scr);
      ConTA( _ta );
      }
    else
      {
      wclear(conio_scr);
      wmove(conio_scr,0,0);
      wrefresh(conio_scr);
      }
  };

  void ConOut( int x, int y, const char *s )
  {
    ConXY( x, y );
    ConPuts( s );
  };

  void ConOut( int x, int y, const char *s, int attr )
  {
    int _ta = ta;
    ConTA(attr);
    ConOut( x, y, s );
    ConTA(_ta);
  };

  void ConPuts( const char *s )
  {
    #ifdef _USE_CXSTRING_
    String str = s;
    str.Replace( "\r\n", "\n" );
    waddstr(conio_scr,str);
    #else
    waddstr(conio_scr,s);
    #endif
    wrefresh(conio_scr);
  };

  void ConPuts( const char *s, int attr )
  {
    int _ta = ta;
    ConTA(attr);
    ConPuts( s );
    ConTA(_ta);
  };

  int ConMaxX()
  {
    int x;
    int y;
    getmaxyx(conio_scr,y,x);
    return(x);
  };

  int ConMaxY()
  {
    int x;
    int y;
    getmaxyx(conio_scr,y,x);
    return(y);
  };

  int ConX()
  {
    int y;
    int x;
    getyx(conio_scr,y,x);
    return(x+1);
  };

  int ConY()
  {
    int y;
    int x;
    getyx(conio_scr,y,x);
    return(y+1);
  };

  void ConFG( int color )
  {
    fg=color;
    ConTA( CONCOLOR( fg, bg ) );
  };

  void ConBG( int color )
  {
    bg=color;
    ConTA( CONCOLOR( fg, bg ) );  };


  void ConXY( int x, int y )
  {
    wmove(conio_scr,y-1,x-1);
    wrefresh(conio_scr);
  };

  void ConCHide() // cursor hide
  {
    ConXY( 1, 1 );
    leaveok(conio_scr,1);
  };

  void ConCShow() // cursor show
  {
    leaveok(conio_scr,0);
  };

  int ConKbHit()
  {
    int i;
    nodelay(conio_scr,TRUE);
    i=wgetch(conio_scr);
    nodelay(conio_scr,FALSE);
    if (i==-1)
      i=0;
    else
      ungetch(i);
    return(i);
  };

  int ConGetch()
  {
    int i;
    i=wgetch(conio_scr);
    if (i==-1) i=0;
    if (i == 27)
      if (ConKbHit())
        i = KEY_PREFIX + ConGetch();
    #ifndef _NO_ALT_ESCAPE_SAME_
    if (i == KEY_PREFIX + 27) i = 27;
    #endif
    return(i);
  };

  void ConBeep()
  {
    printf( "\007" );
    fflush( stdout );
  };

#endif

// eof
