#include <ctype.h>

#include <unicon.h>
#include <vstring.h>
#include <scroll.h>
#include "conmenu.h"

#ifndef MAXX
#define MAXX ConMaxX()
#endif
#ifndef MAXY
#define MAXY ConMaxY()
#endif

int ConMenuBorders = 0;
int ConMenuBoxExitCh = 0;

int ConToggleBoxCN = 48; // normal
int ConToggleBoxCH = 47; // highlight
int ConToggleBoxTI = 95; // title
int ConToggleBox( int x, int y, const char *title, ToggleEntry* toggles )
{
  TScrollPos scroll;
  int z;

  int w = -1;
  int h = -1;

  int maxlen = 0;
  int count  = 0;
  while( toggles[count].key != -1 )
    {
    int sl = strlen( toggles[count].name );
    if (sl > maxlen) maxlen = sl;
    count++;
    }
  maxlen += 6+3; // 6 for state string and 3 for " key " string in the front

  if (w == -1) w = maxlen;
  if (h == -1) h = count;

  z = strlen(title);
  if (w < z) w = z;
  if (h > count) h = count;
  if (h == 0) h = 1;

  if (x + w > MAXX) w = MAXX - x - 1;
  if (y + h > MAXY-4) h = MAXY - y - 5;

  String str;
  String str1;
  String hots = "";
  for(z = 0; z < count; z++)
    if (strncmp("--", toggles[z].name, 2))
      StrAddCh( hots, toggles[z].key );
    else
      StrAddCh( hots,' ' );
  ConXY(x,y);
  int ch = 0;

  str = "";
  str = title;
  StrPad( str,-w, ConMenuBorders ? '-' : ' ' );
  if (str.len() > w) StrSLeft(str,w);
  if (ConMenuBorders)
    str = ".-" + str + "-.";
  else
    str = "  " + str + "  ";
  ConOut(x,y,str,ConToggleBoxTI);
  y++;

  scroll.settype(1);
  scroll.setwrap(0);
  scroll.min = 0;
  scroll.max = count-1;
  scroll.pagesize = h;
  scroll.pos = 0;
  scroll.page = 0;
  scroll.gotopos(0);

  while(1)
    {
    for( z = 0; z < scroll.pagesize; z++ )
      {
      if (scroll.page+z >= count)
        {
        str = " ~";
        StrPad( str, -(w+2), ' ');
        }
      else
        {
        int sep = (strncmp("--", toggles[scroll.page+z].name, 2) == 0);
        if (sep)
          {
          str = "";
          str += toggles[scroll.page+z].name;
          StrPad( str, -w, '-');
          str += "--";
          }
        else
          {
          str = " "; StrAddCh( str, toggles[scroll.page+z].key ); str += " ";
          str += toggles[scroll.page+z].name;
          StrPad( str, -(w-6), ' ');
          str1 = toggles[scroll.page+z].states[*(toggles[scroll.page+z].data)];
          StrPad( str1, 6, ' '); str1 += " ";
          str += " " + str1;
          }
        }
      if (ConMenuBorders)
        str = "|" + str + "|";
      else
        str = " " + str + " ";
//      if (str.len() > w) StrSLeft(str,w);
//      str = " " + str + " ";
      ConOut( x, y+z, str, ( scroll.page+z != scroll.pos ) ? ConToggleBoxCN : ConToggleBoxCH );
      }
    if (ConMenuBorders)
      {
      str = "";
      StrPad( str, w+2, '-' );
      str = "`" + str + "'";
      ConOut( x, y+scroll.pagesize, str, ConToggleBoxCN );
      }
    ch = ConGetch();
    ConMenuBoxExitCh = ch;

    if ( ch == KEY_UP    ) scroll.up();
    if ( ch == KEY_DOWN  ) scroll.down();
    if ( ch == KEY_NPAGE ) scroll.pagedown();
    if ( ch == KEY_PPAGE ) scroll.pageup();
    if ( ch == KEY_HOME  ) scroll.home();
    if ( ch == KEY_END   ) scroll.end();

    if ( ch < 0 || ch > 255 ) continue;
    if ( ch == 27 ) return 0;
    if ( ch == 13 /* && strncmp("--", toggles[scroll.pos].name, 2) */ ) return 1;
    z = ( ch == ' ' ) ? scroll.pos : z = StrFind( hots, ch );
    if (z > -1 && strncmp("--", toggles[z].name, 2) )
      {
      int state = *(toggles[z].data) + 1;
      if (toggles[z].states[state] == NULL) state = 0;
      *(toggles[z].data) = state;
      }
    }
  return -1;
}

int ConMenuBoxCN = 23; // normal
int ConMenuBoxCH = 47; // highlight
int ConMenuBoxTI = 95; // title
int ConMenuBoxAC = -1; // menu box alternative confirm
char ConMenuHideMagic[32] = "";
int ConMenuBox( int x, int y, const char *title, PSZCluster *sc, int hotkeys )
{
  TScrollPos scroll;
  int z;

  int w = -1;
  int h = -1;

  if (w == -1) w = (int)sc->maxlen();
  if (h == -1) h = sc->count();

  z = strlen(title);
  if (w < z) w = z;
  if (h > sc->count()) h = sc->count();
  if (h == 0) h = 1;

  if (x + w > MAXX) w = MAXX - x - 1;
  if (y + h > MAXY-5) h = MAXY - y - 5;

  String str;
  String hots = "";
  if ( hotkeys > -1 )
    {
    for(z = 0; z < sc->count(); z++)
      if (strncmp("--", sc->get(z), 2))
        StrAddCh( hots,int((const char*)(sc->get(z))[hotkeys]) );
      else
        StrAddCh( hots,' ' );
    StrUpCase(hots);
    }
  ConXY(x,y);
  int ch = 0;

  str = " ";
  str += title;
  str += " ";
  StrPad( str,-(w), ConMenuBorders ? '-' : ' ' );
  if (str.len() > w) StrSLeft(str,w);
  if (ConMenuBorders)
    str = ".-" + str + "-.";
  else
    str = "  " + str + "  ";
  ConOut(x,y,str,ConMenuBoxTI);
  y++;

  scroll.settype(1);
  scroll.setwrap(1);
  scroll.min = 0; scroll.max = sc->count()-1;
  scroll.pagesize = h;
  scroll.pos = 0; scroll.page = 0;
  scroll.gotopos(0);

  while(1)
    {
    for( z = 0; z < scroll.pagesize; z++ )
      {
      str = (scroll.page+z >= sc->count())? "~" : sc->get(scroll.page+z);

      if ( ConMenuHideMagic[0] )
        {
        int i = StrRFind( str, ConMenuHideMagic );
        if ( i != -1)
          StrSLeft( str, i );
        }
      
      StrPad( str,-w , (strncmp("--", str, 2) == 0)?'-':' ');
      if (str.len() > w) StrSLeft(str,w);
      if (ConMenuBorders)
        str = "| " + str + " |";
      else
        str = "  " + str + "  ";
      ConOut( x, y+z, str, ( scroll.page+z != scroll.pos ) ? ConMenuBoxCN : ConMenuBoxCH );
      }
    if (ConMenuBorders)
      {
      str = "";
      StrPad( str, w+2, '-' );
      str = "`" + str + "'";
      ConOut( x, y+scroll.pagesize, str, ConMenuBoxCN );
      }
    ch = ConGetch();
    ConMenuBoxExitCh = ch;

    if ( ch == KEY_UP    ) scroll.up();
    if ( ch == KEY_DOWN  ) scroll.down();
    if ( ch == KEY_NPAGE ) scroll.pagedown();
    if ( ch == KEY_PPAGE ) scroll.pageup();
    if ( ch == KEY_HOME  ) scroll.home();
    if ( ch == KEY_END   ) scroll.end();

    if ( ch < 0 || ch > 255 ) continue;
    if ( ch == 27 )
      {
      ConMenuBoxAC = -1;
      return -1;
      }
    if ( ch == 13 )
      {
      if (strncmp("--", sc->get(scroll.pos), 2) != 0) // ako e "--" e separator
        {
        ConMenuBoxExitCh = hots[scroll.pos];
        ConMenuBoxAC = -1;
        return scroll.pos;
        }
      }
    if ( ConMenuBoxAC > -1 && ch == ConMenuBoxAC )
      {
      if (strncmp("--", sc->get(scroll.pos), 2) != 0) // ako e "--" e separator
        {
        ConMenuBoxExitCh = hots[scroll.pos];
        ConMenuBoxAC = -2;
        return scroll.pos;
        }
      }
    z = StrFind( hots, toupper(ch) );
    if (z > -1)
      {
      ConMenuBoxExitCh = hots[z];
      ConMenuBoxAC = -1;
      return z;
      }
    }
  ConMenuBoxAC = -1;
  return -1;
};

