/*
 *
 * (c) Vladi Belperchinov-Shabanski "Cade" <cade@biscom.net> 1996-1999
 *
 * SEE `README',`LICENSE' OR `COPYING' FILE FOR LICENSE AND OTHER DETAILS!
 *
 */

#include "vfu.h"
#include "vfuopt.h"
#include "vfuuti.h"
#include "vfuview.h"
#include "vfumenu.h"

TOptions opt;

DCluster   TUXes;
PSZCluster History;
PSZCluster Panelizers;

char ArcTempFile[MAX_PATH];

pathstr_t TrimTree[MAX_TRIMS];
pathstr_t TrimLocate[MAX_TRIMS];

char *NOYES[] = { " - ", "YES", NULL };
char *FTIMETYPE[] = { "CREATE", "MODIFY", "ACCESS", NULL };
#ifdef _TARGET_GO32_
char *TAGMARKS[] = { ">>", "=>", "->", "", "", " ", "", NULL };
#else
char *TAGMARKS[] = { ">>", "=>", "->", NULL };
#endif

ToggleEntry Toggles[] =
{
//  { "[a] 1234567890123456", &(opt.some) },
  {  0 , "--screen--", NULL, NULL },
  { '1', "Show Attr      ", &(opt.fAttr), NOYES },
  { '2', "Show Owner     ", &(opt.fOwner), NOYES },
  { '3', "Show Group     ", &(opt.fGroup), NOYES },
  { '4', "Show Time      ", &(opt.fTime), NOYES },
  { '7', "     Time Type", &(opt.fTimeType), FTIMETYPE },
  { '5', "Show Size     ", &(opt.fSize), NOYES },
  { '6', "Show Type     ", &(opt.fType), NOYES },
  { 'l', "Show links    ", &(opt.ShowLinks), NOYES },
  { '>', "Long name view", &(opt.LongNameView), NOYES },
  { 'v', "VF View style   ", &(opt.VFStyle),  NOYES},
  { 't', "Top Dirs        ", &(opt.TopDirs), NOYES },
  { ' ', "TagMark view     ", &(opt.TagMark), TAGMARKS },
  { ' ', "File Colors     ", &(opt.FileColors), NOYES },
  { ' ', "Use /etc/DIR_COLORS", &(opt.UseDirColors), NOYES },
  { '.', "Hide `.names'   ", &(opt.HideDotNames), NOYES },
  #ifdef _TARGET_GO32_
  { ' ', "VF Filenames    ", &(opt.VFFilenames), NOYES },
  #endif
  {  0 , "--navigation--", NULL, NULL },
  { 'i', "Use Internal Viewer", &(opt.IntBrowser), NOYES },
  { 'I', "Use Internal Editor", &(opt.IntEditor), NOYES },
  { 'y', "Dynamic Scroll  ", &(opt.DynamicScroll), NOYES },
  { ' ', "Use Menu Borders", &(opt.MenuBorders), NOYES },
  {  0 , "--trees/dirs--" , NULL, NULL },
  { ' ', "Auto DirTree"   , &(opt.AutoTree), NOYES },
  { ' ', "Compact DirTree", &(opt.CompactTree), NOYES },
  { ' ', "DirTree Sizes"  , &(opt.DirTreeSizes), NOYES },
  { ' ', "Auto Update Dirs Size ", &(opt.AutoUpdateDSize), NOYES },
  { ' ', "CDTree (cdpath) ", &(opt.CDTree), NOYES },
  {  0 , "--troubleshooting--", NULL, NULL },
  { ' ', "CLS on Shell",     &(opt.CLSonShell), NOYES },
  {  0 , "--compatibility--", NULL, NULL },
  { ' ', "Is .TGZ == .tgz? i.e. archive?", &(opt.NoCaseArcs), NOYES },
  { ' ', "Alt Arrows Navigate ( <- -> )",       &(opt.AltArrowsNav), NOYES },
  { ' ', "Bash/Unix Style Files Completion",       &(opt.BashComplete), NOYES },
  { ' ', "FileFind Expand Mask", &(opt.FFExpandMask), NOYES },
  { ' ', "Files Mask Expand", &(opt.FMExpandMask), NOYES },
  { ' ', "General Mask Expand", &(opt.GENExpandMask), NOYES },
  { 'x', "Exit CD Hack",     &(opt.ExitCDHack), NOYES },
 { '\\', "Use DOS Slashes",  &(opt.DOSSlashes), NOYES },
  { ' ', "Same Case Keys! x == X != Alt+X", &(opt.SameCaseKeys), NOYES },
  {  0 , "--other--", NULL, NULL },
  { ' ', "Can Zap/Erase READ-ONLY Files?!",       &(opt.ZapROs), NOYES },
  { 'b', "Allow Beep!",       &(opt.AllowBeep), NOYES },
  { ' ', "Ask On Exit",       &(opt.AskExit), NOYES },
  { 's', "Free Space Check on Copy",  &(opt.FreeSpaceCheck), NOYES },
  { ' ', "Auto mount on change dir",  &(opt.AutoMount), NOYES},
  { ' ', "Preserve selection (after rescan)",  &(opt.PreserveSelection), NOYES},
  { ' ', "Preserve position on arrange",  &(opt.KeepArrangePos), NOYES},
  { ' ', "File Copy Preserve Owner/Group?", &(opt.FileCopyOwner), NOYES },
  { ' ', "Show Real Free Space (Not user's)", &(opt.RealFreeSpace), NOYES },
  {  -1, "---", NULL }
};

String RCDir;

time_t OptTime( struct stat st )
{
  if (opt.fTimeType == 0) return st.st_ctime; else
  if (opt.fTimeType == 1) return st.st_mtime; else
  if (opt.fTimeType == 2) return st.st_atime; else
  return 0;
};

time_t OptTime( time_t ctime, time_t mtime, time_t atime )
{
  if (opt.fTimeType == 0) return ctime; else
  if (opt.fTimeType == 1) return mtime; else
  if (opt.fTimeType == 2) return atime; else
  return 0;
}

void UseDirColors()
{
  #ifdef _TARGET_UNIX_

  // free all current colors
  for ( int z = 0; z < 16; z++ ) ExtColors[z][0] = 0;
  
  PSZCluster sc;
  sc.create( 16, 16 );
  LoadFromFile( "/etc/DIR_COLORS", &sc, 1024 );
  if (sc.count() == 0) return;

  while( sc.count() )
    {
    String str = sc[0];
    sc.free( 0 );
    int comment = StrFind( str, '#' );
    if ( comment != -1 ) StrSLeft( str, comment );
    StrCut( str, " \t" );
    if ( StrLen( str ) == 0 ) continue;

    if ( strncmp( str, "TERM "   , 5 ) == 0 ) continue;
    if ( strncmp( str, "COLOR "  , 6 ) == 0 ) continue;
    if ( strncmp( str, "OPTIONS ", 8 ) == 0 ) continue;

    int pos = -1;
    if ( StrFind( str, "31" ) != -1 ) pos = cRED; else
    if ( StrFind( str, "32" ) != -1 ) pos = cGREEN; else
    if ( StrFind( str, "33" ) != -1 ) pos = cYELLOW; else
    if ( StrFind( str, "34" ) != -1 ) pos = cBLUE; else
    if ( StrFind( str, "35" ) != -1 ) pos = cMAGENTA; else
    if ( StrFind( str, "36" ) != -1 ) pos = cCYAN; else
    if ( StrFind( str, "37" ) != -1 ) pos = cWHITE; else
    ;

    int spc = StrFind( str, ' ' );
    if ( spc == -1 || pos == -1 ) continue;
    StrSLeft( str, spc );

    StrReplace( str, "DIR", ".[].<>" );
    StrReplace( str, "LINK", ".->" );
    StrReplace( str, "FIFO", ".()" );
    StrReplace( str, "SOCK", ".##" );
    StrReplace( str, "BLK", ".==" );
    StrReplace( str, "CHR", ".++" );
    StrReplace( str, "EXEC", ".**" );

    StrInsert( ExtColors[pos], 0, str );
    
    };

  for ( int z = 0; z < 16; z++ )
    if( StrLen( ExtColors[z] ) > 0 )
      strcat( ExtColors[z], "." );
    
  #endif
};

void SetupFiles()
{
  #ifdef _TARGET_UNIX_
  if (access( CFGFILE, R_OK ) == 0); else
  if (access( VFU_RCPATH0 "vfurc", R_OK) == 0) CFGFILE =  VFU_RCPATH0 "vfurc"; else
  if (access( VFU_RCPATH1 "vfurc", R_OK) == 0) CFGFILE =  VFU_RCPATH1 "vfurc"; else
  if (access( VFU_RCPATH2 "vfurc", R_OK) == 0) CFGFILE =  VFU_RCPATH2 "vfurc";
  #endif
}

int SetSet( const char *line, const char *keyword, char *target )
{
  char temp[255];
  regexp *re = regcomp("^[ \011]*([a-zA-Z0-9]+)[ \011]*=[ \011]*(.+)");
  if (!regexec(re, line)) return 0;
  if (strcasecmp(keyword, regsubn(re, 1, temp)) != 0) return 0;
  regsubn(re, 2, target);
  free(re);
  return 1;
}

int SetSet( const char *line, const char *keyword, int &target )
{
  char temp[255];
  regexp *re = regcomp("^[ \011]*([a-zA-Z0-9]+)[ \011]*=[ \011]*([0123456789]+)");
  if (!regexec(re, line)) return 0;
  if (strcasecmp(keyword, regsubn(re, 1, temp)) != 0) return 0;
  regsubn(re, 2, temp);
  target = atoi(temp);
  free(re);
  return 1;
}

int SetSet( const char *line, const char *keyword, pathstr_t result[], int maxresults = -1 )
{
  char temp[1024];
  regexp *re = regcomp("^[ \011]*([a-zA-Z0-9]+)[ \011]*=[ \011]*(.+)");
  if (!regexec(re, line)) return 0;
  if (strcasecmp(keyword, regsubn(re, 1, temp)) != 0) return 0;
  regsubn(re, 2, temp);
  PathSplit( temp, PATH_DELIMS, result, maxresults );
  free(re);
  return 1;
}


void SetUX( regexp * re, int menucount )
{
char temp[64];
regexp *reFKEYS = regcomp( "[\\@\\^\\#]*[fF][01234567890]+" );

TUX ux;

regsubn(re, 1, ux.des);
regsubn(re, 2, temp);
regsubn(re, 3, ux.ext);
regsubn(re, 4, ux.sline);
#ifdef _TARGET_GO32_
LowString( ux.ext );
#endif
StrCutSpc( ux.ext );
StrCutSpc( temp ); StrUpCase( temp );
if (strcmp (temp, "IC"    ) == 0) ux.key = KEY_IC;
if (strcmp (temp, "INS"   ) == 0) ux.key = KEY_IC;
if (strcmp (temp, "INSERT") == 0) ux.key = KEY_IC;
if (strcmp (temp, "ENTER" ) == 0) ux.key = 13;
if (strcmp (temp, "RETURN") == 0) ux.key = 13;
if (strcmp (temp, "MENU") == 0  ) ux.key = - menucount;
if (reFKEYS)
  if (regexec( reFKEYS, temp ))
    {
    if ( toupper(temp[0]) == 'F' )
      ux.key = KEY_F1 + atoi( temp + 1 ) - 1; else
    if ( toupper(temp[0]) == '@' )
      ux.key = KEY_ALT_F1 + atoi( temp + 2 ) - 1; else
    if ( toupper(temp[0]) == '^' )
      ux.key = KEY_CTRL_F1 + atoi( temp + 2 ) - 1; else
    if ( toupper(temp[0]) == '#' )
      ux.key = KEY_SH_F1 + atoi( temp + 2 ) - 1;
    }

TUXes.add( &ux );
}

void LoadSettings()
{
TUXes.done();
TUXes.create( 8, 8, sizeof(TUX) );

History.done();
History.create( 16, 16 );

SeeFilters.done();
SeeFilters.create( 16, 16 );

Panelizers.done();
Panelizers.create( 16, 16 );

FILE *fsett;

//---------------------------------------------------------
TOptions tmp_opt;
memset( &tmp_opt, 0, sizeof( tmp_opt ) );
if ( fload_crc32( OPTFILE, &tmp_opt, sizeof( tmp_opt ) ) == 0 )
  memcpy( &opt, &tmp_opt, sizeof(TOptions) );
else
  say1( "warning: bad vfu.options file, loading defaults..." );
//---------------------------------------------------------
LoadFromFile( HISTFILE, &History, MAX_PATH );
//---------------------------------------------------------

if (getenv("EDITOR"))
  {
  strcpy(Editor,  getenv("EDITOR"));
  strcat(Editor, " %f");
  }
if (getenv("PAGER") )
  {
  strcpy(Browser, getenv("PAGER"));
  strcat(Browser, " %f");
  }

regexp *re = regcomp("^[ \011]*u?x[ \011]*=[ \011]*([^,]*),([^,]*),([^,]*),(.*)$");
regexp *re_see = regcomp( "^[ \011]*see[ \011]*=[ \011]*([^,]*),(.*)$" );
regexp *re_pan = regcomp( "^[ \011]*panelize[ \011]*=[ \011]*([^,]*),(.*)$" );

#define opti(key,target) if(SetSet(line, key, target)) continue

char line[1024];
if ( (fsett = fopen(CFGFILE, "r")) )
  {
  int menucount = 0; // used to simulate fake keys for menu items in user externals
  while(fgets(line, 1024, fsett))
    {
    if ( line[0] == '#' ) continue;
    if ( line[0] == ';' ) continue;
    StrCut( line, "\n\r" );
    // StrCutL( line, " \t" );
  
    if(regexec(re, line))
      {
      SetUX( re, ++menucount );
      continue;
      }
  
    opti("browser", Browser);
    opti("pager", Browser);
    opti("editor", Editor);
    opti("presetdir1", PresetDir[1]);
    opti("presetdir2", PresetDir[2]);
    opti("presetdir3", PresetDir[3]);
    opti("presetdir4", PresetDir[4]);
    opti("presetdir5", PresetDir[5]);
    opti("presetdir6", PresetDir[6]);
    opti("presetdir7", PresetDir[7]);
    opti("presetdir8", PresetDir[8]);
    opti("presetdir9", PresetDir[9]);
  
    opti("dir1", PresetDir[1]);
    opti("dir2", PresetDir[2]);
    opti("dir3", PresetDir[3]);
    opti("dir4", PresetDir[4]);
    opti("dir5", PresetDir[5]);
    opti("dir6", PresetDir[6]);
    opti("dir7", PresetDir[7]);
    opti("dir8", PresetDir[8]);
    opti("dir9", PresetDir[9]);
  
  //opti("cBLACK"   , ExtColors[0]);
    opti("cGREEN"   , ExtColors[cGREEN]);
    opti("cRED"     , ExtColors[cRED]);
    opti("cCYAN"    , ExtColors[cCYAN]);
    opti("cWHITE"   , ExtColors[cWHITE]);
    opti("cMAGENTA" , ExtColors[cMAGENTA]);
    opti("cBLUE"    , ExtColors[cBLUE]);
    opti("cYELLOW"  , ExtColors[cYELLOW]);
    opti("chBLACK"  , ExtColors[chBLACK]);
    opti("chGREEN"  , ExtColors[chGREEN]);
    opti("chRED"    , ExtColors[chRED]);
    opti("chCYAN"   , ExtColors[chCYAN]);
    opti("chWHITE"  , ExtColors[chWHITE]);
    opti("chMAGENTA", ExtColors[chMAGENTA]);
    opti("chBLUE"   , ExtColors[chBLUE]);
    opti("chYELLOW" , ExtColors[chYELLOW]);
  
    opti("ShellOpt" , ShellOpt     );
  
    if(SetSet(line, "TrimTree", TrimTree, MAX_TRIMS))continue;
    if(SetSet(line, "TrimLocate", TrimLocate, MAX_TRIMS))continue;
    if(SetSet(line, "ArcTempFile", ArcTempFile ))continue;

    if ( regexec( re_see, line ) )
      {
      String str;
      regsubn( re_see, 1, sss ); // get fnmatch mask
      str += sss;
      str += ",";
      regsubn( re_see, 2, sss ); // get shell line
      str += sss;
      SeeFilters.add( str );
      continue;
      } else
    if ( regexec( re_pan, line ) )
      {
      String str;
      regsubn( re_pan, 1, sss ); // get description
      str += sss;
      str += ",";
      regsubn( re_pan, 2, sss ); // get shell line
      str += sss;
      Panelizers.add( str );
      continue;
      }
    }
  fclose(fsett);
  }

free( re );
free( re_see );
free( re_pan );
  
#ifdef _TARGET_GO32_
int z;
for ( z = 0; z < 16; z++ ) LowString( ExtColors[z] );
#endif

if (opt.UseDirColors)
  UseDirColors();

}

void SaveSettings()
{
  fsave_crc32( OPTFILE, &opt, sizeof(opt));
  SaveToFile( HISTFILE, &History );
}

// seed.cpp externals -- no .h file
extern int SeedSLColor; // status line color
extern int SeedInit();
extern int SeedAddFile( const char* fname );
extern int Seed();

void EditCfgFile()
{
  if (opt.IntEditor)
    {
    SeedSLColor = cINFO;
    SeedInit();
    SeedAddFile( CFGFILE );
    Seed();
    }
  else
    {
    String line = Editor;
    StrReplace( line, "%f", CFGFILE );
    StrReplace( line, "%F", CFGFILE );
    Shell( line.asis(), 0 );
    }
  SaveSettings();
  LoadSettings();
  draw = 1;
  DrawPointer();
}

/*
void DrawToggle( int n )
{
  String str;
  int x = (n / (PS+2))*32 + 1;
  int y = n % (PS+2) + 3;
  ConXY( x, y );
  ConPuts( "[", cCYAN );
  StrAddCh( str, Toggles[n].key );
  ConPuts( str, chYELLOW );
  str = "] ";
  str += Toggles[n].name;
  ConPuts( str, cCYAN );
  if ( Toggles[n].data )
    {
    if ( strstr(Toggles[n].states[*(Toggles[n].data)], " no ") == NULL )
      ConPuts( Toggles[n].states[*(Toggles[n].data)], chCYAN );
    else
      ConPuts( Toggles[n].states[*(Toggles[n].data)], cRED );
    }
};

void DoToggles( int one )
{
  int loopcount = 0;
  ConCS();
  ConOut( 1, 1, HEADER, chYELLOW );
  if (one)
    say1( "Hint: Press `O' to set/clear more than one option at a time." );
  else
    say1( "Hint: Press `o' to set/clear just one option & exit." );
  ConTA( cCYAN );
  int z = 0;
  while( strcmp(Toggles[z].name, "---") != 0 )
    {
    DrawToggle(z);
    z++;
    }
  char ch = ' ';
  while( ch != 13 && ch != 27 )
    {
    int z = 0;
    while( Toggles[z].key != -1 )
      {
      if (Toggles[z].key == ch)
        {
//        *(Toggles[z].data) = !(*(Toggles[z].data));
        int state = *(Toggles[z].data) + 1;
        if (Toggles[z].states[state] == NULL) state = 0;
        *(Toggles[z].data) = state;
        DrawToggle(z);
        break;
        }
      z++;
      }
    ConXY( 1, MAXY );
    if (one && loopcount == 1) break;
    ch = ConGetch();
    loopcount++;
    }
  draw = 1;
  say1( "" );
  //############################ HERE WE HAVE TO HANDLE CHANGES ##########
  FINDEX.settype( opt.DynamicScroll );

  //############################ OK -- IT'S OVER #########################
  RefreshAllViews();
}
*/

extern int PSZViewME; // minus exit
void DoToggles( int one )
{
  ToggleBox( 30, 5, "Options/Toggles   (scroll down...)", Toggles );

  //############################ HERE WE HAVE TO HANDLE CHANGES ##########
  FINDEX.settype( opt.DynamicScroll );
  RefreshAllViews();
  ReDraw(); // menus style has changed
  ReDrawSta(); // menus style has changed

  //############################ OK -- IT'S OVER #########################
  ReDraw();
};

