/*
 *
 * (c) Vladi Belperchinov-Shabanski "Cade" <cade@biscom.net> 1996-1999
 *
 * SEE `README',`LICENSE' OR `COPYING' FILE FOR LICENSE AND OTHER DETAILS!
 *
 */

#ifndef _VFU_H_
#define _VFU_H_

#define HEADER "VF/U v1.51 by (c) Vladi Belperchinov-Shabanski `Cade' 1996-1999  (`H' for help) \n"

// ############################################ INCLUDE's ###############

  #include <dirent.h>
  #include <sys/types.h>
  #include <sys/stat.h>
  #include <sys/wait.h>

  #include <stdio.h>
  #include <stdlib.h>
  #include <unistd.h>
  #include <string.h>
  #include <time.h>
  #include <utime.h>
  #include <assert.h>
  #include <ctype.h>
  #include <grp.h>
  #include <pwd.h>
  #include <errno.h>
  #include <signal.h>

  #include <vslib.h>

  #ifdef _TARGET_NETBSD_
    #include <sys/param.h>
    #include <sys/mount.h>
  #else
    #include <sys/vfs.h>
  #endif

  #include "vfusetup.h"

  #include "vfusys.h" // for attrs_t

  #ifndef ASSERT
  #define ASSERT
  #endif

  #ifndef Yes
  #define Yes   1
  #endif
  #ifndef No
  #define No    0
  #endif

  #ifndef MAX_PATH
  #define MAX_PATH 512
  #endif

  #define MaxFiles   64000

  #define MAXX  ConMaxX()
  #define MAXY  ConMaxY()

  #define stricmp strcasecmp

// ############################################ COMPATIBILITY DEF's #####

#ifdef _TARGET_GO32_
  #define S_ISLNK( p ) 0
  #define S_ISSOCK( p ) 0
  #define lstat(n,p) memset(p,0,sizeof(p))
  #define cuserid(x)    0

  #define FNMATCH_FLAGS FNM_CASEFOLD
  #define FNCASE        0
  #define PATH_DELIMS   " ,;\t"
#endif

#ifdef _TARGET_UNIX_
  #define FNMATCH_FLAGS 0
  #define FNCASE        1
  #define PATH_DELIMS   " ,:\t"
#endif

#define FNMATCH(p,s) fnmatch((p),(s),FNMATCH_FLAGS)

// ############################################ MISC ####################

  #define wmNormal      0
  #define wmInArchive   1

  extern int WorkMode;
  extern char AName[MAX_PATH]; // archive name
  extern int AX; // archive index

// #define GetStr( s ) TextInput( 1, MAXY, "", MAXX-3, MAXX-3, s )

  typedef char pathstr_t[MAX_PATH];
  typedef char char128[128];

#define fsize_t double  // used as standard long long, long/int32 overflows

struct TF
  {
  char          name[512];
  char*         fname; // points to the file name ( after the last `/'! )
  struct stat   st;
  char          sttype[3];
  attrs_t       stmode;
  int           is_link;
  int           is_dir;
  fsize_t       size;
  int           sel;
  int           x; // misc used extra field
  char128       view; // it normally can go just to 80, i.e. screen width
  int           color; // view colors
  };

extern TF* Files[MaxFiles];

extern int FilesCount;
extern int SelCount;
extern fsize_t SelSize;
extern fsize_t AllSize;
extern fsize_t FSFree;
extern fsize_t FSTotal;
extern fsize_t FSBSize;

extern TScrollPos FINDEX; // index in the files list
#define FLI       (FINDEX.pos)
#define FLP       (FINDEX.page)
#define PS        (FINDEX.pagesize)
#define FGO(n)    (FINDEX.gotopos(n))

extern char sss[2048];
extern char TargetDir[MAX_PATH];
extern char CPath[MAX_PATH]; // current path (working dir)
extern char SD[MAX_PATH]; // startup dir
extern char HOME[MAX_PATH];
extern char TEMP[MAX_PATH];

#define MAX_FMASKS       10
extern char FMASK[MAX_PATH];
extern pathstr_t FMASKARRAY[MAX_FMASKS];

// ############################################ GLOBAL DEFINES  #########

#define STATLINE1       (MAXY - 3)
#define STATLINE2       (MAXY - 2)

// history id's
#define HID_GREP        10
#define HID_GS_MASK     20
#define HID_GS_GREP     30
#define HID_MKPATH      40
#define HID_FFMASK      50
#define HID_FFPATH      60
#define HID_FFGREP      70
#define HID_EE_TIME     80 // entry edit
#define HID_EE_OWNER    90 // entry edit
#define HID_SHELL_PAR  100
#define HID_FMASK      110
#define HID_COMMANDS   120
#define HID_GETDIR     130
#define HID_CHDIR      140

// ############################################ GLOBAL STRUCTS  #########

extern PSZCluster DirTree;
extern String     DTFile;

extern PSZCluster ffr; // filefind results

// ############################################ CONFIG SETTINGS #########

  extern pathstr_t PresetDir[10];

  // ---colors---------------
  extern pathstr_t ExtColors[16];

  extern char Browser[MAX_PATH];
  extern char Editor[MAX_PATH];

  extern char ShellOpt[1024];
  extern char UIDstr[32];
  extern char GIDstr[32];
  extern char HOSTstr[32];

// ######################################################################

extern int SelMarkPos; // this is set by RedrawScreen
extern int TagMarkPos; // this is set by RedrawScreen

#define ClearSel     ConOut( SelMarkPos, FLI-FLP+4, " " , chWHITE )
#define DrawSel      ConOut( SelMarkPos, FLI-FLP+4, "#" , chWHITE )

extern int draw;


///////////////////////////////////////////////////////////////////////////
//
// file: vfu.cpp
//

void DescribeErrno();
void DescribeErrno( const char *format, const char *par1 );
void say1(const char *o, int attr = chWHITE );
void say2(const char *o, int attr = chWHITE );
int inputstr( int x, int y, char *target );
int EditAttr( char *attrs );
void Shell( const char *command, int waitafter, int chdir_back = 1 );
void CalcStat();
void GetCPath();
void cls();
void EditFile();
void Browse( const char *fname );
void ActionPlus();
void ActionMinus();
void GlobalSelect();
int FindUserExternal( int pKey );
void UserExternals( int pKey );
void GotoPresetDir( int n );
void DirsSizes( int n );
void FileFind();
void FileFindResults();
void Tools();
void Command();
void rollattr( const int n, char *attrs );
void EditEntry( );
void Options();
void Help();
void VFUinit();
void VFUrun();
void VFUdone();
void VFUsignal( int sig );

///////////////////////////////////////////////////////////////////////////
//
// other files...
//

int GetStr( char* target, int hist_id, int x = -1, int y = -1 ); // vfuuti.cpp

#endif//_VFU_H_
