/* Uptimed 0.03
   (c) Copyright 1998 Rob Kaper (cap@capsi.com)
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <sys/utsname.h>
       
FILE	*f;
char	str[256], sys[32];
time_t	utime;
time_t	btime;
int	pid;

int main(int, char**);
char *time2unix(time_t);
int updatelog();
int createlog();
int createbootid();
int readbootid();
int readsysinfo();

int main(int argc, char **argv)
{
	if (argv[1] && !strcasecmp(argv[1], "-boot")) { createbootid(); exit(0); }
	else readbootid();

	switch(fork())
	{
		case 0: case -1:
			break;
		default:
			exit(-1);
	}

	readsysinfo();
	while (1)
	{
		f=fopen("/proc/uptime", "r");
		if (!f) printf ("uptimed: error opening /proc file!\n");
		else
		{
			fgets(str, sizeof(str), f);
			utime=atoi(str);
			fclose(f);
			updatelog();
		}
		sleep(5);
	}
}

char *time2unix (time_t t)
{
	static char	timebuf[20] = "";
	int		sec, min, hour, day;

	sec = t % 60;
	t /= 60;
	min = t % 60;
	t /= 60;
	hour = t % 24;
	t /= 24;
	day = t;

	sprintf(timebuf,"%d %s, %.2d:%.2d:%.2d", day, (day == 1 ? "day" : "days"), hour, min, sec); 
	return timebuf;
}

int createlog()
{
	int	i=0;
	
	f=fopen("/etc/uptimed.log", "w");
	if (!f) { printf("uptimed: cannot create log file, exiting!\n");  exit(-1); }
	else
	{
		/* sample data */
		for (i=0;i<10;i++) fprintf(f, "%d:%d:%s\n", 0, 0, "unknown");
		fclose(f);
	}
	return 0;
}

int createbootid()
{
	f=fopen("/proc/stat", "r");
	if (!f) { printf ("uptimed: error opening /proc file, exiting!\n"); exit(-1); }
	else
	{
		fgets(str, sizeof(str), f);
		while(!feof(f))
		{
			if (strstr(str, "btime"))
			{
				btime=atoi(str+6);
				break;
			}
			fgets(str, sizeof(str), f);
		}
		fclose(f);
	}
	
	f=fopen("/var/run/uptimed.bootid", "w");
	if (!f) { printf("uptimed: cannot create boot id, exiting!\n");  exit(-1); }
	else
	{
		fprintf(f, "%ld\n", btime);
		fclose(f);
	}
	return 0;
}

int readbootid()
{
	f=fopen("/var/run/uptimed.bootid", "r");
	if (!f) { printf("uptimed: cannot read boot id, exiting!\n");  exit(-1); }
	else
	{
		fgets(str, sizeof(str), f);
		btime=atoi(str);
		fclose(f);
	}
	return 0;
}

int updatelog()
{
	time_t	btime_arr[10], utime_arr[10];
	char	sys_arr[10][32];
	int	i=0, wrotecurrent=0;
	
	f=fopen("/etc/uptimed.log", "r");
	if (!f)
	{
		printf("uptimed: cannot read log file, creating one\n");
		createlog();
		f=fopen("/etc/uptimed.log", "r");
	}

	for (i=0;i<10;i++)
	{
		fgets(str, sizeof(str), f);
		utime_arr[i]=atoi(strtok(str, ":"));
		btime_arr[i]=atoi(strtok(NULL, ":"));
		strcpy(sys_arr[i], strtok(NULL, "\n"));
	}
	fclose(f);

	f=fopen("/etc/uptimed.log", "w");
	if (!f) { printf("uptimed: cannot write to log file, exiting!\n");  exit(-1); }

	for (i=0;i<10;i++)
	{
		if (utime_arr[i]>=utime)
		{
			if ((btime-btime_arr[i]>5) || (btime-btime_arr[i]<-5)) fprintf(f, "%ld:%ld:%s\n", utime_arr[i], btime_arr[i], sys_arr[i]);
		}
		else
		{
			if (!wrotecurrent)
			{
				fprintf(f, "%ld:%ld:%s\n", utime, btime, sys);
				wrotecurrent++;
			}
			if ((btime-btime_arr[i]>5) || (btime-btime_arr[i]<-5)) fprintf(f, "%ld:%ld:%s\n", utime_arr[i], btime_arr[i], sys_arr[i]);
		}
	}
	fclose(f);
	return 0;
}

int readsysinfo()
{
	struct utsname temp_uname;

	if (!uname(&temp_uname)) sprintf(sys, "%s %s", temp_uname.sysname, temp_uname.release);
	else sprintf(sys, "unknown");

	return 0;
}
