/*
 * Hardware tuning for the VIA 82C597_0 PCI-to-PCI/AGP bridge
 */

#define PCI_DEVICE_ID_VIA_597_1 0x8597

// Commented out tweaks need double checking to find optimal values.

static Tweaks_t VIA_82C597_1_Tweaks[] = {
	{ "CPU_TO_AGP_POSTED_WRITES",	0x40,	1<<7,	1<<7,	"CPU->AGP posted writes" },
	{ "CPU_TO_AGP_DYNAMIC_BURST",	0x40,	1<<6,	1<<6,	"CPU->AGP dynamic burst" },
	{ "CPU_TO_AGP_1WS_BURST_WRITE",	0x40,	1<<5,	1<<5,	"CPU->AGP 1WS burst write" },
//	{ "CPU_TO_AGP_RETRY_COUNT",		0x40,	1<<,	1<<,	"CPU->AGP retry count" },
	{ "CPU_BACKOFF_ON_AGP_RD_RETRY",	0x41,	1<<2,	1<<2,	"CPU backoff on AGP read retry timeout" },
//	{ "READ_PREFETCH_FOR_ENHANCE",	0x42,	1<<7,	0<<7,	"Always prefetch for enhance command" },
	{ "AGP_1WS_WRITE",				0x42,	1<<6,	1<<6,	"AGP 1WS write" },
	{ "AGP_1WS_READ",				0x42,	1<<5,	1<<5,	"AGP 1WS read" },
	{ 0, 0, 0, 0, 0 }
};
