/*
 * Hardware tuning for the VIA 82C586_0 PCI-to-ISA bridge
 */

#define PCI_DEVICE_ID_VIA_586_0 0x0586

static Tweaks_t VIA_82C586_0_Tweaks[] = {
	{ "ISA_COMMAND_DELAY",		0x40,	1<<7,	0<<7,	"ISA command delay" },
	{ "EXTENDED_ISA_READY",		0x40,	1<<6,	0<<6,	"Extended ISA bus ready" },
	{ "ISA_SLAVE_WS",			0x40,	1<<5,	0<<5,	"ISA Slave 4WS" },
	{ "CHIPSET_IO_WS",			0x40,	1<<4,	0<<4,	"Chipset I/O 2WS" },
	{ "IO_RECOVERY",			0x40,	1<<3,	0<<3,	"IO Recovery time" },
	{ "EXTEND_ALE",				0x40,	1<<2,	1<<2,	"Extend ALE" },
	{ "ROM_WS",					0x40,	1<<1,	1<<1,	"ROM 0WS" },
	{ "PCI_BURST_INTERRUPTING",	0x46,	1<<1,	0<<1,	"PCI burst interrupting" },
	{ "POST_MEM_WRITE",			0x46,	1<<0,	1<<0,	"Post memory write enable" },
	{ "PCI_DELAY_TRANSACTION",	0x47,	1<<6,	1<<6,	"PCI delayed transactions" },
	{ "WR_DELAY_TRANSACTION_TO",0x47,	1<<2,	1<<2,	"Write delay transaction timeout timer enable" },
	{ "RD_DELAY_TRANSACTION_TO",0x47,	1<<1,	1<<1,	"Read delay transaction timeout timer enable" },
	{ 0, 0, 0, 0, 0 }
};
