/*
 * Copyright (c) 2000 Dave Jones <dave@powertweak.com>
 *
 * Can be freely distributed and used under the terms of the GNU GPL.
 */


#define PCI_VENDOR_ID_DEC		0x1011
#define PCI_VENDOR_ID_MATROX	0x102b
#define PCI_VENDOR_ID_UMC		0x1060
#define PCI_VENDOR_ID_VIA		0x1106
#define PCI_VENDOR_ID_Intel		0x8086

#include "DEC/DECchip_21050.c"
#include "Intel/824xx.c"
#include "Intel/8243x.c"
#include "Intel/82437.c"
#include "Intel/82439.c"
#include "Intel/82443_BX.c"
#include "Intel/82443_LX.c"
#include "Matrox/g200.c"
#include "VIA/82C586_0.c"
#include "VIA/82C586_1.c"
#include "VIA/82C597_0.c"
#include "VIA/82C597_1.c"
#include "VIA/82C598_1.c"
#include "UMC/8891A.c"


typedef unsigned int (*count_gadgets_ptr)(struct pci_dev *);
typedef void (*add_gadgets_ptr)(GtkWidget *table, struct pci_dev *, unsigned int numbuttons);
typedef void (*extended_info_ptr)(GtkWidget *notebook, struct pci_dev *current_pci_dev);
typedef void (*save_function_ptr)(FILE *savehandle, struct pci_dev *);
typedef void (*init_function_ptr)(struct pci_dev *);


struct devinfo {
	unsigned short vendor, device;
	extended_info_ptr extended_info;
	count_gadgets_ptr gadget_counter;
	init_function_ptr init_func;
	add_gadgets_ptr gadget_adder;
	save_function_ptr save_func;

} known_devlist[] = {
 { PCI_VENDOR_ID_DEC,	PCI_DEVICE_ID_DEC_21050,
		NULL,
		getnumtweaks_DEC_21050,
		init_DEC_21050,
		tune_DEC_21050,
		save_DEC_21050 },

 { PCI_VENDOR_ID_INTEL,	PCI_DEVICE_ID_Intel_82424,
		NULL,
		getnumtweaks_Intel_824xx,
		init_Intel_824xx,
		tune_Intel_824xx,
		save_Intel_824xx },

 { PCI_VENDOR_ID_INTEL,	PCI_DEVICE_ID_Intel_82430,
		NULL,
		getnumtweaks_Intel_824xx,
		init_Intel_824xx,
		tune_Intel_824xx,
		save_Intel_824xx },

 { PCI_VENDOR_ID_INTEL,	PCI_DEVICE_ID_Intel_82434,
		NULL,
		getnumtweaks_Intel_824xx,
		init_Intel_824xx,
		tune_Intel_824xx,
		save_Intel_824xx },

 { PCI_VENDOR_ID_INTEL,	PCI_DEVICE_ID_Intel_82437FX,
		NULL,
		getnumtweaks_Intel_8243x,
		init_Intel_8243x,
		tune_Intel_8243x,
 		save_Intel_8243x },

 { PCI_VENDOR_ID_INTEL,	PCI_DEVICE_ID_Intel_82439HX,
		NULL,
		getnumtweaks_Intel_8243x,
		init_Intel_8243x,
		tune_Intel_8243x,
 		save_Intel_8243x },

 { PCI_VENDOR_ID_INTEL,	PCI_DEVICE_ID_Intel_82437VX,
		NULL,
		getnumtweaks_Intel_82437VX,
		init_Intel_82437VX,
		tune_Intel_82437VX,
 		save_Intel_82437VX },

 { PCI_VENDOR_ID_INTEL,	PCI_DEVICE_ID_Intel_82439TX,
		NULL,
		getnumtweaks_Intel_82439TX,
		init_Intel_82439TX,
		tune_Intel_82439TX,
		save_Intel_82439TX },

 { PCI_VENDOR_ID_INTEL,	PCI_DEVICE_ID_Intel_82443LX,
		NULL,
		getnumtweaks_Intel_82443LX,
		init_Intel_82443LX,
		tune_Intel_82443LX,
		save_Intel_82443LX },

 { PCI_VENDOR_ID_INTEL,	PCI_DEVICE_ID_Intel_82443BX,
		NULL,
		getnumtweaks_Intel_82443BX,
		init_Intel_82443BX,
		tune_Intel_82443BX,
 		save_Intel_82443BX },

 { PCI_VENDOR_ID_INTEL,	PCI_DEVICE_ID_Intel_82443BX_NOAGP,
		NULL,
		getnumtweaks_Intel_82443BX,
		init_Intel_82443BX,
		tune_Intel_82443BX,
 		save_Intel_82443BX },

 { PCI_VENDOR_ID_VIA, PCI_DEVICE_ID_VIA_586_0,
		NULL,
		getnumtweaks_VIA_586_0,
		init_VIA_586_0,
		tune_VIA_586_0,
 		save_VIA_586_0 },

 { PCI_VENDOR_ID_VIA, PCI_DEVICE_ID_VIA_586_1,
		NULL,
		getnumtweaks_VIA_586_1,
		init_VIA_586_1,
		tune_VIA_586_1,
		save_VIA_586_1 },

 { PCI_VENDOR_ID_VIA, PCI_DEVICE_ID_VIA_597_0,
		NULL,
		getnumtweaks_VIA_597_0,
		init_VIA_597_0,
		tune_VIA_597_0,
 		save_VIA_597_0 },

 { PCI_VENDOR_ID_VIA, PCI_DEVICE_ID_VIA_597_1,
		NULL,
		getnumtweaks_VIA_597_1,
		init_VIA_597_1,
		tune_VIA_597_1,
 		save_VIA_597_1 },

 { PCI_VENDOR_ID_VIA, PCI_DEVICE_ID_VIA_598_1,
		NULL,
		getnumtweaks_VIA_598_1,
		init_VIA_598_1,
		tune_VIA_598_1,
 		save_VIA_598_1 },

 { PCI_VENDOR_ID_UMC,	PCI_DEVICE_ID_UMC_8891A,
		NULL,
		getnumtweaks_UMC_8891A,
		init_UMC_8891A,
		tune_UMC_8891A,
 		save_UMC_8891A },

 { PCI_VENDOR_ID_MATROX, PCI_DEVICE_ID_MATROX_G200,
		Show_G200_info,
		0,
		0,
		0,
		0 },

 { 0, 0, 0, 0, 0, 0, 0 }
};
