/*
 * Hardware tuning for the VIA 82C598_0 PCI-to-PCI/AGP bridge
 */

#define PCI_DEVICE_ID_VIA_598_1 0x8598
 
static Tweaks_t VIA_82C598_1_Tweaks[] = {
	{ "AGP_POST_WRITE_ENABLE",
		0x40,
		1<<7,
		1<<7,
		"AGP posted write",
		"1",
		0, 0 },

	{ "AGP_DYNAMIC_BURST_ENABLE",
		0x40,
		1<<6,
		1<<6,
		"AGP dynamic burst",
		"1",
		0, 0 },

	{ "AGP_ONE_WS_BURST_WRITE_ENABLE",
		0x40,
		1<<5,
		1<<5,
		"AGP 1 WS write burst",
		"1",
		0, 0 },

	{ "AGP_TO_DRAM_PREFETCH_ENABLE",
		0x40,
		1<<4,
		1<<4,
		"AGP to DRAM prefetch",
		"1",
		0, 0 },

	{ "AGP_MASTER_GRANT_BEFORE_FLUSH",
		0x40,
		1<<3,
		1<<3,
		"AGP dynamic burst",
		"1",
		0, 0 },

	{ "AGP_MASTER_READ_CACHE",
		0x40,
		1<<1,
		1<<1,
		"AGP Master read cache",
		"1",
		0, 0 },

	{ "AGP_DELAY_TRANSACTION",
		0x40,
		1<<0,
		1<<0,
		"AGP Delay trasaction",
		"1",
		0, 0 },

	{ "AGP_RETRY_COUNT_4",
		0x41,
		1<<4,
		1<<4,
		"AGP retry 4 times and backoff CPU",
		"1",
		0, 0 },

	{ "AGP_CPU_BACKOFF_TIMEOUT",
		0x41,
		1<<2,
		1<<2,
		"AGP Backoff CPU on read retry failure",
		"1",
		0, 0 },

	{ "CPU_TO_AGP_POST_WRITE_IO",
		0x41,
		1<<1,
		1<<1,
		"CPU to AGP I/O posted write",
		"1",
		0, 0 },

	{ "AGP_PREFETCH_ONLY_ENHANCE",
		0x42,
		1<<7,
		1<<7,
		"AGP Prefetch only if enhance command",
		"1",
		0, 0 },

	{ "AGP_MASTER_1WS_WRITE",
		0x42,
		1<<6,
		1<<6,
		"AGP Master 1 WS write",
		"1",
		0, 0 },

	{ "AGP_MASTER_1WS_READ",
		0x42,
		1<<5,
		1<<5,
		"AGP Master 1 WS read",
		"1",
		0, 0 },

	{ "AGP_EFFICENT_DUMMY_CYCLES",
		0x42,
		1<<4,
		1<<4,
		"AGP Efficent handling of dummy cycles",
		"1",
		0, 0 },

	{ "AGP_WRITE_TIMEOUT_STOP",
		0x42,
		1<<3,
		1<<3,
		"AGP Write timeout asserts #STOP",
		"1",
		0, 0 },

	{ "AGP_READ_TIMEOUT_STOP",
		0x42,
		1<<2,
		1<<2,
		"AGP Read timeout asserts #STOP",
		"1",
		0, 0 },

	{ 0, 0, 0, 0, 0, 0, 0, 0 }
};
