/*
 * Hardware tuning for the VIA 82C597_0 Host bridge
 *
 * Dave Jones		:	Initial VP3 support
 */

#include "82C597_0_VP3.h"
#include "82C597_0_MVP3.h"

unsigned int getnumtweaks_VIA_597_0(struct pci_dev *current_dev)
{
	word revision_id;
	revision_id = (pci_read_word (current_dev, PCI_REVISION_ID));

	switch (pci_read_word (current_dev, PCI_REVISION_ID)) {

		/* VP3 ? */
		case 0 ... 3:
			return (sizeof(VIA_82C597_0_Tweaks)/sizeof(Tweaks_t))-1;

		/* A rev 4 or above is an 82C598 pretending to be an 82C597 */
		case 4:
			return (sizeof(VIA_82C597_0_MVP3_Tweaks)/sizeof(Tweaks_t))-1;

		default:
   			return (0);
	}
}

void init_VIA_597_0(struct pci_dev *current_dev)
{
	init_tweaks(getnumtweaks_VIA_597_0(current_dev), VIA_82C597_0_Tweaks, current_dev);
}

void tune_VIA_597_0(GtkWidget *table, struct pci_dev *current_dev, unsigned int numbuttons)
{
	int column=0;
	unsigned int index;
	unsigned char dummy;
	Tweaks_t *Tweaks;

	switch (pci_read_word (current_dev, PCI_REVISION_ID)) {

		/* VP3 ? */
		case 0 ... 3:
			Tweaks = VIA_82C597_0_Tweaks;
			for (index=0;index<numbuttons;index++) {
			    CreateButton(table, Tweaks, current_dev, column);
			    column++;
			    Tweaks++;
			}
			break;

		/* MVP3 ? */
		case 4:
			Tweaks = VIA_82C597_0_MVP3_Tweaks;
			for (index=0;index<numbuttons;index++) {
			    CreateButton(table, Tweaks, current_dev, column);
			    column++;
			    Tweaks++;
			}
			break;

		default:
			/* If we get here, we don't know what the hell the chipset is,
			   so we abort this tweak-set safely. */
			break;
    	}
}


void save_VIA_597_0(FILE *savehandle, struct pci_dev *current_dev)
{
	write_tweaks(savehandle, getnumtweaks_VIA_597_0(current_dev), VIA_82C597_0_Tweaks, current_dev);
}
