/*
 * Hardware tuning for the Intel 824xx PCI bridges.
 * This covers..
 *	82424 [Saturn]
 *	82430 [Aries]
 *	82434 [Mercury/Neptune]
 */

#include "824xx.h"

#define Intel_824xx_TWEAKSIZE sizeof(Intel_824xx_Tweaks)/sizeof(Tweaks_t)-1

unsigned int getnumtweaks_Intel_824xx(struct pci_dev *current_dev)
{
	return Intel_824xx_TWEAKSIZE;
}

void init_Intel_824xx(struct pci_dev *current_dev)
{
	init_tweaks(Intel_824xx_TWEAKSIZE, Intel_824xx_Tweaks, current_dev);
}

void tune_Intel_824xx(GtkWidget *table, struct pci_dev *current_dev, unsigned int numbuttons)
{
	Tweaks_t *Tweaks;

	unsigned int index;
	int column=0;

	Tweaks = Intel_824xx_Tweaks;

	for (index=0;index<numbuttons;index++) {
		CreateButton(table, Tweaks, current_dev, column);
		column++;
		Tweaks++;
	}
}

void save_Intel_824xx(FILE *savehandle, struct pci_dev *current_dev)
{
	write_tweaks(savehandle, Intel_824xx_TWEAKSIZE, Intel_824xx_Tweaks, current_dev);
}
