/*
 * Hardware tuning for the DEC 21050 bridge.
 */

#include "DECchip_21050.h"
#define DEC_21050_TWEAKSIZE sizeof(DEC_21050_Tweaks)/sizeof(Tweaks_t)-1

unsigned int getnumtweaks_DEC_21050(struct pci_dev *current_dev)
{
	return DEC_21050_TWEAKSIZE;
}

void init_DEC_21050(struct pci_dev *current_dev)
{
	init_tweaks(DEC_21050_TWEAKSIZE, DEC_21050_Tweaks, current_dev);
}

void tune_DEC_21050(GtkWidget *table, struct pci_dev *current_dev, unsigned int numbuttons)
{
	Tweaks_t *Tweaks;

	unsigned int index;
	int column=0;

	Tweaks = DEC_21050_Tweaks;

	for (index=0;index<numbuttons;index++) {
		CreateButton (table, Tweaks, current_dev, column);
		column++;
		Tweaks++;
	}
}

void save_DEC_21050(FILE *savehandle, struct pci_dev *current_dev)
{
	write_tweaks(savehandle, DEC_21050_TWEAKSIZE, DEC_21050_Tweaks, current_dev);
}
