/*
 * Copyright (c) 2000 Dave Jones <dave@powertweak.com>
 *
 * Can be freely distributed and used under the terms of the GNU GPL.
 */

inline void cpuid(unsigned int op, unsigned int *eax, unsigned int *ebx, unsigned int *ecx, unsigned int *edx)
{
#ifdef __i386__
	__asm__("cpuid"
		: "=a" (*eax),
		"=b" (*ebx),
		"=c" (*ecx),
		"=d" (*edx)
		: "a" (op)
		: "cc");
#endif
}


int regprint(char *outbuffer, unsigned int preg)
{
	char regch[]="----";

	int i;
	for (i=0; i<4; i++) {
		regch[i]=(preg>>(8*i));
	}
	return ( sprintf(outbuffer, "%s", ((char *) regch)));
}
