/*
 * Copyright (c) 2000 Dave Jones <dave@powertweak.com>
 *
 * Can be freely distributed and used under the terms of the GNU GPL.
 */

#define WindowWidth 640
#define WindowHeight 430

#define LeftWindowHeight WindowHeight-100
#define RightWindowHeight WindowHeight-70

#include "popup.c"
#include "about.c"
#include "notebook.c"
#include "createbuttons.c"
#include "ctree.c"
#include "menus.c"
#include "quit.c"

void savefunction (GtkWidget *widget, gpointer gdata);

void applyfunction (GtkWidget *widget, gpointer gdata)
{
}


void CreateGadgets(GtkWidget *window)
{
	GtkWidget *vbox;		/* Holds menubar & tree */
	GtkWidget *vbox2;		/* Holds notebook & buttons */
	GtkWidget *hbox;		/* Holds the apply/save/quit buttons */
	GtkWidget *Menubar;
	GtkWidget *scrolled_win;
	GtkWidget *lframe;
	GtkWidget *hpane;
	GtkText *TextPtr;
	GtkWidget *separator;
	GtkWidget *applybutton;
	GtkWidget *savebutton;
	GtkWidget *quitbutton;

	/* Create the pulldown menus */
	Menubar = CreateMenus (window);

	/* Horizontal pane to divide the GUI in two halves */
	hpane = gtk_hpaned_new();
	gtk_paned_handle_size (GTK_PANED (hpane), 10);
	gtk_paned_gutter_size (GTK_PANED (hpane), 10);

	/* Scrollable window for the tree in the LHS */
	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_set_usize (scrolled_win, WindowWidth/3, LeftWindowHeight);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW (scrolled_win),
									GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_widget_show (scrolled_win);
	CreateTree (scrolled_win);

	/* Frame for the tree & scrollbar to go inside. */
	lframe = gtk_frame_new ("System devices.");
	gtk_container_set_border_width (GTK_CONTAINER (lframe), 10);
	gtk_frame_set_shadow_type (GTK_FRAME (lframe), GTK_SHADOW_IN);
	gtk_frame_set_label_align (GTK_FRAME (lframe), 0, 0);
	gtk_widget_show (lframe);
	gtk_container_add (GTK_CONTAINER(lframe), scrolled_win);
	gtk_paned_add1 (GTK_PANED (hpane), lframe);

	/** Now the right hand side **/
	
	/* Create the notebook */
	notebook = CreateNotebook(GTK_POS_TOP);
	gtk_widget_set_usize (notebook, (WindowWidth/3)*2, RightWindowHeight);
	AddPage (GTK_NOTEBOOK (notebook), "Powertweak");
	TextPtr = CreateText("Powertweak-Linux version: " POWERTWEAK_VERSION);
	gtk_container_add (GTK_CONTAINER (current_pages[current_max_page-1]), GTK_WIDGET(TextPtr));
	gtk_widget_show (notebook);

	/* Pack & display the right hand side of the GUI */
	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox2), notebook, FALSE, FALSE, 0);
	gtk_paned_add2 (GTK_PANED (hpane), vbox2);
	gtk_widget_show (vbox2);
	gtk_widget_show (hpane);

	/* Now create the bottom part. */

	/* Separator bar */
	separator = gtk_hseparator_new();

	/* Create buttons. */
	applybutton = gtk_button_new_with_label ("Apply");
	savebutton = gtk_button_new_with_label ("Save");
	quitbutton = gtk_button_new_with_label ("Quit");
	gtk_signal_connect (GTK_OBJECT (applybutton), "clicked", GTK_SIGNAL_FUNC (applyfunction), NULL);
	gtk_signal_connect (GTK_OBJECT (savebutton), "clicked", GTK_SIGNAL_FUNC (savefunction), NULL);
	gtk_signal_connect (GTK_OBJECT (quitbutton), "clicked", GTK_SIGNAL_FUNC (quit_app), NULL);
	gtk_widget_set_sensitive (GTK_WIDGET (applybutton), FALSE );
	gtk_widget_show (applybutton);
	gtk_widget_show (savebutton);
	gtk_widget_show (quitbutton);

	/* Pack the buttons into the horizontal box */
	hbox = gtk_hbox_new (FALSE, 0);
	gtk_container_border_width (GTK_CONTAINER (hbox), 20);
	gtk_box_pack_start (GTK_BOX (hbox), applybutton, TRUE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox), savebutton, TRUE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox), quitbutton, TRUE, FALSE, 0);
	gtk_widget_show (hbox);


	/* Pack & display the overall GUI. */
	vbox = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), Menubar, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hpane, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), separator, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, FALSE, 0);

	gtk_widget_show (vbox);
	gtk_container_add (GTK_CONTAINER(window), vbox);
	gtk_widget_show_all (window);
}
