/*
    libparted
    Copyright (C) 1998-2000  Andrew Clausen  <clausen@gnu.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef PED_FAT_CALC_H
#define PED_FAT_CALC_H

extern FatCluster fat_min_cluster_count (FatType fat_type);

extern FatCluster fat_max_cluster_count (FatType fat_type);

extern PedSector fat_min_reserved_sector_count (FatType fat_type);

extern int fat_check_resize_geometry (PedFileSystem* fs, PedGeometry* geom,
			       FatCluster cluster_count);

extern int fat_calc_sizes (PedGeometry* geom,
			   PedSector align,
			   FatType fat_type,
			   PedSector root_dir_sectors,
			   int* out_cluster_size,
			   FatCluster* out_cluster_count,
			   PedSector* out_fat_size);

extern int fat_calc_resize_sizes (PedGeometry* geom,
				  PedSector align,
				  int cluster_size,
				  PedSector root_dir_sectors,
				  FatCluster* out_cluster_count,
				  PedSector* out_fat_size,
				  FatType* fat_type);

extern PedSector
fat_calc_align_sectors (PedFileSystem* new_fs, PedFileSystem* old_fs);

#endif /* PED_FAT_CALC_H */
