/* LOCKVC Version 3.4 (c) 1994, 1995, 1997 by Matthias Straub */
/* shadow-password option added by Ed Beaumont */
/* integer math derived from a patch by Jeff Epler */
/* this file was released under GPL */
/* see COPYING for details */    


#define FPBITS 10
#define FM(x,y) (((x)*(y))>>FPBITS)
#define FM3(x,y,z) (((x)*(y)*(z))>>(2*FPBITS))
#define SIN(x) (feld->sintab[(x)&4095])
#define COS(x) SIN(x+256*4)    

#define MAXNUMSTARS 2000
#define SFLENGTH 1024          /* twice DIST */
#define SFWIDTH 400
#define SFHEIGHT 400
#define DIST 512               /* should be a power of 2 for speed */
#define SCRX 320               /* .EQ. vga-mode */
#define SCRY 240               /* .EQ. vga-mode */         

#include <math.h> 
#include <vga.h>

struct field 
{
    int xr[MAXNUMSTARS];
    int yr[MAXNUMSTARS];
    int zr[MAXNUMSTARS];
    int xbuf[2][MAXNUMSTARS];
    int ybuf[2][MAXNUMSTARS];
    int s,t,u;
    int sintab[4096];
    int numstars;
    int stride;
};

void mksintab(struct field *feld)
{                   
    int i;
    for(i=0;i<4096;i++)
    {
	feld->sintab[i]=(int)(sin(i*M_PI*2.0/4096)*1024);
    }
}

  
void initfield(struct field *feld)
{       
    int i;
    for (i=0;i<(feld->numstars);i++)
    {
	feld->xr[i]=SFWIDTH-random()%(SFWIDTH<<1);
	feld->yr[i]=SFHEIGHT-random()%(SFHEIGHT<<1);
	feld->zr[i]=random()%SFLENGTH-SFLENGTH/2;
    }
}        

void initpalette()
{
    int j;
    for (j=0;j<64;j++)
    {
	vga_setpalette(j,j,j,j);
    }
    for (j=64;j<=80;j++)
    {
	vga_setpalette(j,63,63,63);
    }
}  
void plotfield(struct field *feld)
{
    static int q,qq,x2,y2,z2,xl,yl,i;
    static int offset=0;
    static int page=1;
    int IS11,IS12,IS13,IS21,IS22,IS23,IS31,IS32,IS33;    
    /* looks weird, doesn't it? */
    /* it's just the */
    /* product of 3 less */
    /* spectacular matrices */
    /* that's what one year */
    /* linear algebra class */
    /* was for */          
    IS11 = FM(COS(feld->s),COS(feld->t));
    IS12 = FM(SIN(feld->s),COS(feld->t));
    IS13 = -SIN(feld->t);
    IS21 = -FM(SIN(feld->s),COS(feld->u))+FM3(COS(feld->s),SIN(feld->t),SIN(feld->u));
    IS22 = FM(COS(feld->s),COS(feld->u))+FM3(SIN(feld->s),SIN(feld->t),SIN(feld->u));
    IS23 = FM(COS(feld->t),SIN(feld->u));
    IS31 = FM(SIN(feld->s),SIN(feld->u))+FM3(COS(feld->s),SIN(feld->t),COS(feld->u));
    IS32 = -FM(COS(feld->s),SIN(feld->u))+FM3(SIN(feld->s),SIN(feld->t),COS(feld->u));
    IS33 = FM(COS(feld->t),COS(feld->u));          
    
    page=1-page;
    offset=SCRY-offset;
    vga_setdisplaystart((SCRY-offset)*SCRX);
    vga_waitretrace();
    
    vga_setcolor(0);
    for (i=0;i<(feld->numstars);i++)
    {
	x2=feld->xbuf[page][i];
	y2=feld->ybuf[page][i];
	if (x2<SCRX && y2 < (SCRY+offset) && x2>=0 && y2 >= offset)
	{
	    vga_drawpixel(x2,y2);
	}
    }                   
	for (i=0;i<(feld->numstars);i++)
	{                                                              
	    feld->zr[i]=feld->zr[i]+feld->stride;
	    if (feld->zr[i]>SFLENGTH/2) feld->zr[i]=-SFLENGTH/2;
		z2 = (IS13*feld->xr[i]+IS23*feld->yr[i]+IS33*feld->zr[i])>>FPBITS;
	    if (z2!=DIST) q=(DIST-z2);
		else q=1;
		    qq=q>>1;
		x2 = (DIST*((int)(IS11*feld->xr[i]+IS21*feld->yr[i]+IS31*feld->zr[i])>>FPBITS)+qq)/q;
		y2 = (DIST*((int)(IS12*feld->xr[i]+IS22*feld->yr[i]+IS32*feld->zr[i])>>FPBITS)+qq)/q;
		feld->xbuf[page][i]=((x2+2)>>2)+SCRX/2;
		feld->ybuf[page][i]=SCRY/2-((y2+2)>>2)+offset;
		xl=feld->xbuf[page][i];
		yl=feld->ybuf[page][i];
		if (xl >=0 && xl <SCRX && yl >=offset && yl < (SCRY+offset) && z2<=DIST && z2>=-DIST)
		{
		    vga_setcolor(40+(z2*40)/DIST);
		    vga_drawpixel(xl,yl); 
		}
	}
	if(vga_getkey()!=0 && vga_getkey()!=-1) authenticate();
    }	

              
        
void starfield(int argc, char **argv)
{
    int i,j;
    static struct field this;


    if(argc ==4)
    {
	this.numstars=atoi(argv[2]);
	this.stride=atoi(argv[3]);
	if(this.numstars<1 || this.numstars>MAXNUMSTARS)
	{printf("Number of stars must be between 1 and %i.\n",MAXNUMSTARS);exit(-1);}
	    if(this.stride<0 || this.stride >100)
	    {
		printf("Stride must be between 0 and 100.\n");exit(-1);
	    }
    }    
	    else
	    {
		this.numstars=700;
		this.stride=9;
	    } 
    
    vga_setmode(G320x240x256); 
    if(vga_claimvideomemory(SCRX*SCRY*2))
    	{ printf("vga_claimvideomemoy refused\n"); exit(-1);} 
    signals();
    initfield (&this);
    mksintab(&this); 
    initpalette();
    for (j=0;j<200;j++)
    {
	plotfield (&this);
    }
    while(1)
    {
	for (j=0;j<2048;j++)
	{
	    plotfield (&this);
	    this.s+=2;
	    this.t+=5;
	    this.u+=7;
	}         
    }   
}
    

