
/*----------------------------------------------------------------------------*

	sysinfo.h header 
		by Alex Buell
			September 1998	

 ----------------------------------------------------------------------------- 

	Defines functions and structs	

 ----------------------------------------------------------------------------- 

	HISTORY
	
	1.0.1 - Initial development
	1.0.2 - Modification for compatibility with both libc5 & glibc2
	1.0.4 - Removed the glibc ifdefs.
	1.0.5 - Added a new field to hw_stat struct.
	1.0.8 - Ported to ARM architecture.

 -----------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <unistd.h>
#include <time.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/utsname.h>

#ifndef _SYSINFO_H_
#define _SYSINFO_H_

#if !defined(linux)
#define system_unknown
#endif

#if defined(__i386__)
#define system_intel
#endif

#if defined(m68000)
#define system_m68k
#endif 

#if defined(__alpha__)
#define system_alpha
#endif

#if defined(__sparc__)
#define system_sparc
#endif

#if defined(__PPC__)
#define system_ppc
#endif

#if defined(__arm__)
#define system_arm
#endif

#if (SIZEOF_LONG > 4)
#define LONGLONG long int
#else
#define LONGLONG long long int
#endif

struct os_stat {
	char os_hostname[BUFSIZ];
	char os_name[BUFSIZ];
	char os_version[BUFSIZ];
	char os_revision[BUFSIZ];
}; 

struct hw_stat {
	char hw_cpuinfo[BUFSIZ];
	char hw_bogomips[BUFSIZ];
	char hw_memory[BUFSIZ];
	char hw_megahertz[BUFSIZ];
	int hw_processors;
};

struct lib_stat {
	char lib_version[BUFSIZ];
};

void GetOperatingSystemInfo(struct os_stat *os);
void GetHardwareInfo(struct hw_stat *hw);
void GetSystemLibcInfo(struct lib_stat *lib);

char *GetStringFromFile(FILE *infile, char *str);
int splitstring(char *first_string, char *second_string); 

extern FILE *cpuinfo_file;

#define CPUINFO_FILE	"/proc/cpuinfo"
#define MEMORY_FILE	"/proc/kcore"

#if !(HAVE_STRSTR)
#include <string.h>
static char *strstr (const char *haystack, const char *needle)
{
  c, sc;
  size_t len;

  if ((c = *find++) != 0) {
    len = strlen(find);
    do {
      do {
        if ((sc = *s++) == 0)
          return (NULL);
      } while (sc != c);
    } while (strncmp(s, find, len) != 0);
    s--;
  }
  return ((char *)s);
}
#endif


#endif /* _SYSINFO_H_ */
