/* softnet/types.h -- define special types */

#ifndef _softnet_types_h_
#define _softnet_types_h_

#ifndef __KERNEL__
/* FIXME -- byte/word conflict with linux/smb.h */
typedef unsigned char byte;				/* 8 bit unsigned */
typedef unsigned short word;			/* 16 bit unsigned */
typedef unsigned long longword;			/* 32 bit unsigned */
#endif /*__KERNEL__*/

#ifdef linux
#include <linux/linkage.h>
#include <linux/types.h>
#else /*linux*/
typedef unsigned char u_char;			/* 8 bit unsigned */
typedef unsigned short u_short;			/* 16 bit unsigned */
typedef unsigned int u_int;				/* 16/32 bit unsigned */
typedef unsigned long u_long;			/* 32 bit unsigned */
#endif /*linux*/
typedef long long quad;					/* 64 bit signed */
typedef unsigned long long u_quad;		/* 64 bit unsigned */
typedef long double huge;				/* 128 bit float */
typedef u_long mskof_t;					/* standard bit mask */

/* type to use to absolutely force an inline function despite gratuitous */
/* meddling by compiler/library writers :-) */
#define VXInline	extern inline
#define VSInline	static inline
#define VInline		VXInline

/* NOTE: linux kernel is compiled with strict prototypes on */
#ifdef __KERNEL__
#define PROCPTR_T(typ,name) \
	typedef typ (*name)(void)
#else /*__KERNEL__*/
#define PROCPTR_T(typ,name) \
	typedef typ (*name)()
#endif /*__KERNEL__*/

PROCPTR_T(void,vdcode);					/* pointer to function */
PROCPTR_T(void *,vpcode);				/* pointer to function returning void pointer */
PROCPTR_T(long,lgcode);					/* pointer to function returning long */
PROCPTR_T(u_long,lwcode);				/* pointer to function returning u_long */

#ifndef NULL
#define NULL		0
#endif /*NULL*/

/* FIXME -- kluge to support more modern compiler stuff */
#ifdef factor
#ifndef const
#define const		/**/
#endif /*const*/
#ifndef volatile
#define volatile	/**/
#endif /*volatile*/
#endif /*factor*/

#ifdef __cplusplus
#define CDEFBEGIN		extern "C" {
#define CDEFEND			}
#define CDEFPROC		extern "C"
#define CDEFMAIN		extern "C" void
#define voidarg			/*voidarg*/
#else /*__cplusplus*/
#define CDEFBEGIN		/**/
#define CDEFEND			/**/
#define CDEFPROC		/**/
#define CDEFMAIN		void
#define voidarg			void
#endif /*__cplusplus*/

/* FIXME -- GCC complains about certain function pointer typedefs */
#define GCC_TYPEDEF_BUG(fnc,args) \
	(fnc)()

#endif /*_softnet_types_h_*/
