/* gxset - GTK interface to xset(1)

   Copyright (C) 1999 Ren Seindal (rene@seindal.dk)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
 */

#ifndef _MAIN_H_
#define _MAIN_H_ 1

#include <glib.h>

struct XsetInfo {
    int keyrepeat_onoff;
    int keyrepeat_delay;
    int keyrepeat_rate;

    int keyclick_volume;

    int bell_volume;
    int bell_pitch;
    int bell_duration;

    int mouse_acceleration;
    int mouse_divisor;
    int mouse_threshold;

    int scrsaver_onoff;
    int scrsaver_blank;
    int scrsaver_expose;
    int scrsaver_delay;
    int scrsaver_cycle;

    int dpms_onoff;
    int dpms_standby;
    int dpms_suspend;
    int dpms_off;

    GPtrArray *font_path;
};
typedef struct XsetInfo XsetInfo;


XsetInfo *xset_info_new(void);
XsetInfo *xset_info_read(void);
XsetInfo *xset_info_dup(XsetInfo *info);
void xset_info_assign(XsetInfo *lval, XsetInfo *rval);
void xset_info_delete(XsetInfo *info);


struct ApplicationState {
    XsetInfo *orig;		/* original settings */
    XsetInfo *cur;		/* current settings */

    int font_path_selected;
    gchar *save_file_name;
};

typedef struct ApplicationState ApplicationState;

gchar *font_get_current(ApplicationState *appstate);
void font_set_current(ApplicationState *appstate, gchar *replacement);

void font_add_new(ApplicationState *appstate, gchar *new_path);
gboolean font_remove(ApplicationState *appstate);
gboolean font_move_down(ApplicationState *appstate);
gboolean font_move_up(ApplicationState *appstate);

GString *apply_settings(ApplicationState *appstate);
GString *save_settings(ApplicationState *appstate);

#endif
