#ifndef _ACCWIDGET_H
#define _ACCWIDGET_H

#include <qmenubar.h>
#include <qlist.h>
#include <qlistview.h>
#include <qpopmenu.h>

#include <kfm.h>
#include <kapp.h>
#include <kurl.h>
#include <klocale.h>
#include <ktopwidget.h>

#define ID_FILE_OPEN 1
#define ID_FILE_SAVE 3
#define ID_FILE_SAVEAS 4
#define ID_FILE_CLOSE 6
#define ID_FILE_QUIT 8
#define ID_FILE_NEWFILE 10
#define ID_FILE_IMPORT  11

#define ID_ACCT_NEWACCT     31
#define ID_ACCT_OPENACCT    32
#define ID_ACCT_OPENSUBACCT 33
#define ID_ACCT_EDITACCT    34
#define ID_ACCT_DELETEACCT  35
#define ID_ACCT_TRANSFER    36
#define ID_ACCT_REPORT      37
#define ID_ACCT_HIDEINCEXP  38

#define ID_HELP_ABOUT   100
#define ID_HELP_HELP    101
#define ID_HELP_ACCTS   102
#define ID_HELP_LICENSE 103

extern "C" {
#include "Group.h"
//  #include <Account.h>
//  #include <FileIO.h>
//  #include <Data.h>
}

class AccWidget : public KTopLevelWidget {
  Q_OBJECT
    
public:

  AccWidget();
  ~AccWidget();

public slots:

  void refresh();
 
protected:
    void initMenu();
    
    void doEditAcct (); 
    void doNewAcct ();
    void doOpenAcct ();
    void doTransfer ();

//    void addAccountGroup (AccountGroup   *acct, int depth);
    void redisplayBalance ();

protected slots:
    void selectAccount (int idx);
    void menuCallback (int item);

private:
    void insertGroup(AccountGroup *grp, QListViewItem *parent = 0);
    
    KMenuBar   *menu;
    KStatusBar *statusbar;
    QListView  *acctList; 
};

#endif

