/********************************************************************\
 * PriceMenu.c -- the price source menu for gnucash                 *
 *                  (general utility)                               *
 * Copyright (C) 1977, 1999 Linas Vepstas                           *
 *                                                                  *
 * This program is free software; you can redistribute it and/or    *
 * modify it under the terms of the GNU General Public License as   *
 * published by the Free Software Foundation; either version 2 of   *
 * the License, or (at your option) any later version.              *
 *                                                                  *
 * This program is distributed in the hope that it will be useful,  *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of   *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the    *
 * GNU General Public License for more details.                     *
 *                                                                  *
 * You should have received a copy of the GNU General Public License*
 * along with this program; if not, write to the Free Software      *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.        *
\********************************************************************/

/* hack alert --  this whole thing can be generalized into a generic menu thing
 * there's just about nothing price specific in here ...
 */

#include <Xm/Xm.h>
#include <Xm/RowColumn.h>

#include "config.h"

#include "PriceMenu.h"
#include "BuildMenu.h"
#include "messages.h"
#include "util.h"

typedef struct _priceMenuEntry  PriceMenuEntry;

struct _priceMenuEntry
{
  char * option;
  char * label;
  PriceMenu *am;
};

struct _priceMenu
{
  Widget menu_widget;
  char *choice;
  int numMenuEntries;
  PriceMenuEntry **menuEntry;
  MenuItem *menuList;

  /* user callbacks */
  XtCallbackProc callback;
  XtPointer client_data;
};

/********************************************************************\
\********************************************************************/

void
xaccFreePriceMenu (PriceMenu * menu) {
   int i;

   if (!menu) return;
   _free (menu->menuList);

   for( i=0; i<menu->numMenuEntries; i++ ) {
      if (menu->menuEntry[i]) _free (menu->menuEntry[i]);
      menu->menuEntry[i] = NULL;
   }

   _free (menu->menuEntry);
   menu->menuEntry = NULL;
   menu->numMenuEntries = 0;

   _free (menu);
}

/********************************************************************\
\********************************************************************/

Widget 
xaccGetPriceMenuWidget (PriceMenu *menu) {
   if (!menu) return 0;
   return (menu->menu_widget);
}

char *
xaccGetPriceMenuSelection (PriceMenu *menu) {
   if (!menu) return NULL;
   return (menu->choice);
}

/********************************************************************\
 * menuCB -- keeps track of the menu choice                         * 
 *                                                                  * 
 * Args:   mw - the widget that called us                           * 
 *         cd - menuEntry - has the menu option and a pointer to    *
 *              where the selection will be stored                  * 
 *         cb -                                                     * 
 * Return: none                                                     * 
\********************************************************************/
static
void
xaccPriceMenuCB( Widget mw, XtPointer cd, XtPointer cb )
{
  PriceMenuEntry *menuEntry = (PriceMenuEntry *)cd;
  PriceMenu *menu;

  menu = (PriceMenu *) (menuEntry->am);
  
  menu->choice = menuEntry->option;

  if (menu->callback) {
    (*(menu->callback)) (menu->menu_widget, menu->client_data, (XtPointer) menu->choice);
  }

}

/********************************************************************\
\********************************************************************/
void
xaccPriceMenuAddCallback (PriceMenu *menu, 
                            XtCallbackProc cb,
                            XtPointer cd )
{
  if (!menu) return;
  menu -> callback = cb;
  menu -> client_data = cd;
}

/********************************************************************\
\********************************************************************/

void
xaccPriceMenuSetValue (PriceMenu *menu,  const char *val)
{
  int        i;
  int        nsrcs;

  if (!menu || !val) return;

  /* start loop at 1, no 0, since zeroth entry is none/null */
  nsrcs = menu->numMenuEntries;
  for (i=1; i<nsrcs; i++) {
     if (! strcmp (menu->menuEntry[i]->option, val)) 
     {
       menu->choice = menu->menuEntry[i]->option;
       XtVaSetValues (menu->menu_widget,
                      XmNmenuHistory, menu->menuList[i].widget,
                      NULL);
       break;
     }
  }
}

/********************************************************************\
\********************************************************************/

#define ADD_SRC(LABEL,VALUE) {  \
  prcData->menuEntry[i]->label  = LABEL; \
  prcData->menuEntry[i]->option = VALUE; \
  i++; \
}

PriceMenu *
xaccBuildPriceMenu (Widget parent, const char * label) 
{
  MenuItem *mlist;
  PriceMenu *prcData;
  int        i;
  int        nsrcs;
  

  prcData = (PriceMenu *) _malloc (sizeof (PriceMenu));
  prcData -> choice = NULL;
  prcData -> callback = NULL;
  prcData -> client_data = NULL;
  
  nsrcs = 5;
  prcData->menuEntry = (PriceMenuEntry **)_malloc(nsrcs*sizeof(PriceMenuEntry *));
  prcData->numMenuEntries = nsrcs;
  
  for (i=0; i<nsrcs; i++) 
  {
    prcData->menuEntry[i] = (PriceMenuEntry *) _malloc (sizeof (PriceMenuEntry));
    prcData->menuEntry[i]->am = prcData;
  }

  /* hack alert --  should grab these values from a config file ... */
  i=0;
  ADD_SRC (NONE_STR, NULL);
  ADD_SRC ("Yahoo", "YAHOO");
  ADD_SRC ("Fidelity", "FIDELITY");
  ADD_SRC ("T.Rowe Price", "TRPRICE");
  ADD_SRC ("Vanguard", "VANGUARD");

  prcData->menuList = (MenuItem *) _malloc ((nsrcs+1) * sizeof (MenuItem));
  mlist = prcData->menuList;
  for (i=0; i<nsrcs; i++) 
    {
    mlist[i].label         = prcData->menuEntry[i]->label;
    mlist[i].wclass        = &xmPushButtonWidgetClass;
    mlist[i].mnemonic      = 0;
    mlist[i].sensitive     = True;
    mlist[i].accelerator   = NULL;
    mlist[i].accel_text    = NULL;
    mlist[i].callback      = xaccPriceMenuCB;
    mlist[i].callback_data = prcData->menuEntry[i];
    mlist[i].widget        = 0;
    mlist[i].subitems      = (MenuItem *)NULL;
    }

    /* terminate wih a NULL row */
    mlist[i].label         = NULL;
    mlist[i].wclass        = NULL;
    mlist[i].mnemonic      = 0;
    mlist[i].sensitive     = False;
    mlist[i].accelerator   = NULL;
    mlist[i].accel_text    = NULL;
    mlist[i].callback      = NULL;
    mlist[i].callback_data = NULL;
    mlist[i].widget        = 0;
    mlist[i].subitems      = (MenuItem *)NULL;
  

  prcData->menu_widget = 
        BuildMenu( parent, XmMENU_OPTION, label, 'F', False, 0, mlist );

  XtVaSetValues (prcData->menu_widget,
                 XmNshadowThickness, 0,
                 NULL );

  XtManageChild (prcData->menu_widget);
  
  return (prcData);
}

/* ********************** END OF FILE *************************/
