/******************************************************************************\
 gnofin/money.c   $Revision: 1.2 $
 Copyright (C) 1999 Darin Fisher
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#include "gnofin.h"

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <glib.h>

#include "money.h"

gchar *
fin_money_stringize (gchar * buf, int maxlen, money_t amount)
{
  double d;

  g_return_val_if_fail(buf, NULL);
  g_return_val_if_fail(maxlen > 0, NULL);

  d = ((double) amount) / 100.0;

  snprintf(buf, maxlen, "%.02lf", d);

  return buf;
}

gboolean
fin_money_parse (const gchar * buf, money_t * amount)
{
  double d;

  gchar* ptr = (gchar*)buf;
  gchar* savptr = (gchar*)buf;
  gint len = strlen (buf);
  gchar ch;

  g_return_val_if_fail(buf, FALSE);
  g_return_val_if_fail(amount, FALSE);

  while (len > 0) {
    len--;
    ch = *buf++;
    if (ch == ',')
      continue;
    *ptr++ = ch;    
  }

  *ptr = 0;

  buf = savptr;

  if (sscanf(buf, "%lf", &d) == 0)
    return FALSE;

  *amount = (long) rint(d * 100.0);

  return TRUE;
}
