#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include "chinese.h"

CMSG msg;
char path[256];

#ifndef CHSYS
#error "CHSYS not defined"
#endif

char **getopts(int *argc,char *argv[])
{
  while(argv[1][0] == '-')
    {
      if (strncmp(argv[1]+1,"h",1)==0)
	{
	  printf("Usage : ccc [-wx <num>] [-wy <num>]\n");
	  exit(0);
	}
      if (strncmp(argv[1]+1,"wx",2)==0)
	{
	  msg.width_of_screen = atoi(argv[1]+3);

	}
      else if (strncmp(argv[1]+1,"wy",2)==0)
	{
	  msg.lines_of_screen = atoi(argv[1]+3);
	}
      else if (argv[1][1] == 'k')
	{
	  if (msg.uid)
	    {
	      printf("Only a root user can kill daemon\n");
	      exit(0);
	    }
	  msg.type = CHTTY_KILL;
	}
      *argc--;
      argv++;
    }
  return argv;
}
load_config()
{
  FILE *in;
  in = fopen(CHSYS"ccc.conf","r");
  if (in == NULL)
    return;
  fscanf(in,"%d %d",&msg.width_of_screen,&msg.lines_of_screen);
  fclose(in);
}

main(int argc,char **argv)
{
  int link,i;
  char *ttys = ttyname(0);
  msg.type = CHTTY_OPENTTY;
  msg.lines_of_screen = 29;
  msg.width_of_screen = 80;
  getwd(path);
  msg.tty = ttys[8]-'1';
  msg.length_of_home = strlen(path);
  msg.uid = geteuid();
  msg.pid = getpid();
  msg.pgrp = getpgrp();
  load_config();
  argv = getopts(&argc,argv);

  alarm(20);
  close(0);
  close(1);
  close(2);
  link = open("/dev/cin",O_WRONLY);

  if (link < 0)
    {
      perror("Can't open /dev/cin to link to server\n");
      exit(1);
    }
  write(link,&msg,sizeof(CMSG));
  write(link,path,msg.length_of_home);
  if (msg.type == CHTTY_KILL)
    exit(0);
  /* wait chinese server to wake up me */
  alarm(0);
  pause();

}
    
  
