#!@SHELL@

# Don't hack this script by hand if it's in one of your PATH directories.
# Instead, modify scripts/yodl2msps.sh in the YODL source package and do
# "make -C scripts install".

#################################################### Print error msg and die.
error()
{
    echo yodl2msps: $@ 1>&2
    exit 1
}

################################################### Print usage info and die.
usage()
{
    cat << ENDUSAGE
Yodl2msps @TOPLEVEL_VERSION@

Usage: yodl2msps [OPTION]... FILE
Options:
    for processing, run "yodl" without arguments to see
This converter runs "yodl2ms" to convert the input file to ms format, 
then runs "@MSTOPS@" to convert it to PostScript format.
ENDUSAGE

    exit 1
}

###################################################### Start of main program.

# get all flags
flags=""
inf=""
while [ "$1" != "" ] ; do
    case $1 in
        -*)
            flags="$flags $1"
            shift
            ;;
        *)
            inf=$1
            shift
            ;;
    esac
done

# no input file, nogo
if [ "$inf" = "" ] ; then
    usage
fi

# determine output file, logfile, dvi file
# ash chokes on these
#if [ "x${inf%%.yo}.yo" = "x$inf".yo ]; then
#    msf=${inf%%.yo}.ms
#    psf=${inf%%.yo}.ps
#else
    msf=`echo $inf | sed 's/\.yo//'`.ms
    psf=`echo $inf | sed 's/\.yo//'`.ps
#fi

yodl2ms $flags $inf || error "YODL to LaTeX conversion failed"
@MSTOPS@ $msf > $psf || error "ms to PostScript conversion failed"
