#ifndef MSWORDVIEW_HEADER
#define MSWORDVIEW_HEADER

#include <time.h>

#ifndef PATH_MAX
#define PATH_MAX 255 /*seems a reasonable figure*/
#endif

#ifndef U32
#define U32 unsigned int
#endif

#ifndef S32
#define S32 int
#endif

#ifndef U16
#define U16 unsigned short
#endif

#ifndef S16
#define S16 short
#endif

#ifndef U8
#define U8 unsigned char
#endif

#define DEFAULTINDENT 1800
#define TWIRPS_PER_BQ 1440
#define TWIRPS_PER_H_PIXEL 20
#define TWIRPS_PER_V_PIXEL 20

#define SPACEPIXELS 6

#ifndef isletter
#define isletter(c) (((c) >= 'A' && (c) <= 'Z') || ((c) >= 'a' && (c) <= 'z'))
#endif

#ifndef digit
#define digit(c)  ((c) >= '0' && (c) <= '9')
#endif

#define legal_variable_char(c)  (isletter (c) || digit (c) || c == '_')

#ifndef HAVE_WMF
typedef struct tagRECT
    {
    S32 left;
    S32 right;
    S32 top;
    S32 bottom;
    }RECT;

typedef struct tagPOINT
    {
    S32 x;
    S32 y;
    }POINT;
#else
#	include <wmfapi.h>
#endif



/*Wine Portions Begin*/

typedef struct tagPANOSE
	{
    U8 bFamilyType;
    U8 bSerifStyle;
    U8 bWeight;
    U8 bProportion;
    U8 bContrast;
    U8 bStrokeVariation;
    U8 bArmStyle;
    U8 bLetterform;
    U8 bMidline;
    U8 bXHeight;
	} PANOSE;

void wvGetPANOSE(PANOSE *panose,FILE *fd);

/*
 * The FONTSIGNATURE tells which Unicode ranges and which code pages
 * have glyphs in a font.
 *
 * fsUsb  128-bit bitmap. The most significant bits are 10 (magic number).
 *        The remaining 126 bits map the Unicode ISO 10646 subranges
 *        for which the font provides glyphs.
 *
 * fsCsb  64-bit bitmap. The low 32 bits map the Windows codepages for
 *        which the font provides glyphs. The high 32 bits are for
 *        non Windows codepages.
 */
typedef struct
	{
	U32 fsUsb[4];
	U32 fsCsb[2];
	} FONTSIGNATURE;

void wvGetFONTSIGNATURE(FONTSIGNATURE *fs,FILE *fd);

#ifndef _FILETIME_
#define _FILETIME_
/* 64 bit number of 100 nanoseconds intervals since January 1, 1601 */
typedef struct
	{
	U32  dwLowDateTime;
	U32  dwHighDateTime;
	} FILETIME;
#endif /* _FILETIME_ */

void wvGetFILETIME(FILETIME *ft,FILE *fd);

time_t wvDOSFS_FileTimeToUnixTime( const FILETIME *filetime, U32 *remainder );
int wvFileTimeToDosDateTime(const FILETIME *ft, U16 *fatdate, U16 *fattime );
/*Wine Portions End*/

/** beginning of clean interface **/
void wvError(char *fmt, ...);

typedef struct _FIB
	{
	U16 wIdent ;				/* 0x0000 */
	U16 nFib ;				/* 0x0002 */
	U16 nProduct ;				/* 0x0004 */
	U16 lid ;				/* 0x0006 */
	S16 pnNext ;				/* 0x0008 */
	U16 fDot:1 ;				/* Bitfield 0x0001 0x000A */
	U16 fGlsy:1 ;			/* Bitfield 0x0002 */
	U16 fComplex:1 ;			/* Bitfield 0x0004 */
	U16 fHasPic:1 ;			/* Bitfield 0x0008 */
	U16 cQuickSaves:4 ;			/* Bitfield 0x00F0 */
	U16 fEncrypted:1 ;			/* Bitfield 0x0100 */
	U16 fWhichTblStm:1 ;			/* Bitfield 0x0200 */
	U16 fReadOnlyRecommended:1 ;			/* Bitfield 0x0400 */
	U16 fWriteReservation:1 ;			/* Bitfield 0x0800 */
	U16 fExtChar:1 ;			/* Bitfield 0x1000 */
	U16 fLoadOverride:1 ;			/* Bitfield 0x2000 */
	U16 fFarEast:1 ;			/* Bitfield 0x4000 */
	U16 fCrypto:1 ;			/* Bitfield 0x8000 */
	U16 nFibBack ;				/* 0x000C */
	U32 lKey ;				/* 0x000E */
	U8 envr ;				/* 0x0012 */
	U8 fMac:1 ;				/* Bitfield 0x01 0x0013 */
	U8 fEmptySpecial:1 ;			/* Bitfield 0x02 */
	U8 fLoadOverridePage:1 ;			/* Bitfield 0x04 */
	U8 fFutureSavedUndo:1 ;			/* Bitfield 0x08 */
	U8 fWord97Saved:1 ;			/* Bitfield 0x10 */
	U8 fSpare0:3 ;			/* Bitfield 0xFE */
	U16 chs ;				/* 0x0014 */
	U16 chsTables ;				/* 0x0016 */
	S32 fcMin ;				/* 0x0018 */
	S32 fcMac ;				/* 0x001C */
	U16 csw ;				/* 0x0020 */
	U16 wMagicCreated ;				/* 0x0022 */
	U16 wMagicRevised ;				/* 0x0024 */
	U16 wMagicCreatedPrivate ;				/* 0x0026 */
	U16 wMagicRevisedPrivate ;				/* 0x0028 */
	S16 pnFbpChpFirst_W6 ;				/* 0x002A */
	S16 pnChpFirst_W6 ;				/* 0x002C */
	S16 cpnBteChp_W6 ;				/* 0x002E */
	S16 pnFbpPapFirst_W6 ;				/* 0x0030 */
	S16 pnPapFirst_W6 ;				/* 0x0032 */
	S16 cpnBtePap_W6 ;				/* 0x0034 */
	S16 pnFbpLvcFirst_W6 ;				/* 0x0036 */
	S16 pnLvcFirst_W6 ;				/* 0x0038 */
	S16 cpnBteLvc_W6 ;				/* 0x003A */
	S16 lidFE ;				/* 0x003C */
	U16 clw ;				/* 0x003E */
	S32 cbMac ;				/* 0x0040 */
	U32 lProductCreated ;				/* 0x0044 */
	U32 lProductRevised ;				/* 0x0048 */
	S32 ccpText ;				/* 0x004C */
	S32 ccpFtn ;				/* 0x0050 */
	S32 ccpHdd ;				/* 0x0054 */
	S32 ccpMcr ;				/* 0x0058 */
	S32 ccpAtn ;				/* 0x005C */
	S32 ccpEdn ;				/* 0x0060 */
	S32 ccpTxbx ;				/* 0x0064 */
	S32 ccpHdrTxbx ;				/* 0x0068 */
	S32 pnFbpChpFirst ;				/* 0x006C */
	S32 pnChpFirst ;				/* 0x0070 */
	S32 cpnBteChp ;				/* 0x0074 */
	S32 pnFbpPapFirst ;				/* 0x0078 */
	S32 pnPapFirst ;				/* 0x007C */
	S32 cpnBtePap ;				/* 0x0080 */
	S32 pnFbpLvcFirst ;				/* 0x0084 */
	S32 pnLvcFirst ;				/* 0x0088 */
	S32 cpnBteLvc ;				/* 0x008C */
	S32 fcIslandFirst ;				/* 0x0090 */
	S32 fcIslandLim ;				/* 0x0094 */
	U16 cfclcb ;				/* 0x0098 */
	S32 fcStshfOrig ;				/* 0x009A */
	U32 lcbStshfOrig ;				/* 0x009E */
	S32 fcStshf ;				/* 0x00A2 */
	U32 lcbStshf ;				/* 0x00A6 */
	S32 fcPlcffndRef ;				/* 0x00AA */
	U32 lcbPlcffndRef ;				/* 0x00AE */
	S32 fcPlcffndTxt ;				/* 0x00B2 */
	U32 lcbPlcffndTxt ;				/* 0x00B6 */
	S32 fcPlcfandRef ;				/* 0x00BA */
	U32 lcbPlcfandRef ;				/* 0x00BE */
	S32 fcPlcfandTxt ;				/* 0x00C2 */
	U32 lcbPlcfandTxt ;				/* 0x00C6 */
	S32 fcPlcfsed ;				/* 0x00CA */
	U32 lcbPlcfsed ;				/* 0x00CE */
	S32 fcPlcpad ;				/* 0x00D2 */
	U32 lcbPlcpad ;				/* 0x00D6 */
	S32 fcPlcfphe ;				/* 0x00DA */
	U32 lcbPlcfphe ;				/* 0x00DE */
	S32 fcSttbfglsy ;				/* 0x00E2 */
	U32 lcbSttbfglsy ;				/* 0x00E6 */
	S32 fcPlcfglsy ;				/* 0x00EA */
	U32 lcbPlcfglsy ;				/* 0x00EE */
	S32 fcPlcfhdd ;				/* 0x00F2 */
	U32 lcbPlcfhdd ;				/* 0x00F6 */
	S32 fcPlcfbteChpx ;				/* 0x00FA */
	U32 lcbPlcfbteChpx ;				/* 0x00FE */
	S32 fcPlcfbtePapx ;				/* 0x0102 */
	U32 lcbPlcfbtePapx ;				/* 0x0106 */
	S32 fcPlcfsea ;				/* 0x010A */
	U32 lcbPlcfsea ;				/* 0x010E */
	S32 fcSttbfffn ;				/* 0x0112 */
	U32 lcbSttbfffn ;				/* 0x0116 */
	S32 fcPlcffldMom ;				/* 0x011A */
	U32 lcbPlcffldMom ;				/* 0x011E */
	S32 fcPlcffldHdr ;				/* 0x0122 */
	U32 lcbPlcffldHdr ;				/* 0x0126 */
	S32 fcPlcffldFtn ;				/* 0x012A */
	U32 lcbPlcffldFtn ;				/* 0x012E */
	S32 fcPlcffldAtn ;				/* 0x0132 */
	U32 lcbPlcffldAtn ;				/* 0x0136 */
	S32 fcPlcffldMcr ;				/* 0x013A */
	U32 lcbPlcffldMcr ;				/* 0x013E */
	S32 fcSttbfbkmk ;				/* 0x0142 */
	U32 lcbSttbfbkmk ;				/* 0x0146 */
	S32 fcPlcfbkf ;				/* 0x014A */
	U32 lcbPlcfbkf ;				/* 0x014E */
	S32 fcPlcfbkl ;				/* 0x0152 */
	U32 lcbPlcfbkl ;				/* 0x0156 */
	S32 fcCmds ;				/* 0x015A */
	U32 lcbCmds ;				/* 0x015E */
	S32 fcPlcmcr ;				/* 0x0162 */
	U32 lcbPlcmcr ;				/* 0x0166 */
	S32 fcSttbfmcr ;				/* 0x016A */
	U32 lcbSttbfmcr ;				/* 0x016E */
	S32 fcPrDrvr ;				/* 0x0172 */
	U32 lcbPrDrvr ;				/* 0x0176 */
	S32 fcPrEnvPort ;				/* 0x017A */
	U32 lcbPrEnvPort ;				/* 0x017E */
	S32 fcPrEnvLand ;				/* 0x0182 */
	U32 lcbPrEnvLand ;				/* 0x0186 */
	S32 fcWss ;				/* 0x018A */
	U32 lcbWss ;				/* 0x018E */
	S32 fcDop ;				/* 0x0192 */
	U32 lcbDop ;				/* 0x0196 */
	S32 fcSttbfAssoc ;				/* 0x019A */
	U32 lcbSttbfAssoc ;				/* 0x019E */
	S32 fcClx ;				/* 0x01A2 */
	U32 lcbClx ;				/* 0x01A6 */
	S32 fcPlcfpgdFtn ;				/* 0x01AA */
	U32 lcbPlcfpgdFtn ;				/* 0x01AE */
	S32 fcAutosaveSource ;				/* 0x01B2 */
	U32 lcbAutosaveSource ;				/* 0x01B6 */
	S32 fcGrpXstAtnOwners ;				/* 0x01BA */
	U32 lcbGrpXstAtnOwners ;				/* 0x01BE */
	S32 fcSttbfAtnbkmk ;				/* 0x01C2 */
	U32 lcbSttbfAtnbkmk ;				/* 0x01C6 */
	S32 fcPlcdoaMom ;				/* 0x01CA */
	U32 lcbPlcdoaMom ;				/* 0x01CE */
	S32 fcPlcdoaHdr ;				/* 0x01D2 */
	U32 lcbPlcdoaHdr ;				/* 0x01D6 */
	S32 fcPlcspaMom ;				/* 0x01DA */
	U32 lcbPlcspaMom ;				/* 0x01DE */
	S32 fcPlcspaHdr ;				/* 0x01E2 */
	U32 lcbPlcspaHdr ;				/* 0x01E6 */
	S32 fcPlcfAtnbkf ;				/* 0x01EA */
	U32 lcbPlcfAtnbkf ;				/* 0x01EE */
	S32 fcPlcfAtnbkl ;				/* 0x01F2 */
	U32 lcbPlcfAtnbkl ;				/* 0x01F6 */
	S32 fcPms ;				/* 0x01FA */
	U32 lcbPms ;				/* 0x01FE */
	S32 fcFormFldSttbs ;				/* 0x0202 */
	U32 lcbFormFldSttbs ;				/* 0x0206 */
	S32 fcPlcfendRef ;				/* 0x020A */
	U32 lcbPlcfendRef ;				/* 0x020E */
	S32 fcPlcfendTxt ;				/* 0x0212 */
	U32 lcbPlcfendTxt ;				/* 0x0216 */
	S32 fcPlcffldEdn ;				/* 0x021A */
	U32 lcbPlcffldEdn ;				/* 0x021E */
	S32 fcPlcfpgdEdn ;				/* 0x0222 */
	U32 lcbPlcfpgdEdn ;				/* 0x0226 */
	S32 fcDggInfo ;				/* 0x022A */
	U32 lcbDggInfo ;				/* 0x022E */
	S32 fcSttbfRMark ;				/* 0x0232 */
	U32 lcbSttbfRMark ;				/* 0x0236 */
	S32 fcSttbCaption ;				/* 0x023A */
	U32 lcbSttbCaption ;				/* 0x023E */
	S32 fcSttbAutoCaption ;				/* 0x0242 */
	U32 lcbSttbAutoCaption ;				/* 0x0246 */
	S32 fcPlcfwkb ;				/* 0x024A */
	U32 lcbPlcfwkb ;				/* 0x024E */
	S32 fcPlcfspl ;				/* 0x0252 */
	U32 lcbPlcfspl ;				/* 0x0256 */
	S32 fcPlcftxbxTxt ;				/* 0x025A */
	U32 lcbPlcftxbxTxt ;				/* 0x025E */
	S32 fcPlcffldTxbx ;				/* 0x0262 */
	U32 lcbPlcffldTxbx ;				/* 0x0266 */
	S32 fcPlcfhdrtxbxTxt ;				/* 0x026A */
	U32 lcbPlcfhdrtxbxTxt ;				/* 0x026E */
	S32 fcPlcffldHdrTxbx ;				/* 0x0272 */
	U32 lcbPlcffldHdrTxbx ;				/* 0x0276 */
	S32 fcStwUser ;				/* 0x027A */
	U32 lcbStwUser ;				/* 0x027E */
	S32 fcSttbttmbd ;				/* 0x0282 */
	U32 cbSttbttmbd ;				/* 0x0286 */
	S32 fcUnused ;				/* 0x028A */
	U32 lcbUnused ;				/* 0x028E */
	S32 fcPgdMother ;				/* 0x0292 */
	U32 lcbPgdMother ;				/* 0x0296 */
	S32 fcBkdMother ;				/* 0x029A */
	U32 lcbBkdMother ;				/* 0x029E */
	S32 fcPgdFtn ;				/* 0x02A2 */
	U32 lcbPgdFtn ;				/* 0x02A6 */
	S32 fcBkdFtn ;				/* 0x02AA */
	U32 lcbBkdFtn ;				/* 0x02AE */
	S32 fcPgdEdn ;				/* 0x02B2 */
	U32 lcbPgdEdn ;				/* 0x02B6 */
	S32 fcBkdEdn ;				/* 0x02BA */
	U32 lcbBkdEdn ;				/* 0x02BE */
	S32 fcSttbfIntlFld ;				/* 0x02C2 */
	U32 lcbSttbfIntlFld ;				/* 0x02C6 */
	S32 fcRouteSlip ;				/* 0x02CA */
	U32 lcbRouteSlip ;				/* 0x02CE */
	S32 fcSttbSavedBy ;				/* 0x02D2 */
	U32 lcbSttbSavedBy ;				/* 0x02D6 */
	S32 fcSttbFnm ;				/* 0x02DA */
	U32 lcbSttbFnm ;				/* 0x02DE */
	S32 fcPlcfLst ;				/* 0x02E2 */
	U32 lcbPlcfLst ;				/* 0x02E6 */
	S32 fcPlfLfo ;				/* 0x02EA */
	U32 lcbPlfLfo ;				/* 0x02EE */
	S32 fcPlcftxbxBkd ;				/* 0x02F2 */
	U32 lcbPlcftxbxBkd ;				/* 0x02F6 */
	S32 fcPlcftxbxHdrBkd ;				/* 0x02FA */
	U32 lcbPlcftxbxHdrBkd ;				/* 0x02FE */
	S32 fcDocUndo ;				/* 0x0302 */
	U32 lcbDocUndo ;				/* 0x0306 */
	S32 fcRgbuse ;				/* 0x030A */
	U32 lcbRgbuse ;				/* 0x030E */
	S32 fcUsp ;				/* 0x0312 */
	U32 lcbUsp ;				/* 0x0316 */
	S32 fcUskf ;				/* 0x031A */
	U32 lcbUskf ;				/* 0x031E */
	S32 fcPlcupcRgbuse ;				/* 0x0322 */
	U32 lcbPlcupcRgbuse ;				/* 0x0326 */
	S32 fcPlcupcUsp ;				/* 0x032A */
	U32 lcbPlcupcUsp ;				/* 0x032E */
	S32 fcSttbGlsyStyle ;				/* 0x0332 */
	U32 lcbSttbGlsyStyle ;				/* 0x0336 */
	S32 fcPlgosl ;				/* 0x033A */
	U32 lcbPlgosl ;				/* 0x033E */
	S32 fcPlcocx ;				/* 0x0342 */
	U32 lcbPlcocx ;				/* 0x0346 */
	S32 fcPlcfbteLvc ;				/* 0x034A */
	U32 lcbPlcfbteLvc ;				/* 0x034E */
	FILETIME ftModified ;				/* 0x0352 */
	S32 fcPlcflvc ;				/* 0x035A */
	U32 lcbPlcflvc ;				/* 0x035E */
	S32 fcPlcasumy ;				/* 0x0362 */
	U32 lcbPlcasumy ;				/* 0x0366 */
	S32 fcPlcfgram ;				/* 0x036A */
	U32 lcbPlcfgram ;				/* 0x036E */
	S32 fcSttbListNames ;				/* 0x0372 */
	U32 lcbSttbListNames ;				/* 0x0376 */
	S32 fcSttbfUssr ;				/* 0x037A */
	U32 lcbSttbfUssr ;				/* 0x037E */
	} FIB;
void wvGetFIB(FIB *item,FILE *fd);

int wvGetEmpty_PLCF(U32 **cp,int *nocps,U32 offset,U32 len,FILE *fd);

int wvDecrypt(FILE *mainfd,char *,U32 lKey);

typedef struct _FRD
	{
	S16 frd;
	} FRD;

void wvGetFRD(FRD *item,FILE *fd);
int wvGetFRD_PLCF(FRD **frd,U32 **pos,int *nofrd,U32 offset,U32 len,FILE *fd);

typedef U16 XCHAR;

typedef struct _ATRD
    {
    XCHAR xstUsrInitl[10];
    S16 ibst;
    U16 ak;			/*unused*/
    U16 grfbmc;		/*unused*/
    S32 lTagBkmk;
    } ATRD;

void wvGetATRD(ATRD *item,FILE *fd);
int wvGetATRD_PLCF(ATRD **atrd,U32 **pos,int *noatrd,U32 offset,U32 len,FILE *fd);

typedef struct _SED
    {
    S16 fn;     
    U32 fcSepx;
    S16 fnMpr;  
    U32 fcMpr;
    } SED;

void wvGetSED(SED *item,FILE *fd);
int wvGetSED_PLCF(SED **item,U32 **pos,int *noitem,U32 offset,U32 len,FILE *fd);

typedef struct _FFN
    {
    U8 cbFfnM1;
    U8 prq:2;
    U8 fTrueType:1;
    U8 reserved1:1;
    U8 ff:3;
    U8 reserved2:1;
    S16 wWeight;
    U8 chs;
    U8 ixchSzAlt;
    PANOSE panose;
    FONTSIGNATURE fs;
    XCHAR xszFfn[65];   /*max size*/
    } FFN;

void wvGetFFN(FFN *item,FILE *fd);

typedef struct _FFN_STTBF
    {
    U16 exflag;
    U16 no_of_strings;
    U16 extra_byte_flag;
    FFN *ffn;
    } FFN_STTBF;

void wvGetFFN_STTBF(FFN_STTBF *item,U32 offset,U32 len,FILE *fd);
void wvReleaseFFN_STTBF(FFN_STTBF *item);


/*interim, change mainfd to fib later*/
FILE *wvWhichTableStream(FILE *mainfd,FILE *tablefd0,FILE *tablefd1);


typedef struct MSOFBH
	{
	U32 ver : 4;
	U32 inst: 12;
	U32 fbt : 16;
	U32 cbLength;
	} MSOFBH;

/* FDGG - File DGG */
typedef struct _FDGG
   {
   U32 spidMax;     /* The current maximum shape ID */
   U32 cidcl;       /* The number of ID clusters (FIDCLs) */
   U32 cspSaved;    /* The total number of shapes saved */
                    /* (including deleted shapes, if undo */
                    /* information was saved) */
   U32 cdgSaved;    /* The total number of drawings saved */
   } FDGG;

/* File ID Cluster - used to save IDCLs */
typedef struct _FIDCL
   {
   U32 dgid;        /* DG owning the SPIDs in this cluster */
   U32 cspidCur;    /* number of SPIDs used so far */
   } FIDCL;

/* FBSE - File Blip Store Entry */
typedef struct _FBSE
   {
   U8      btWin32;    /* Required type on Win32 */
   U8      btMacOS;    /* Required type on Mac */
   U8      rgbUid[16]; /* Identifier of blip */
   U16     tag;        /* currently unused */
   U32     size;       /* Blip size in stream */
   U32     cRef;       /* Reference count on the blip */
   U32     foDelay;    /* File offset in the delay stream */
   U8      usage;      /* How this blip is used (MSOBLIPUSAGE) */
   U8      cbName;     /* length of the blip name */
   U8      unused2;    /* for the future */
   U8      unused3;    /* for the future */
   } FBSE; 


typedef enum
   {
   msoblipusagedefault,  /* all non-texture fill blips get this. */
   msoblipusagetexture,
   msoblipusagemax = 255 /* since this is stored in a byte */
   } msoblipusage;

typedef enum
   {                          /* GEL provided types... */
   msoblipERROR = 0,          /* An error occured during loading */
   msoblipUNKNOWN,            /* An unknown blip type */
   msoblipEMF,                /* Windows Enhanced Metafile */
   msoblipWMF,                /* Windows Metafile */
   msoblipPICT,               /* Macintosh PICT */
   msoblipJPEG,               /* JFIF */
   msoblipPNG,                /* PNG */
   msoblipDIB,                /* Windows DIB */
   msoblipFirstClient = 32,   /* First client defined blip type */
   msoblipLastClient  = 255   /* Last client defined blip type */
   } MSOBLIPTYPE;

typedef enum
   {
   msobiUNKNOWN = 0,
   msobiWMF  = 0x216,      /* Metafile header then compressed WMF */
   msobiEMF  = 0x3D4,      /* Metafile header then compressed EMF */
   msobiPICT = 0x542,      /* Metafile header then compressed PICT */
   msobiPNG  = 0x6E0,      /* One byte tag then PNG data */
   msobiJFIF = 0x46A,      /* One byte tag then JFIF data */
   msobiJPEG = msobiJFIF,
   msobiDIB  = 0x7A8,      /* One byte tag then DIB data */
   msobiClient=0x800,      /* Clients should set this bit */
   }
MSOBI;                     /* Blip signature as encoded in the MSOFBH.inst */

typedef enum
	{
	msofbtDggContainer = 0xF000,
	msofbtDgg = 0xF006,
	msofbtBSE = 0xF007,
	msofbtDg = 0xF008,
	msofbtOPT = 0xF00B,
	msofbtSp = 0xF00A,
	msofbtBlipFirst = 0xF018
	} MSOFBT;

typedef enum
   {
   msocompressionDeflate = 0,
   msocompressionNone = 254,    /* Used only if compression fails */
   msocompressionTest = 255,    /* For testing only */
   }
MSOBLIPCOMPRESSION;

typedef enum
   {
   msofilterAdaptive = 0,       /* PNG type - not used/supported for metafile */
   msofilterNone = 254,
   msofilterTest = 255,         /* For testing only */
   }
MSOBLIPFILTER;

typedef struct _MetaFileBlip
	{
		/* The secondary, or data, UID - should always be set. */
	U8  m_rgbUid[16];
	/* The primary UID - this defaults to 0, in which case the primary ID is
	that of the internal data. NOTE!: The primary UID is only saved to disk
	if (blip_instance ^ blip_signature == 1). Blip_instance is MSOFBH.inst and 
	blip_signature is one of the values defined in MSOBI */
	U8  m_rgbUidPrimary[16];    /* optional based on the above check*/

	/* Metafile Blip overhead = 34 bytes. m_cb gives the number of
	bytes required to store an uncompressed version of the file, m_cbSave
	is the compressed size.  m_mfBounds gives the boundary of all the
	drawing calls within the metafile (this may just be the bounding box
	or it may allow some whitespace, for a WMF this comes from the
	SetWindowOrg and SetWindowExt records of the metafile). */
	U32           m_cb;           /* Cache of the metafile size */
	RECT          m_rcBounds;     /* Boundary of metafile drawing commands */
	POINT         m_ptSize;       /* Size of metafile in EMUs */
	U32           m_cbSave;       /* Cache of saved size (size of m_pvBits) */
	U8            m_fCompression; /* MSOBLIPCOMPRESSION */
	U8            m_fFilter;      /* always msofilterNone */
	U8           *m_pvBits;       /* Compressed bits of metafile. */
	} MetaFileBlip;

typedef struct _BitmapBlip
	{
	/* The secondary, or data, UID - should always be set. */
	U8  m_rgbUid[16];
	/* The primary UID - this defaults to 0, in which case the primary ID is
	that of the internal data. NOTE!: The primary UID is only saved to disk
	if (blip_instance ^ blip_signature == 1). Blip_instance is MSOFBH.finst and 
	blip_signature is one of the values defined in MSOBI*/
	U8  m_rgbUidPrimary[16];    /* optional based on the above check*/
	U8  m_bTag;            
	U8  *m_pvBits;              /* raster bits of the blip*/
	} BitmapBlip;


typedef struct _FOPTE
	{
	U16 pid : 14;     /* Property ID */
	U16 fBid : 1;     /* value is a blip ID - only valid if fComplex is FALSE */
	U16 fComplex : 1; /* complex property, value is length */
	U32 op;
	} FOPTE;

typedef struct _FSP
   {
   U32 spid;           /* The shape id */
   U32 grfPersistent;
   } FSP;

struct _fopte_list
	{
	FOPTE afopte;
	struct _fopte_list *next;
	};

typedef struct _fopte_list fopte_list;

struct _fsp_list
	{
	FSP afsp;
	fopte_list *afopte_list;
	struct _fsp_list *next;
	};

typedef struct _fsp_list fsp_list;

struct _fbse_list
	{
	FBSE afbse;	
	char filename[4096];
	struct _fbse_list *next;
	};

typedef struct _fbse_list fbse_list;

/* FDG - File DG */
typedef struct _FDG
   {
   U32 csp;          /* The number of shapes in this drawing */
   U32 spidCur;      /* The last MSOSPID given to an SP in this DG */
   } FDG;

fsp_list *wvParseEscher(U32 fcDggInfo,U32 lcbDggInfo,FILE *escherstream,FILE *delaystream, fbse_list **pic_list);
void wvGetMSOFBH(MSOFBH *amsofbh,FILE *infd);
void wvGetFDGG(FDGG *afdgg,FILE *infd);
void wvGetFIDCL(FIDCL *afidcl,FILE *infd);
void wvGetFBSE(FBSE *afbse,FILE *infd);
char *wvGetMetafile(MetaFileBlip *amf,MSOFBH *amsofbh,FILE *infd);
char *wvGetBitmap(BitmapBlip *abm,MSOFBH  *amsofbh,FBSE *afbse,FILE *infd);
U32 wvGetFOPTE(FOPTE *afopte,FILE *infd);
void wvGetFSP(FSP *afsp,FILE *infd);
void wvGetFDG(FDG *afdg,FILE *infd);
int wvQueryDelayStream(FBSE *afbse);
fbse_list *wvGetSPID(U32 spid,fsp_list *afsp_list,fbse_list *afbse_list);



typedef struct _BRC
	{
	U16 dptLineWidth:8;
	U16 brcType:8;
	U16 ico:8;
	U16 dptSpace:5;
	U16 fShadow:1;
	U16 fFrame:1;
	U16 reserved:1;
	} BRC;

void wvGetBRC(BRC *abrc,FILE *infd);

typedef struct _BITMAP
	{
	U8 bm[14];
	} BITMAP;

void wvGetBITMAP(BITMAP *bmp,FILE *infd);

typedef struct _rc
	{
	U8 bm[14];
	} rc;

void wvGetrc(rc *arc,FILE *infd);

typedef struct _PICF
	{
	U32 lcb;
	U16 cbHeader;
	S16 mfp_mm;
	S16 mfp_xExt;
	S16 mfp_yExt;
	S16 mfp_hMF;
	union
		{
		BITMAP bitmap;
		rc arc;
		} 
		obj;
	S16 dxaGoal;
	S16 dyaGoal;
	S16 mx;
	S16 my;
	S16 dxaCropLeft;
	S16 dyaCropTop;
	S16 dxaCropRight;
	S16 dyaCropBottom;
	U16  brcl:4;
	U16 fFrameEmpty:1;
	U16 fBitmap:1;
	U16 fDrawHatch:1;
	U16 fError:1;
	U16 bpp:8;
	BRC brcTop;
	BRC brcLeft;
	BRC brcBottom;
	BRC brcRight;
	S16 dxaOrigin;
	S16 dyaOrigin;
	S16 cProps;
	U8 *rgb;
	} PICF;

void wvGetPICF(PICF *apicf,FILE *infd,U32 offset);

typedef struct _SttbfAssoc
	{
	U16 nostrings;
	U16 extradatalen;
	U8 extendedflag;
	U8 **u8strings;
	U16 **u16strings;
	U8 **extradata;
	} SttbfAssoc;

void wvGetSttbfAssoc(SttbfAssoc *anSttbfAssoc,FILE *tablefd,U32 offset,U32 len);


/*Summary Information Stream*/

typedef struct _PropHeader
    {
    U16     byteOrder;
    U16     wFormat;
    U16     osVersion1;
    U16     osVersion2;
    U8    classId[16];
    U32    cSections;
    } PropHeader;

void wvGetPropHeader(PropHeader *header,FILE *file);

typedef struct _FIDAndOffset
	{
    U32 dwords[4];
    U32 dwOffset;
    } FIDAndOffset;

void wvGetFIDAndOffset(FIDAndOffset *fid,FILE *file);

typedef struct _aPro
		{
        U32 propID;
        U32 dwOffset;
    	} aPro;

typedef struct _SummaryInfo 
	{
    U32   cBytes;
    U32   cProps;
	aPro *aProps;
	U8 *data;
	} SummaryInfo;

int wvSumInfoOpenStream(SummaryInfo *si,FILE *stream);

void wvGetSummaryInfo(SummaryInfo *si,FILE *file,U32 offset);
void wvReleaseSummaryInfo(SummaryInfo *si);

typedef struct _vtB
	{
	U32 cBytes;
	char  *ch;
	} vtB;

#define VT_I4           0x03
#define VT_LPSTR        0x1E
#define VT_FILETIME     0x40
#define VT_WMF			0x47

typedef struct _PropValue
	{
    U32 vtType;
    union 
		{
        FILETIME      vtTime;
        S32          vtLong;
        vtB vtBSTR;
    	} vtValue;
	} PropValue;

/*String properties*/
#define PID_TITLE          0x02
#define PID_SUBJECT        0x03
#define PID_AUTHOR         0x04
#define PID_KEYWORDS       0x05
#define PID_COMMENTS       0x06
#define PID_TEMPLATE       0x07
#define PID_LASTAUTHOR     0x08
#define PID_REVNUMBER      0x09
#define PID_APPNAME        0x12

/*Time properties*/
#define PID_TOTAL_EDITTIME 0x0A
#define PID_LASTPRINTED    0x0B
#define PID_CREATED        0x0C
#define PID_LASTSAVED      0x0D

/*Long integer properties*/
#define PID_PAGECOUNT      0x0E
#define PID_WORDCOUNT      0x0F
#define PID_CHARCOUNT      0x10
#define PID_SECURITY       0x13

#define PID_THUMBNAIL	   0x11

/*bit masks for security long integer*/
#define AllSecurityFlagsEqNone         0x00
#define fSecurityPassworded            0x01
#define fSecurityRORecommended         0x02
#define fSecurityRO                    0x04
#define fSecurityLockedForAnnotations  0x08

int wvGetProperty(PropValue *Prop, SummaryInfo *si, U32 pid);
void wvReleaseProperty(PropValue *Prop);

int wvSumInfoGetString(char *lpStr, U16 cbStr, U32 pid, SummaryInfo *si);

int wvSumInfoGetLong(U32 *lpLong,U32 pid, SummaryInfo *si);

int wvSumInfoGetTime(U16 *yr, U16 *mon, U16 *day, U16 *hr, U16 *min, U16 *sec, U32 pid, SummaryInfo *si);

int wvSumInfoGetPreview(char *lpStr, U16 cbStr, U32 pid, SummaryInfo *si);

/*end of clean interface*/

struct tASUMYI
	{
	U16 fValid:1;
	U16 fView:1;
	U16 iViewBy:2;
	U16 fUpdateProps:1;
	U16 reserved:11;

	U16 wDlgLevel;
	U32 lHighestLevel;
	U32 lCurrentLevel;
	};

typedef struct tASUMYI ASUMYI;

struct tDTTM
	{
	U16 mint:6;
	U16 hr:5;
	U16 dom:5;
	U16 mon:4;
	U16 yr:9;
	U16 wdy:3;
	};

typedef struct tDTTM DTTM;

struct tDOPTYPOGRAPHY
	{
	U16 fKerningPunct:1;
	U16 iJustification:2;
	U16 iLevelOfKinsoku:2;
	U16 f2on1:1;
	U16 reserved:10;

	U16 cchFollowingPunct;
	U16 cchLeadingPunct;
	U16 rgxchFPunct[101];
	U16 rgxchLPunct[51];
	};

typedef struct tDOPTYPOGRAPHY DOPTYPOGRAPHY;

struct tDOGRID
	{
	U16 xaGrid;
	U16 yaGrid;
	U16 dxaGrid;
	U16 dyaGrid;
	U16 dyGridDisplay:7;
	U16 fTurnItOff:1;
	U16 dxGridDisplay:7;
	U16 fFollowMargins:1;
	};

typedef struct tDOGRID DOGRID;

struct tDOP	/*for the most part, none of these have any meaning when converted
			to another format, if they do they are commented*/
	{
	U16 fFacingPages:1;	
	U16 fWidowControl:1;	
	U16 fPMHMainDoc:1;	
	U16 grfSuppression:2;	
	U16 fpc:2;			/*where footnotes are put*/	
	U16 reserved1:1;
	U16 grpfIhdt:8;

	U16 rncFtn:2;	/*how to restart footnotes*/
	U16	nFtn:14;	/*first footnote no*/

	U16 fOutlineDirtySave:1;
	U16 reserved2:7;
	U16 fOnlyMacPics:1;
	U16 fOnlyWinPics:1;
	U16 fLabelDoc:1;
	U16 fHyphCapitals:1;
	U16 fAutoHyphen:1;
	U16 fFormNoFields:1;
	U16 fLinkStyles:1;
	U16 fRevMarking:1;

	U16 fBackup:1;
	U16 fExactCWords:1;
	U16 fPagHidden:1;
	U16 fPagResults:1;
	U16 fLockAtn:1;
	U16 fMirrorMargins:1;
	U16 reserved3:1;
	U16 fDfltTrueType:1;
	U16 fPagSuppressTopSpacing:1;
	U16 fProtEnabled:1;
	U16 fDispFormFldSel:1;
	U16 fRMView:1;
	U16 fRMPrint:1;
	U16 reserved4:1;
	U16 fLockRev:1;
	U16 fEmbedFonts:1;

	U16 copts_fNoTabForInd1:1;
	U16 copts_fNoSpaceRaiseLower:1;
	U16 copts_fSuppressSpbfAfterPageBreak:1;
	U16 copts_fWrapTrailSpaces:1;
	U16 copts_fMapPrintTextColor:1;
	U16 copts_fNoColumnBalance:1;
	U16 copts_fConvMailMergeEsc:1;
	U16 copts_fSupressTopSpacing:1;
	U16 copts_fOrigWordTableRules:1;
	U16 copts_fTransparentMetafiles:1;
	U16 copts_fShowBreaksInFrames:1;
	U16 copts_fSwapBordersFacingPgs:1;
	U16 reserved5:4;

	U16 dxaTab;
	U16 wSpare;
	U16 dxaHotZ;
	U16 cConsecHypLim;
	U16 wSpare2;

	DTTM dttmCreated;
	DTTM dttmRevised;
	DTTM dttmLastPrint;

	U16 nRevision;
	U32 tmEdited;
	U32 cWords;
	U32 cCh;
	U16 cPg;
	U32 cParas;

	U16 rncEdn:2;		/*how endnotes are restarted*/
	U16 nEdn:14;		/*beginning endnote no*/

	U16 epc:2;		/*where endnotes go*/
	U16 nfcFtnRef:4; /*number format code for auto footnotes, i think use the new_* instead*/
	U16 nfcEdnRef:4; /*number format code for auto endnotes, i thing use the new_* instead*/
	U16 fPrintFormData:1;
	U16 fSaveFormData:1;
	U16 fShadeFormData:1;
	U16 reserved6:2;
	U16 fWCFtnEdn:1;

	U32 cLines;
	U32 cWordsFtnEnd;
	U32 cChFtnEdn;
	U16 cPgFtnEdn;
	U32 cParasFtnEdn;
	U32 cLinesFtnEdn;
	U32 lKeyProtDoc;	/*password protection key (! ??)*/

	U16 wvkSaved:3;
	U16 wScaleSaved:9;
	U16 zkSaved:2;
	U16 fRotateFontW6:1;
	U16 iGutterPos:1;

	U32 fNoTabForInd:1;
	U32 fNoSpaceRaiseLower:1;
	U32 fSupressSpbfAfterPageBreak:1;
	U32 fWrapTrailSpaces:1;
	U32 fMapPrintTextColor:1;
	U32 fNoColumnBalance:1;
	U32 fConvMailMergeEsc:1;
	U32 fSupressTopSpacing:1;
	U32 fOrigWordTableRules:1;
	U32 fTransparentMetafiles:1;
	U32 fShowBreaksInFrames:1;
	U32 fSwapBordersFacingPgs:1;
	U32 reserved7:4;
	U32 fSuppressTopSpacingMac5:1;
	U32 fTruncDxaExpand:1;
	U32 fPrintBodyBeforeHdr:1;
	U32 fNoLeading:1;
	U32 reserved8:1;
	U32 fMWSmallCaps:1;
	U32 reserved9:10;

	U16 adt;
	DOPTYPOGRAPHY doptypography;
	DOGRID dogrid;
	
	U16 reserver11:1;
	U16 lvl:4;
	U16 fGramAllDone:1;
	U16 fGramAllClean:1;
	U16 fSubsetFonts:1;
	U16 fHideLastVersion:1;
	U16 fHtmlDoc:1;
	U16 reserved10:1;
	U16 fSnapBorder:1;
	U16 fIncludeHeader:1;
	U16 fIncludeFooter:1;
	U16 fForcePageSizePag:1;
	U16 fMinFontSizePag:1;

	U16 fHaveVersions:1;
	U16 fAutoVersion:1;
	U16 reserved11:14;

	ASUMYI asumyi;

	U32 cChWS;
	U32 cChWSFtnEdn;
	U32 grfDocEvents;
	U32 fVirusPrompted:1;
	U32 fVirusLoadSafe:1;
	U32 KeyVirusSession30:30;

	U8 Spare[30];
	U32 reserved12;
	U32 reserved13;

	U32 cDBC;
	U32 cDBCFtnEdn;
	U32 reserved14;
	U16 new_nfcFtnRef; /*number format code for auto footnote references*/
	U16 new_nfcEdnRef; /*number format code for auto endnote references*/
	U16 hpsZoonFontPag;
	U16 dywDispPag;
	};


typedef struct tDOP DOP;



struct tstringgroup
	{
	U16 *author;
	struct tstringgroup *next;
	int noofstrings;
	};

typedef struct tstringgroup stringgroup;

struct tTLP
	{
	U16 itl;
	U8 fShading;
	U8 fColor;
	U8 fHdrRows;
	U8 fLastRow;
	U8 fHdrCols;
	U8 fLastCol;
	};

typedef struct tTLP TLP;

struct ttablelook
	{
	/* TOP BAR
	color for the top left entry
	color for the otherwise odd top entries
	color for the even top entries
	*/

	/* EVEN ROWS
	color for the left entry
	color for the otherwise odd row entries
	color for the even entries
	*/

	/* ODD ROWS
	color for the left entry
	color for the otherwise odd row entries
	color for the even entries
	*/
	
	char *color[9];
	};

typedef struct ttablelook tablelook;

typedef struct _STTBF
	{
	U16 exflag;
	U16 no_of_strings;
	U16 extra_byte_flag;
	U16 **chars;
	U8 **extra_bytes;
	} STTBF;

struct tBKF
	{
	U16 ibkl;
	U16 flags;
	};

typedef struct tBKF BKF;

struct tobj_by_spid
	{
	U16 spid;
	char *filename;
	struct tobj_by_spid *next;
	};

typedef struct tobj_by_spid obj_by_spid;

struct node
	{
	char streamname[255];
	char filename[PATH_MAX];
	struct node *next;
	int level;
	};

typedef struct node olestream;

struct tsep
    {
    U8 bkc;         /*break code*/
    U8 fTitlePage;  /*want title page*/
    U8 fAutoPgn;    /*unused*/
    U8 nfcPgn;      /*page no format*/
    U8 fUnlocked;   /*huh ?*/
    U8 cnsPgn;      /*huh ?*/
    U8 fPgnRestart; /*restart pg numering*/
    U8 fEndNote;    /*footnotes at end of sec or page*/
    U8 lnc;         /*huh ?*/
    U8 grpfIhdt;    /*not used*/
    U8 nLnnMod;
    U16 ccolM1;
    U16 pgnStart;
    U32 xaPage;
    U32 yaPage;
    U32 dxaLeft;
    U32 dxaRight;
    U32 dyaTop;
    U32 dyaBottom;
    U32 dzaGutter;
    };

typedef struct tsep sep;

struct tchp
    {
	unsigned short istd;

    U8 fBold:1;
    U8 fItalic:1;
	U8 fRMarkDel:1;	
	U8 fOutline:1; /*not imp yet*/
	U8 fFldVanish:1; /*not imp yet, internal to word*/
	U8 fSmallCaps:1;
	U8 fCaps:1;
	U8 fVanish:1; /*not imp yet*/

	U8 fRMark:1; /*not imp yet*/
	U8 fSpec:1; 
	U8 fStrike:1;
	U8 fObj:1;	/*not imp yet*/
	U8 fShadow:1;	/*not imp yet*/
	U8 fLowerCase:1;	/*not imp yet*/
	U8 fData:1;
	U8 fOle2:1;	/*not imp yet*/

	U16 fEmboss:1;	/*not imp yet*/
	U16 fImprint:1; /*not imp yet*/
	U16 fDStrike:1;
	U16 fUsePgsuSettings:1; /*not imp yet, dont know what it means*/
	U16 Reserved1:12;	/*unused*/

	U32 Reserved2;	/*unused*/

	U16 ftc;	/*not used in word 8*/
	U16 ftcAscii;
	U16 ftcFE;
	U16 ftcOther;

	U16 fontsize; /*half points*/
	U8 supersubscript;
	U16 fontcode;
	U16 fontspec;
	char color[8];
	U16 underline;
	U8 idctHint;
	U32 fcPic;

	U16 ibstRMark;
	U16 ibstRMarkDel;
	DTTM dttmRMark;
	DTTM dttmRMarkDel;

	U16 fPropRMark;
	U16 ibstPropRMark;
	DTTM dttmPropRMark;
	U8 sfxtText;

	int allowedfont;
    };

typedef struct tchp chp;

struct tlist_def
	{
	U16 *list_string;	
	int len;
	S16 begin_no;
	int no_type;
	int fPrev;
	U32 id;
	chp achp;
	struct tlist_def *sub_def_list;
	};

typedef struct tlist_def list_def;

struct tanld
	{
	U8 nfc;
	U8 cxchTextBefore;
	U8 cxchTextAfter;
	U8 jc:2;	/*not imp yet*/
	U8 fPrev:1; /*not imp yet*/
	U8 fHang:1; /*not imp yet*/
	U8 fSetBold:1;
	U8 fSetItalic:1;
	U8 fSetSmallCaps:1; /*not imp yet*/
	U8 fSetCaps:1;	/*not imp yet*/
	/*
	U8 flags2;
	*/
	U8 fSetStrike:1; /*not imp yet*/
	U8 fSetKul:1;	
	U8 fPrevSpace:1; /*not imp yet*/
	U8 fBold:1;
	U8 fItalic:1;
	U8 fSmallCaps:1; /*not imp yet*/
	U8 fCaps:1; /*not imp yet*/
	U8 fStrike:1; /*not imp yet*/
	U8 flags3;
	U16 ftc;
	U16 hps;
	U16 startat;
	U16 rgxch[32];
	};

typedef struct tanld ANLD;


struct ttap
	{
	TLP tlp;
	int tablewidth;
	S16 cellwidth[65];
	int cell_no;
	int shade_no;
	int cell_backs[65];
	int cell_fronts[65];
	int cell_pattern[65];
	int rowheight;
	};

typedef struct ttap tap;

struct tpap
    {
    unsigned short istd;
    U8 fInTable;
    U8 fTtp;
	U8 tableflag;
	int justify;
	int ilvl; /*list level, 0 to 8*/
	long ilfo; /*list index*/
	/*link to list information*/
	list_def *list_data;
	ANLD anld;
	tap ourtap;
	S16 leftmargin;
	S16 rightmargin;
	S16 firstline;
	U32 brcBottom;
	U32 brcLeft;
	U32 brcRight;
	U32 brcBetween;
	U16 dxaWidth;
	U32 dyaBefore;
	U32 dyaAfter;
	char *begin;
	char *end;
	char *prespace;
	char *postspace;
    };

typedef struct tpap pap;


struct field_pro
	{
	U32 *cps;
	U8 *flds;
	int no;
	};

typedef struct field_pro field_info;

struct tlist_info
	{
	/*
	now this is very hairy, i not sure how this is supposed to work
	so lists are a bit tentitive, basically theres no many things you 
	*can* do with lists, but hopefully this will sort out whether they
	are bulleted or enumerated, and ignore all sorts of shite like
	what kind of bullet were talking about, and whether some list
	items are numbered etc etc
	*/
	U8 *array;
	int count;
	int nooflsts;
	U32 *o_lst_ids;
	int **current_index_nos;
	list_def *o_list_def;
	U8 *level;

	U8 *lstarray;
	int lstcount;
	int nooflfos;
	U32 *lst_ids;
	list_def *a_list_def;
	int *overridecount;
	};

typedef struct tlist_info list_info;

struct tsprm
	{
	U8 *list;
	struct tsprm *next;
	int len;
	};

typedef struct tsprm Sprm;

struct tcstyle
	{
	pap thepap;
	chp thechp;
	char *begin;
	char *end;
	char *name;
	char *prespace;
	char *postspace;
	char *Default;
	char *bold;
	char *italic;
	char *font;
	struct tcstyle *next;
	};

typedef struct tcstyle config_style;

struct _document_style
	{
	char *begin;
	int htwips;
	int vtwips;
	char *end;
	};

typedef struct _document_style document_style;

struct _element_style
	{
	char *begin;
	char *end;
	};

typedef struct _element_style element_style;

typedef enum
   {
   BOLD,  
   ITALIC,
   FONT
   } ele_type;

struct tstyle
	{
	pap thepap;
	chp thechp;
	char *name;
	char *begin;
	char *end;
	char *Default;
	char *prespace;
	char *postspace;
	char *font;
	char *bold;
	char *italic;
	};

typedef struct tstyle style;

struct tbookmark_limits
	{
	U32 bookmark_b_no;
	U32 *bookmark_b_cps;
	BKF *bookmark_b_bkfs;
	U32 bookmark_e_no;
	U32 *bookmark_e_cps;
	};

typedef struct tbookmark_limits bookmark_limits;


struct ttextportions
	{
	U32 fcMin;
	U32 fcMac;
	U32 ccpText;
	U32 ccpFtn;
	U32 ccpHdd;
	U32 ccpAtn;
	U32 ccpEdn;
	U32 fcPlcfhdd;
	U32 lcbPlcfhdd;
	U32 *headercplist;
	U8 headercpno;

	U32 fndref_no;
	U32 fndtxt_no;
	U32 *fndRef;
	FRD *fndFRD;
	U32 *fndTxt;
	int list_footnotes[256];
	int list_foot_no;
	int auto_foot;
	int last_foot;

	U32 endref_no;
	U32 endtxt_no;
	U32 *endRef;
	S16 *endFRD;
	S16 *endTrueFRD;
	U32 *endTxt;
	int list_endnotes[256];
	int list_end_no;
	int auto_end;

	U32 andref_no;
	U32 *andRef;
	U32 andtxt_no;
	U32 *andTxt;
	int list_annotations[256];
	int list_anno_no;
	stringgroup *authors;
	STTBF annotations;
	bookmark_limits a_bookmarks;
	ATRD *the_atrd;
	int last_anno;
	
	bookmark_limits l_bookmarks;
	STTBF bookmarks;

	/*
	STTBF revisions;
	*/

	U32 *section_cps;
	SED *section_fcs;
	int section_nos;

	int noofficedraw;
	U32 *officedrawcps;
	U32 *spids; /*im ignoring the rest of the FSPA for now*/

	int noofblipdata;
	obj_by_spid *ablipdata;
	};

typedef struct ttextportions textportions;

struct _ffn
	{
	char name[65];
	U8 chs;
	struct _ffn *next;
	};

typedef struct _ffn ffn;

#define IGNORENUM 0
#define DONTIGNORENUM 1
#define IGNOREALL 2


U16 read_16ubit(FILE *);
U32 read_32ubit(FILE *);

U32 sread_32ubit(U8 *in);
U16 sread_16ubit(U8 *in);
U8 sgetc(U8 *in);

U32 dread_32ubit(FILE *in,U8 **list);
U16 dread_16ubit(FILE *in,U8 **list);
U8 dgetc(FILE *in,U8 **list);

void cleanupstreams(char *analyze,char *slashtmp);
olestream * divide_streams(char *filename,char **analyze,char **slashtmp, char *argv0);
int decode_word8(FILE *mainfd, FILE *tablefd0,FILE *tablefd1,FILE *data,int core);
void get_table_info(FILE *tablefd,list_info *a_list_info,U32 fcSttbFnm,U32 lcbSttbFnm,U32 fcPlcfLst,U32 lcbPlcfLst,U32 fcPlfLfo,U32 lcbPlfLfo,style *sheet);

pap *get_pap(U32 pageindex,FILE *in,U32 charindex, U32 *nextfc,style *sheet,list_info *a_list_info);
chp *get_chp(U32 pageindex,FILE *in, FILE *data, U32 charindex, U32 *nextfc,style *sheet,U16 istd);
sep *get_sep(U32 offset,FILE *in);

void decode_clx(U32 startpiece,U32 begincp,U32 endcp,FILE *in,FILE *main,FILE *data,U32 fcClx,U32 lcbClx,U32 intervals,U32 chpintervals,U32 *plcfbtePapx,U32 *plcfbteChpx,field_info *all_fields[5],list_info *a_list_info,style *sheet,textportions *portions,ffn *fontnamelist,int headfooterflag);
void decode_clx_header(U32 *rgfc,sep *asep,int nopieces,U32 startpiece,U32 begincp,U32 endcp,FILE *in,FILE *main,FILE *data,U32 fcClx,U32 lcbClx,U32 intervals,U32 chpintervals,U32 *plcfbtePapx,U32 *plcfbteChpx,field_info *all_fields[5],list_info *a_list_info,style *sheet,textportions *portions,ffn *fontnamelist,int headerfooterflag);
void decode_clx_footer(U32 *rgfc,sep *asep,int nopieces,U32 startpiece,U32 begincp,U32 endcp,FILE *in,FILE *main,FILE *data,U32 fcClx,U32 lcbClx,U32 intervals,U32 chpintervals,U32 *plcfbtePapx,U32 *plcfbteChpx,field_info *all_fields[5],list_info *a_list_info,style *sheet,textportions *portions,ffn *fontnamelist,int headerfooterflag);
int decode_clx_endnote(U32 *rgfc,sep *asep,int nopieces,U32 startpiece,U32 begincp,U32 endcp,FILE *in,FILE *main,FILE *data,U32 fcClx,U32 lcbClx,U32 intervals,U32 chpintervals,U32 *plcfbtePapx,U32 *plcfbteChpx,field_info *all_fields[5],list_info *a_list_info,style *sheet,textportions *portions,ffn *fontnamelist,int headerfooterflag);

void decode_simple(FILE *mainfd,FILE *tablefd,FILE *data,U32 fcClx,U32 fcMin,U32 fcMac,U32 intervals,U32 chpintervals,U32 *plcfbtePapx,U32 *plcfbteChpx,field_info *all_fields[5],list_info *a_list_info,style *sheet,textportions *portions,ffn *fontnamelist,int flag);
int decode_simple_footer(FILE *mainfd,FILE *tablefd,FILE *data,sep *asep,U32 fcClx,U32 fcMin,U32 fcMac,U32 intervals,U32 chpintervals,U32 *plcfbtePapx,U32 *plcfbteChpx,field_info *all_fields[5],list_info *a_list_info,style *sheet,textportions *portions,ffn *fontnamelist,int flag);
int decode_simple_endnote(FILE *mainfd,FILE *tablefd,FILE *data,sep *asep,U32 fcClx,U32 fcMin,U32 fcMac,U32 intervals,U32 chpintervals,U32 *plcfbtePapx,U32 *plcfbteChpx,field_info *all_fields[5],list_info *a_list_info,style *sheet,textportions *portions,ffn *fontnamelist,int flag);
void decode_simple_header(FILE *mainfd,FILE *tablefd,FILE *data,sep *asep,U32 fcClx,U32 fcMin,U32 fcMac,U32 intervals,U32 chpintervals,U32 *plcfbtePapx,U32 *plcfbteChpx,field_info *all_fields[5],list_info *a_list_info,style *sheet,textportions *portions,ffn *fontnamelist,int flag);

int decode_letter(int letter,int flag,pap *apap, chp * achp,field_info *magic_fields,FILE *main,FILE *data,ffn *fontnamelist,list_info *a_list_info,textportions *portions,int *issection);
void decode_f_reference(textportions *portions);
void decode_e_reference(textportions *portions);
void get_next_f_ref(textportions *portions,signed long *nextfootnote);
void get_next_e_ref(textportions *portions,signed long *nextendnote);
void decode_annotation(textportions *portions, FILE *main);

void decode_s_specials(pap *apap,chp *achp,list_info *a_list_info);
int decode_s_table(pap *apap,chp *achp,list_info *a_list_info,int silent);
void decode_e_specials(pap *apap,chp *achp,list_info *a_list_info);
int decode_e_table(pap *apap,chp *achp,list_info *a_list_info,int silent);

void decode_s_chp(chp *achp, ffn *fontnamelist);
void decode_e_chp(chp *achp);

void chpsoff(void);
void chpson(void);

void decode_list_nfc(int value,int no_type);
void decode_list_level(pap *apap,int inalist,int num);

int flushbreaks(int);

void decode_s_anld(pap *apap,chp *achp,list_info *a_list_info,ffn *fontnamelist);
void decode_s_list(pap *apap,chp *achp,list_info *a_list_info,ffn *fontnamelist,int num);
void decode_e_list(pap *apap,chp *achp,list_info *a_list_info);

void decode_field(FILE *main,field_info *magic_fields,long *cp,U8 *fieldwas,long *swallowcp1,long *swallowcp2);

int find_FKPno_papx(U32 fc,U32 *plcfbtePapx,U32 intervals);
int find_FKPno_chpx(U32 fc,U32 *plcfbteChpx,U32 intervals);
U32 find_FC_sepx(U32 cp,U32 *sepcp,textportions *portions);
U32 find_next_smallest_fc(U32 charindex,U32 pageindex, FILE *in, S16 *location,long *pos);
U32 find_next_biggest_fc(U32 charindex,U32 pageindex, FILE *in, U16 *location,long *pos);
U32 find_next_biggest_orequal_fc(U32 charindex,U32 pageindex, FILE *in, U16 *location,long *pos);

pap * get_complex_pap(U32 fc,U32 *plcfbtePapx,U16 i,U16 nopieces,U32 intervals,U32 *rgfc,FILE *main,U32 *avalrgfc,U32 *thenextone,U32 *paraendfc,int *paraendpiece,style *sheet,list_info *a_list_info);
chp * get_complex_chp(U32 fc,U32 *plcfbteChpx,U16 i,U16 nopieces,U32 chpintervals,U32 *rgfc,FILE *main,U32 *avalrgfc,U32 *thenextone,style *sheet,U16 istd);

void decode_gpprls(pap *apap,chp *achp,sep *asep,U16* gpprlindex,int index,Sprm *sprmlists, style *sheet);

style *decode_stylesheet(FILE *tablefd,U32 stsh,U32 stshlen,config_style *in_style);
void fill_pap(style *stylelist,int m,int b);

void decode_sprm(FILE* in,U16 clist,pap *retpap,chp *retchp,sep *retsep,U16 *pos,U8 **list, style *sheet,U16 istd);

void error(FILE *stream,char *fmt, ...);
void oprintf(int silentflag,char *fmt, ...);

int decode_symbol(U16 fontspec);
char *symbolfontdir(void);

int decode_wingding(U16 fontspec);
char *wingdingfontdir(void);

char *patterndir(void);

void decode_header(U32 *begin,U32 *len,textportions *portions,sep *asep);
void decode_header2(U32 *begin,U32 *len,textportions *portions);
void decode_footer(U32 *begin,U32 *len,textportions *portions,sep *asep);
void decode_footnote(U32 *begin,U32 *len,textportions *portions,int i);
void decode_endnote(U32 *begin,U32 *len,textportions *portions,int i);
void decode_footanno(U32 *begin,U32 *len,textportions *portions,int i);

int get_piecetable(FILE *in,U32 **rgfc,U32 **avalrgfc,U16 **sprm,U32 *clxcount);

int find_piece_cp(U32 sepcp,U32  *rgfc,int nopieces);

obj_by_spid * get_blips(U32 fcDggInfo,U32 lcbDggInfo,FILE *tablefd,FILE *mainfd,int *noofblips,int streamtype,obj_by_spid **realhead);
void output_draw(U32 cp,textportions *portions);

void do_indent(pap *apap);
ffn *get_fontnamefromcode(ffn *fontnamelist,int fontcode, int *index);

U32 get_fc_from_cp(U32 acp,U32 *rgfc,U32 *avalrgfc,int nopieces);

void end_para(pap *apap, pap *newpap);

int isodd(int i);

/*
returns slot to use in index array which keeps track of how far each list
has got
*/
int decode_ilfo(pap *retpap,list_info *a_list_info);

void init_chp(chp * achp);
void init_pap(pap * apap);

/*result += modified - blank*/
void merge_chps(chp *blank,chp *modified,chp *result);

void init_chp_from_istd(U16 istd,style *sheet,chp *retchp);
void init_pap_from_istd(U16 istd,style *sheet,pap *retpap);

void get_para_bounds(int currentpiece,U32 fc,U32 *rgfc,U32 *avalrgfc, int nopieces, U32 *plcfbtePapx,U32 intervals, FILE *main);

char *ms_strlower(char *in);

int wvOLEdecode(char *filename, FILE **mainfd, FILE **tablefd0, FILE **tablefd1,FILE **data,FILE **summary);
int wvOLESummaryStream(char *filename,FILE **summary);

long get_picture_header(U32 fcPic,FILE *data,U32 *len,U16 *datatype);

void cleanupglobals(void);
char *ms_basename(char *filename);
void outputimgsrc(char *filename, int width,int height);


U32 decode_b_bookmark(bookmark_limits *l_bookmarks, STTBF *bookmarks);
U32 decode_e_bookmark(bookmark_limits *l_bookmarks);

U32 decode_b_annotation(bookmark_limits *l_bookmarks, STTBF *bookmarks);
U32 decode_e_annotation(bookmark_limits *l_bookmarks);

U16 *decode_hyperlink(int letter, long int *swallowcp1, long int *swallowcp2, U16 **deleteme);
void decode_bookmarks(FILE *mainfd,FILE *tablefd,textportions *portions);
U16 *decode_crosslink(int letter,long int *swallowcp1, long int *swallowcp2);

void decode_annotations(FILE *mainfd,FILE *tablefd,textportions *portions);

int decompress(FILE *inputfile,char *outputfile,U32 inlen,U32 outlen);
void myfreeOLEtree(void);

void output_tablebg(pap *apap);
int do_tablelooks(pap *apap);

int setdecom(void);

void pagebreak(void);
void columnbreak(void);
void sectionbreak(sep *asep);
void copy_tap(tap *rettap,tap *intap);
void check_auto_color(chp *achp);

stringgroup *extract_authors(FILE *tablefd,U32 fcGrpXstAtnOwners,U32 lcbGrpXstAtnOwners);
void extract_sttbf(STTBF *bookmarks,FILE *tablefd,U32 fcSttbf,U32 lcbSttbf);
void extract_bookm_limits(bookmark_limits *l_bookmarks,FILE *tablefd,U32 fcPlcfbkf,U32 lcbPlcfbkf, U32 fcPlcfbkl,U32 lcbPlcfbkl);

void do_dttm(U16 temp1_16,U16 temp2_16,DTTM *dttm);

int use_fontfacequery(chp *achp);

char *notoday(int no);

DOP *get_dop(U32 fcDop,U32 lcbDop, FILE *mainfd);
void get_doptypography(FILE *tablefd,DOPTYPOGRAPHY *doptypography);
void get_dogrid(FILE *tablefd,DOGRID *dog);
void get_asumyi(FILE *tablefd,ASUMYI *asu);

void convertwmf(char *filename);

int Parse (FILE * in,config_style **in_style,document_style **doc_style,element_style *ele_style);
int do_output_start(U32 *avalrgfc,int nopieces,document_style *doc_style);
void do_output_end(document_style *doc_style,int core,int tail);
char *argument(void);

int query_piece_cp(U32 *rgfc,U32* avalrgfc,int nopieces,long int querycp,U32 *nextpiececp,int *flag_8_16);
int query_piece_cp_seek(U32 *rgfc,U32* avalrgfc,int nopieces,long int querycp,U32 *nextpiececp,int *flag_8_16,FILE *fd);
void fill_table_info(pap *apap,U32 tapfc1, U32 *plcfbtePapx,U32 intervals, FILE *mainfd,style *sheet,list_info *a_list_info);

char *expand_variables(char *in, pap *apap);
char *expand_element(char *in, char *fontface, char *color, char *size);
void init_sep(sep *asep);
char *get_image_prefix(void);

int add_t(int **vals,S16 *p,int plen);
int gcf(int high, int low);
int gcf_list(int *vals,int cno);

#define NOOFIDS 8

/*interim*/
U32 wvGetSPIDfromCP(U32 cp,textportions *portions);

#endif
