#include "Message.h"

#ifdef SP_NAMESPACE
namespace SP_NAMESPACE {
#endif

struct ndscMessages {
  // 0
  static const MessageType0 specLosingError;
  // 1
  static const MessageType0 emptySpecError;
  // 2
  static const MessageType1 specNotFoundError;
  // 3
  static const MessageType1 tmpLosingError;
  // 4
  static const MessageType0L specUnreachableWarning;
  // 5
  static const MessageType2 specTypeWarning;
  // 6
  static const MessageType1 typeArgWarning;
  // 7
  static const MessageType2 badArchError;
  // 8
  static const MessageType0 emptySpecWarning;
  // 9
  static const MessageType1 errorLimitExceeded;
  // 10
  static const MessageType1 noEntityError;
};

const MessageType0 specLosingError(
MessageType::error,
MessageFragment::appModule,
0
#ifndef SP_NO_MESSAGE_TEXT
,"errors in DSSSL spec., cannot proceed"
#endif
);

const MessageType0 emptySpecError(
MessageType::error,
MessageFragment::appModule,
1
#ifndef SP_NO_MESSAGE_TEXT
,"No DSSSL spec found in spec file, aborting"
#endif
);

const MessageType1 specNotFoundError(
MessageType::error,
MessageFragment::appModule,
2
#ifndef SP_NO_MESSAGE_TEXT
,"No DSSSL spec named %1 found, aborting"
#endif
);

const MessageType1 tmpLosingError(
MessageType::error,
MessageFragment::appModule,
3
#ifndef SP_NO_MESSAGE_TEXT
,"Unable to open temporary file: %1, aborting"
#endif
);

const MessageType0L specUnreachableWarning(
MessageType::warning,
MessageFragment::appModule,
4
#ifndef SP_NO_MESSAGE_TEXT
,"Un-named non-first spec has no effect"
,"spec started here"
#endif
);

const MessageType2 specTypeWarning(
MessageType::warning,
MessageFragment::appModule,
5
#ifndef SP_NO_MESSAGE_TEXT
,"Spec %1 not of expected type (%2), ignored"
#endif
);

const MessageType1 typeArgWarning(
MessageType::warning,
MessageFragment::appModule,
6
#ifndef SP_NO_MESSAGE_TEXT
,"-t argument must be style or transform, not %1"
#endif
);

const MessageType2 badArchError(
MessageType::error,
MessageFragment::appModule,
7
#ifndef SP_NO_MESSAGE_TEXT
,"spec file must use DSSSL architecture, with public ID
%1
but this one uses
%2"
#endif
);

const MessageType0 emptySpecWarning(
MessageType::warning,
MessageFragment::appModule,
8
#ifndef SP_NO_MESSAGE_TEXT
,"No specs found at all!"
#endif
);

// lifted from ParserAppMessages
const MessageType1 errorLimitExceeded(
MessageType::info,
MessageFragment::appModule,
9
#ifndef SP_NO_MESSAGE_TEXT
,"maximum number of errors (%1) reached; change with -E option"
#endif
);

const MessageType1 noEntityError(
MessageType::error,
MessageFragment::appModule,
10
#ifndef SP_NO_MESSAGE_TEXT
,"Entity manager couldn't find external entity for ext. spec %1"
#endif
);

/* copied from CmdLineAppMessages.h, which cannot be included */
struct CmdLineAppMessages {
  // 4000
  static const MessageType1 invalidOptionError;
  // 4001
  static const MessageType1 missingOptionArgError;
  // 4002
  static const MessageType1 usage;
  // 4003
  static const MessageType1 versionInfo;
  // 4004
  static const MessageType1 unknownBctf;
  // 4005
  static const MessageType2 cannotOpenOutputError;
};

#ifdef SP_NAMESPACE
}
#endif

