
#include <string>

#include "data.hh"
#include "language.hh"
#include "language_exceps.hh"

namespace aspell {

  void DataSet::attach(const Language &l) {
    if (lang_ && strcmp(l.name(),lang_->name()) != 0)
      throw MismatchedLang(lang_->name(), l.name());
    if (!lang_) lang_ = new Language(l);
    ++attach_count_;
  }

  void DataSet::detach() {
    --attach_count_;
  }

  DataSet::DataSet()
    : lang_(0,false), attach_count_(0), basic_type(no_type) {}

  DataSet::~DataSet() {
  }

  bool DataSet::is_attached() const {
    return attach_count_;
  }

  const char * DataSet::lang_name() const {
    return lang_->name();
  }

  void DataSet::check_lang(const string &l) {
    if (l != lang_->name()) 
      throw MismatchedLang(lang_->name(), l);
  }

  void DataSet::set_check_lang (const string & l, const Config * config)
  {
    if (!is_attached()) {
      lang_ = new Language(l,*config);
      if (!lang_)
	throw UnknownLang(l);
    } else {
      if (l != lang_->name()) 
	throw MismatchedLang(lang_->name(), l);
    }
  }


}

