#include <iomanip>

#include "as_config.h"

#include "config.hh"
#include "file_exceps.hh"
#include "bad_value.hh"

#define MODES "none,url,email,sgml,tex"

namespace aspell {
  // 
  // GlobalConf
  //
  void Config::read_in() {
    
    //
    // environment overrides 
    //
    
    const char * env = getenv("ASPELL_CONF");
    if (env) read_in_string(env, Insert);
    
    //
    // personal configuration file
    //
    
    try {
      read_in_file(retrieve("per-conf-path"), Insert);
    } catch (CantReadFile) {}

    //
    // global conf file
    //
    
    try {
      read_in_file(retrieve("conf-path"), Insert);
    } catch (CantReadFile) {}
    
  }

  inline string get_mode_data(const Config & c, const string & mode) {
    try {
      return c.retrieve("fm-" + mode);
    } catch (UnknownKey) {
      throw BadValue("mode", mode, "one of " MODES);
    }
  }
  
  void Config::insert(const string & key, const string & value) {
    if (key == "mode") {
      string m = get_mode_data(*this, value);
      string & s = find("filter");
      s.insert(0, ",!," + m + ",");
    } else {
      ConfigData::insert(key,value);
    }
  }
  
  void Config::replace(const string & key, const string & value) {
    if (key == "mode") {
      string m = get_mode_data(*this, value);
      string & s = find("filter");
      s += ",!," + m + ","; 
    } else {
      ConfigData::replace(key,value);
    }
  }


  static const KeyInfo config_keys[] = {
    {"charset",  KeyInfo::String, "iso8859-1",0},
    {"conf",     KeyInfo::String, "aspell.conf",  "main configuration file"             },
    {"conf-dir", KeyInfo::String, CONFIGDIR,      "location of main configuration file" },
    {"conf-path",     KeyInfo::String, "<conf-dir/conf>",     0},
    {"data-dir", KeyInfo::String, DATADIR,        "location of language data files"     },
    {"dict-dir", KeyInfo::String, DICTDIR,        "location of the main word list"      },
    {"filter",   KeyInfo::List  , "url",             "add or removes a filter"},
    {"fm-email", KeyInfo::List  , "url,email",                         0},
    {"fm-none",  KeyInfo::List  , "",                                  0},
    {"fm-sgml",  KeyInfo::List  , "url,sgml,SGML&<charset>/<charset>", 0},
    {"fm-tex",   KeyInfo::List  , "url,tex",                           0},
    {"fm-url",   KeyInfo::List  , "url",                               0},
    {"home-dir", KeyInfo::String, "<$HOME|./>",   "location for personal files" },
    {"ignore",   KeyInfo::Int   , "1",            "ignore words <= n chars"             },
    {"ignore-repl", KeyInfo::Bool  , "false",     "ignore commands to store replacement pairs"},
    {"lang",     KeyInfo::String, "english",      "default language to use"             },
    {"master",   KeyInfo::String, "<lang>",       "main word list base name",           },
    {"master-path",   KeyInfo::String, "<dict-dir/master>",   0},
    {"mode",     KeyInfo::String, 0,             "filter mode = " MODES },
    {"per-conf", KeyInfo::String, ".aspell.conf", "personal configuration file"         },
    {"per-conf-path", KeyInfo::String, "<home-dir/per-conf>", 0},
    {"personal", KeyInfo::String, ".aspell.<lang>.pws",   "personal word list file name"},
    {"personal-path", KeyInfo::String, "<home-dir/personal>", 0},
    {"repl",     KeyInfo::String, ".aspell.<lang>.prepl", "replacements list file name" },
    {"repl-path",     KeyInfo::String, "<home-dir/repl>",     0},
    {"sug-mode",    KeyInfo::String, "normal",    "suggestion mode = fast|normal|bad-spellers"}
  };
}

namespace afilter {
  typedef const autil::KeyInfo * ConstKeyInfoPtr;
  extern ConstKeyInfoPtr 
    email_options_begin, email_options_end,
    sgml_options_begin, sgml_options_end,
    tex_options_begin, tex_options_end;
}

namespace aspell {
  static const ConfigData::Module modules[] = {
    {"email", afilter::email_options_begin, afilter::email_options_end},
    {"sgml",  afilter::sgml_options_begin,  afilter::sgml_options_end},
    {"tex",   afilter::tex_options_begin,   afilter::tex_options_end}
  };
  
  Config::Config() 
    : ConfigData ("Aspell " VERSION " configuration file",
		  config_keys, 
		  config_keys + sizeof(config_keys)/sizeof(KeyInfo),
		  modules,
		  modules+ sizeof(modules)/sizeof(ConfigData::Module)
		  )
  {}
}
