/*  XMMS - Cross-platform multimedia player
 *  Copyright (C) 1998-1999  Peter Alm, Mikael Alm, Olle Hallnas, Thomas Nilsson and 4Front Technologies
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef CONTROLSOCKET_H
#define CONTROLSOCKET_H

#define XMMS_PROTOCOL_VERSION		1

gboolean setup_ctrlsocket(void);
void cleanup_ctrlsocket(void);
void start_ctrlsocket(void);
void check_ctrlsocket(void);
gint ctrlsocket_get_session_id(void);

enum
{
	CMD_GET_VERSION, CMD_PLAYLIST_ADD, CMD_PLAY, CMD_PAUSE, CMD_STOP,
	CMD_IS_PLAYING, CMD_IS_PAUSED, CMD_GET_PLAYLIST_POS,
	CMD_SET_PLAYLIST_POS, CMD_GET_PLAYLIST_LENGTH, CMD_PLAYLIST_CLEAR,
	CMD_GET_OUTPUT_TIME, CMD_JUMP_TO_TIME, CMD_GET_VOLUME,
	CMD_SET_VOLUME, CMD_GET_SKIN, CMD_SET_SKIN, CMD_GET_PLAYLIST_FILE,
	CMD_GET_PLAYLIST_TITLE, CMD_GET_PLAYLIST_TIME, CMD_GET_INFO,
	CMD_GET_EQ_DATA, CMD_SET_EQ_DATA, CMD_PL_WIN_TOGGLE,
	CMD_EQ_WIN_TOGGLE, CMD_SHOW_PREFS_BOX, CMD_TOGGLE_AOT,
	CMD_SHOW_ABOUT_BOX, CMD_EJECT, CMD_PLAYLIST_PREV, CMD_PLAYLIST_NEXT,
	CMD_PING, CMD_GET_BALANCE, CMD_TOGGLE_REPEAT, CMD_TOGGLE_SHUFFLE, CMD_MAIN_WIN_TOGGLE, CMD_PLAYLIST_ADD_URL_STRING,
	CMD_IS_EQ_WIN, CMD_IS_PL_WIN, CMD_IS_MAIN_WIN
};

typedef struct
{
	guint16 version;
	guint16 command;
	guint32 data_length;
}
ClientPktHeader;

typedef struct
{
	guint16 version;
	guint32 data_length;
}
ServerPktHeader;

#endif
