#include <string.h>

#include "gcd.h"
#include "numbers.h"

/* Miroslav Vasko (vasko@ies.sk) - 7 bit characters flag */
extern int ascii;               /* from main.c */

WINDOW *wbignums = NULL;

void print_number(int y, int x, char *s, int color)
{
   int i, z;
   
   if (wbignums == NULL)
     wbignums = newwin(5,80,0,0);
   
   if (ascii) bnums = bnums7;
   else bnums = bnums8;
   
   for (i=0; i<strlen(s); i++)
   {       
      switch(s[i])
      { 
        case ':':
          z = 10;
          break;
        case '-':
          z = 11;
          break;
        case ' ':
          z = 12;
          break;
        default:
          if (s[i] < '0' || s[i] > '9')
            continue;
          z = s[i] - '0';
          break;
      }

      wattrset(wbignums, color);
      mvwprintw(wbignums, y, x, bnums[z].li1);
      mvwprintw(wbignums, y+1, x, bnums[z].li2);
      mvwprintw(wbignums, y+2, x, bnums[z].li3);
      mvwprintw(wbignums, y+3, x, bnums[z].li4);
      
      x += 8;
   }
   
   wrefresh(wbignums);
}

void draw_line(int y, int x, int len)
{
   int i;
   char s[121];
   
   for (i=0; i<len; i++)
      s[i]=32;
   s[i]=0;
   
   mvaddstr(y,x,s);
   refresh();
} 


void center(int y, char *s)
{
   int x;
   
   x = 40-(strlen(s)/2);
   mvprintw(y,x,s);
   refresh();
}

void lite(int color, int y, char *s)
{
   attrset(color);
   draw_line(y, 20, 40);
   center(y, s);
}

void delite(int y, char *s)
{
   lite(COLOR_PAIR(C_BLACK)|A_BOLD, y, s);
}

void hilite(int y, char *s)
{
   lite(COLOR_PAIR(C_GREEN_HL)|A_BOLD, y, s);
}      
