#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "npnews.h"

char *NP_News::change_group( char *newsgroup )
{
   static char buffer[ 1024 ];
   snprintf( buffer, sizeof buffer, "group %s\r\n", 
         (( newsgroup == NULL ) ? group : newsgroup ));
   if ( put_string( buffer ))
      return NULL;

   if ( get_string( buffer, sizeof buffer ))
      return NULL;

   if ( strncmp( buffer, "211", 3 ))
   {
      if ( !strncmp( buffer, "411", 3 ))
         snprintf( error_message, sizeof error_message, 
                   "NP_News: change_group(): "
                   "server does not carry group: %s.", group );
      else
         if ( !strncmp( buffer, "480", 3 ))
            strcpy( error_message,
                    "NP_News: change_group(): server requires"
                    " authentication." );
         else
            if ( !*buffer )
               snprintf( error_message, sizeof error_message, "NP_News: "
                         "change_group(): server disconnected." );
            else
               snprintf( error_message, sizeof error_message, "NP_News: "
                         "change_group(): server response: %s", buffer );

      return NULL;
   }

   return buffer;
}
