#include <string.h>

#include "npcompose.h"

void NP_Compose::load_quotes()
{
   char buffer[ 1024 ];
   snprintf( buffer, sizeof buffer, "%s/.peruser_spool/%s-%s", home,
             server, group );
   NP_File spool;
   if ( spool.openr( buffer ))
   {
      show_message( spool.get_error() );
      return;
   }

   if ( spool.seek( offset, SEEK_SET ))
   {
      show_message( spool.get_error() );
      return;
   }

   char *line, attrib[ 1024 ];
   int found = 0;

   do
   {
      if (( line = spool.get_string()) == NULL )
         break;

      if ( !found && !strncmp( line, "From:", 5 ))
      {
         found = 1;
         char *pointer = line + 5;
         pointer += strspn( pointer, " \t" );
         strtok( pointer, "\r\n" );

         snprintf( attrib, sizeof attrib, "%s wrote:\n\n", pointer );
      }
   }
   while( strncmp( line, "\r\n", 2 ));

   gtk_text_freeze( GTK_TEXT( text_widget ));

   if ( found )
      gtk_text_insert( GTK_TEXT( text_widget ), NULL, NULL, NULL,
                       attrib, strlen( attrib ));

   for( ; ; )
   {
      if (( line = spool.get_string()) == NULL )
         break;

      if ( !strncmp( line, ".\r\n", 3 ))
         break;

      if ( !strcmp( line, "\r\n" ))
         strcpy( buffer, ">\n" );
      else
         snprintf( buffer, sizeof buffer, "> %s\n", strtok( line, "\r\n" ));

      gtk_text_insert( GTK_TEXT( text_widget ), NULL, NULL, NULL,
                       buffer, strlen( buffer ));
   }

   gtk_text_thaw( GTK_TEXT( text_widget ));

   spool.close();

   return;
}

void NP_Compose::process_args( int argc, char **argv )
{
   if ( argc < 5 )
   {
      fprintf( stderr, "usage: npcompose news.server newsgroup.name "
               "(edit | original | follow-up | reply | both | cancel | "
               "supersede) (precursor-offset | -1)\n" );
      exit( 1 );
   }

   server = argv[ 1 ];
   group = argv[ 2 ];
   type = argv[ 3 ];
   offset = atol( argv[ 4 ] );

   switch( *type )
   {
   case 'b':
      create_reply();
      load_quotes();
      break;

   case 'c':
      create_cancel( 1 );
      break;

   case 'e':
      load( 0 );
      return;
      break;

   case 'f':
      create_follow_up();
      load_quotes();
      break;

   case 'j':
      create_jimmy();
      break;

   case 'o':
      create_original( 0 );
      break;

   case 'r':
      create_reply();
      load_quotes();
      break;

   case 's':
      create_cancel( 0 );
      break;
   }

   gtk_text_freeze( GTK_TEXT( header_widget ));
   gtk_text_insert( GTK_TEXT( header_widget ), NULL, NULL, NULL,
                    text, strlen( text ));

   if ( *type == 'c' )
   {
      gtk_text_insert( GTK_TEXT( text_widget ), NULL, NULL, NULL,
                       "Cancel message generated by News Peruser 4.0\n",
                        45 );
   }
 
   if ( *type != 'c' && *type != 's' )
   {
      char buffer[ 1024 ];
      snprintf( buffer, sizeof buffer, "%s/.signature", home );
      FILE *sig;
      if (( sig = fopen( buffer, "r" )) == NULL )
      {
         perror( "fopen" );
         return;
      }

      gtk_text_insert( GTK_TEXT( text_widget ), NULL, NULL, NULL, "\n", 1 );

      while( fgets( buffer, sizeof buffer, sig ) != NULL )
         gtk_text_insert( GTK_TEXT( text_widget ), NULL, NULL, NULL,
                          buffer, strlen( buffer ));

      fclose( sig );
   }

   gtk_text_thaw( GTK_TEXT( header_widget ));
   
   return;
}
