/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#include <config.h>

#include <gnome.h>

#include "globals.h"
#include "group-props.h"
#include "grouplist.h"
#include "gui.h"
#include "prefs.h"


/* Private structure for group properties */
typedef struct {
	GnomePropertyBox *dialog;
	GtkWidget *download_dir; /* GnomeFileEntry */
	group_data *group;
	server_data *server;
} GroupProps;


static GtkWidget* group_props_directories_page (GroupProps *gp);
static void group_props_apply (GtkWidget *widget, gint page_num, GroupProps *gp);
static void group_props_cancel (GtkWidget *widget, GroupProps *gp);


/* Apply button callback */
static void
group_props_apply (GtkWidget *widget, gint page_num, GroupProps *gp)
{
	g_return_if_fail (gp != NULL);

	group_set_attrib_string (gp->server, gp->group, "download_dir",
				 gtk_entry_get_text (GTK_ENTRY (gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(gp->download_dir)))));
}


/* Cancel/Close button callback */
static void
group_props_cancel (GtkWidget *widget, GroupProps *gp)
{
	gtk_widget_destroy (GTK_WIDGET (gp->dialog));

	g_free (gp);
}


/* Build and return directory-specific options page */
static GtkWidget *
group_props_directories_page (GroupProps *gp)
{
	GtkWidget *table;
	GtkWidget *label;
	gchar *p;

	table = gtk_table_new (1, 2, FALSE);
	gtk_container_set_border_width (GTK_CONTAINER (table), GNOME_PAD_SMALL);
        gtk_table_set_row_spacings (GTK_TABLE (table), GNOME_PAD_SMALL);
        gtk_table_set_col_spacings (GTK_TABLE (table), GNOME_PAD_SMALL);

	label = gtk_label_new (_("Directory for saving attached files"));
	gtk_table_attach (GTK_TABLE (table), label,
			  0, 1,
			  0, 1,
			  GTK_FILL | GTK_EXPAND,
			  GTK_FILL,
			  4, 0);

	gp->download_dir = gnome_file_entry_new ("Group Properties", ("Directory for saving attached files"));
	if ((p = group_get_attrib_string (gp->server, gp->group, "download_dir")) != NULL)
		gtk_entry_set_text (GTK_ENTRY (gnome_file_entry_gtk_entry (GNOME_FILE_ENTRY (gp->download_dir))), p);
	else
		gtk_entry_set_text (GTK_ENTRY (gnome_file_entry_gtk_entry (GNOME_FILE_ENTRY (gp->download_dir))), download_dir);

	gnome_file_entry_set_directory (GNOME_FILE_ENTRY (gp->download_dir), TRUE);

	g_free (p);

	gtk_signal_connect_object (GTK_OBJECT(gnome_file_entry_gtk_entry (GNOME_FILE_ENTRY (gp->download_dir))),
				   "changed",
				   GTK_SIGNAL_FUNC (gnome_property_box_changed),
				   GTK_OBJECT (gp->dialog));
	gtk_table_attach (GTK_TABLE (table), gp->download_dir,
			  1, 2,
			  0, 1,
			  GTK_FILL,
			  GTK_FILL,
			  4, 0);

	return table;
}


/**
 * group_props_spawn:
 * @gdata: The group to set the properties for.
 * 
 * Open the group properties dialog.
 **/
void
group_props_spawn (group_data *gdata)
{
	gchar *buf;
	GroupProps *gp;

	g_return_if_fail (gdata != NULL);

	gp = g_malloc0 (sizeof (GroupProps));
	gp->dialog = GNOME_PROPERTY_BOX (gnome_property_box_new());
	gp->group = gdata;
	gp->server = grouplist_get_current_server ();

	gtk_notebook_append_page (GTK_NOTEBOOK (gp->dialog->notebook),
				  group_props_directories_page (gp),
				  gtk_label_new (_("Directories")));

	/* pretty up the title */
	buf = g_strdup_printf ("Properties for: %s", gdata->name);
	gtk_window_set_title (GTK_WINDOW (gp->dialog), buf);
	g_free (buf);

	/* connect signals */
	gtk_signal_connect (GTK_OBJECT (gp->dialog),
			    "apply",
			    GTK_SIGNAL_FUNC (group_props_apply),
			    gp);
	gtk_signal_connect (GTK_OBJECT (gp->dialog),
			    "destroy",
			    GTK_SIGNAL_FUNC (group_props_cancel),
			    gp);

	/* draw it (centered) */
	gui_popup_draw (GTK_WIDGET(gp->dialog), Pan.window);
}
