/*
 * Copyright (c) 1998, 1999, Bjorn Lindgren <bjorn@goatnet.ml.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by
 *      Bjorn Lindgren <bjorn@goatnet.ml.org>.
 * 4. Neither the name of the authors nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

static const char rcsid[] = "$Id$";

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#include <xwhois.h>

__BEGIN_DECLS

void navigator_add __P((char *));
int navigator_check __P((char *));
/* int navigator_getsrvpos __P((char *)); */

__END_DECLS

static int nav_pos;
static int NAV_ADD_FLAG;
static int ne_c = 0;

void
navigator_add(item)
     char *item;
{
  int i;

#ifdef DEBUG
  fprintf(stderr, "*** navigator_add() *** (char *) item: \"%s\" (%d bytes)\n", item, strlen(item));
  fprintf(stderr, "*** navigator_add() *** (static int) ne_c: %d\n", ne_c);
#endif /* DEBUG */

  if (strlen(item) == 0) /* return if item string is empty */
    {
#ifdef DEBUG
      printf("*** navigator_add() *** (char *) item is 0 bytes, returning...\n");
#endif /* DEBUG */
      return;
    }

  if (NAV_ADD_FLAG == 1)
    {
      return;
    }

  if (ne_c > 0) /* no need to do checking is no objects are stored */
    {
      if (navigator_check(item) == 1)
	{
#ifdef DEBUG
	  fprintf(stderr, "*** navigator_add() *** (char *) item \"%s\" is already in the ne structs, returning...\n", item);
#endif /* DEBUG */
	  return;
	}
    }

  ne[ne_c].object = strdup(item);
  ne[ne_c].server = strdup(server);
  /*  ne[ne_c].server_pos = navigator_getsrvpos(server); */
  ne[ne_c].server_pos = getsrvpos(server);

  for (i=0 ; he[i].object != NULL ; i++);
  he[i].object = strdup(item);
  he[i].server = strdup(server);

#ifdef DEBUG
  fprintf(stderr, "*** navigator_add() *** (char *) ne[%d].object: \"%s\" (%d bytes)\n",
	  ne_c, ne[ne_c].object, strlen(ne[ne_c].object));
  fprintf(stderr, "*** navigator_add() *** (char *) ne[%d].server: \"%s\" (%d bytes)\n",
	  ne_c, ne[ne_c].server, strlen(ne[ne_c].server));
  fprintf(stderr, "*** navigator_add() *** (int) ne[%d].server_pos: %d\n", ne_c, ne[ne_c].server_pos);
#endif /* DEBUG */

  ne_c++; /* increse this for each new navigator entry */
  nav_pos++;

}

void
navigator_back()
{
#ifdef DEBUG
  fprintf(stderr, "*** navigator_back() *** (static int) nav_pos: %d\n", nav_pos);
#endif /* DEBUG */

  if (nav_pos == 0)
    {
#ifdef DEBUG
      fprintf(stderr, "*** navigator_back() *** (static int) nav_pos == 0, returning...\n");
#endif /* DEBUG */
      return;
    }

  nav_pos--;

  if (nav_pos > 0) /* accessing an negative array and you're roasted */
    {
      if (!strcmp(ne[nav_pos].object, gtk_entry_get_text(GTK_ENTRY (history_combo->entry))))
	{
	  nav_pos--;
	}
    }

  gtk_entry_set_text(GTK_ENTRY(history_combo->entry),
		     ne[nav_pos].object);
  gtk_list_select_item(GTK_LIST(server_list), ne[nav_pos].server_pos);
  NAV_ADD_FLAG = 1;
  gtk_signal_emit_by_name(GTK_OBJECT(b_submit), "clicked");
  NAV_ADD_FLAG = 0;
}

void
navigator_forward()
{
#ifdef DEBUG
  fprintf(stderr, "*** navigator_forward() *** (static int) nav_pos: %d\n", nav_pos);
#endif /* DEBUG */

  if (ne[nav_pos+1].object == NULL)
    {
#ifdef DEBUG
      fprintf(stderr, "*** navigator_forward() *** (char *) ne[nav_pos+1].object == NULL, returning...\n");
#endif /* DEBUG */
      return;
    }
  else
    {
      nav_pos++;
      gtk_entry_set_text(GTK_ENTRY(history_combo->entry),
			 ne[nav_pos].object);
      gtk_list_select_item(GTK_LIST(server_list), ne[nav_pos].server_pos);
      NAV_ADD_FLAG = 1;
      gtk_signal_emit_by_name(GTK_OBJECT(b_submit), "clicked");
      NAV_ADD_FLAG = 0;
    }
}

int
navigator_check(item)
     char *item;
{
  int i;

  for (i=0 ; i < ne_c ; i++)
    {
      if (!strcmp(item, ne[i].object))
	{
	  return 1;
	}
    }

  return 0;
}

/* obsolete, this func is moved to object.c */
/*
int
navigator_getsrvpos(server)
     char *server;
{
  int i;

  for (i=0 ; servers[i].name != NULL ; i++)
    {
      if (!strcmp(server, servers[i].name))
	{
	  return i;
	}
    }

  return 0;
}
*/
