'\"
'\" Copyright (c) 1996-1997 University of Twente.
'\" Copyright (c) 1997-1998 Technical University of Braunschweig.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" @(#) $Id: TnmInet.n,v 1.4 1998/03/26 15:58:34 schoenw Exp $
'\" 
.so man.macros
.TH TnmInet n "February 1998" Tnm "Tnm Tcl Extension"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
TnmInet \- A Tcl package to use and probe TCP/IP services.
.BE

.SH DESCRIPTION

The TnmInet package provides a set of Tcl command procedures to probe
various TCP/IP services. Most of the commands work synchronously which
means that they might block the process for a while if there are
communication problems. The result of some of the commands is returned
in a human readable format which in some cases depends on the software
that services requests. The main purpose of these functions is
therefore to retrieve information that is displayed in a
user-interface and not further processed by software.

.SH USING THE PACKAGE

The TnmInet package is loaded into a Tcl interpreter by using the 
following sequence of Tcl commands:

.CS
package require Tnm
.br
package require TnmInet $tnm(version)
.CE

All the TnmInet commands live in the TnmInet namespace. You can import
these commands into the current namespace by using the following Tcl
command:

.CS
namespace import TnmInet::*
.CE

It is however suggested to import commands explicitely or to use the
full name in scripts to avoid name clashes.

.SH COMMANDS

.TP
.B TnmInet::GetIpAddress \fIhost\fR
The \fBTnmInet::GetIpAddress\fR commmand takes a \fIhost\fR name or a
\fIhost\fR address and returns the \fIhost\fR address or an error if
the \fIhost\fR is not known in the local network database or in the
global Domain Name System (DNS).

.TP
.B TnmInet::GetIpName \fIhost\fR
The \fBTnmInet::GetIpName\fR command takes a \fIhost\fR name or a
\fIhost\fR address and returns the \fIhost\fR name or an error if
the \fIhost\fR is not known in the local network database or in the
global Domain Name System (DNS).

.TP
.B TnmInet::DayTime \fIhost\fR
The \fBTnmInet::DayTime\fR command connects to the daytime service on
\fIhost\fR and retrieves the local time of day. The command returns
the remote system time.

.TP
.B TnmInet::Finger \fIhost ?user?
The \fBTnmInet::Finger\fR command connects to a \fIhost\fR using the
finger user information protocol (RFC 1288).

.TP
.B TnmInet::TraceRoute \fIhost ?maxlength? ?retries?
The \fBTnmInet::TraceRoute\fR command uses the van Jacobsen algorithm
to trace a route through the Internet to \fIhost\fR. It returns the
routing trace in formatted, human readable format. The optional
\fImaxlength\fR and \fRretries\fR parameters set the maximum length of
a route and the number of retries for each hop.

.TP
.B TnmInet::TcpServices \fI?host?
The \fBTnmInet::TcpServices\fR command first reads obtains a list of
locally known service names and port numbers. Afterwards, it tries to
establish a TCP connection to each port number on \fIhost\fR. The
command returns a formatted, human readable list of TCP services 
where the attempt to establish a connection was successful.

.TP
.B TnmInet::RpcServices \fI?host?
The \fBTnmInet::RpcServices\fR command first obtains the list of ONC
RPC services registered at the portmapper on \fIhost\fR. Afterwards,
it probes every listed RPC service by calling RPC procedure 0. The
command returns a formatted, human readable list of RPC service
together with an indication if the call to procedure 0 was successful.
The output also contains the time needed to call procedure 0 for those
calls that were successful.

.TP
.B TnmInet::SendMail \fIrecipients message ?subject?
The \fBTnmInet::SendMail\fR command send a mail \fImessage\fR to a
list of \fIrecipients\fR. The option parameters defines the
\fIsubject\fR of the outgoing \fImessage\fR. The message is delivered
by talking SMTP (RFC 821) to the local mail transfer agent.

The \fBTnmInet::SendMail\fR uses the contents of the global tnm(email)
variable in the SMTP From: header line. The global variable tnm(email)
is set to "$tnm(user)@$tnm(domain)" if is does not exist.

.SH SEE ALSO
scotty(1), Tnm(n), Tcl(n)

.SH AUTHORS
Juergen Schoenwaelder <schoenw@ibr.cs.tu-bs.de>
.br
