/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996-1999 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    bhor0533@lehr.chem.TU-Berlin.DE
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifndef PFTP_STATUS_H
#define PFTP_STATUS_H

#if !defined Linux
#include <errno.h>
#endif
#include "connect.h"
#include "defines.h"

#if defined HAVE_GLIB || defined ULTRIX || defined NEXTSTEP || defined OSF1 || defined IRIX || defined IRIX64 || defined unicos
#include <errno.h>
#include <pwd.h>
#include <sys/types.h>
#endif

typedef struct status_type {
#ifndef USE_POSIX_THREAD
   unsigned isparent: 1;
#endif
   unsigned _STANDARD_INPUT_: 1; /* standard input */
   unsigned FORCE_STDOUT: 1; /* send received files to stdout */
   unsigned _RECURS_: 1; /* send directories recursivly */
   unsigned OVERWRITE: 2; /* overwrite all existing files */
   unsigned _PFTP_DAEMON_: 2; /* run as daemon: 1) keep running 2) exit after first connect */
   unsigned lol: 1; /* output '\r' */
   unsigned lognames: 1; /* log names when running as inetd server/ daemon */
   unsigned delete_info: 1; /* delete info file */
   unsigned READFROMSTDIN: 1; /* read file names from stdin */
   unsigned QT_FRONTEND: 1; /* client is running by the qt front end `qpftp' */
   unsigned ttys: 1; /* 0 and 1 are ttys */
   unsigned exit_afc: 1; /* exit after first connection */
   unsigned verbose: 1; /* output some more information */
   unsigned show_percent: 1; /* print percentage of bytes sent per file */
   unsigned single_connection: 1; /* accept only one connection at a time */
   unsigned use_udp: 1; /* using use datagram protocol (UDP) */
   unsigned first: 2;
   unsigned show_bytes: 1; /* display read in bytes during UDP transmission */
   unsigned autobitrate: 1; /* auto dertermination of bit rate */
   unsigned file_skipped: 1; /* skip the current file (UDP only) */
   unsigned rename: 1; /* existing files will be renamed */
   unsigned send_file_info: 1; /* send information about the file */
   unsigned accept_file_info: 1; /* accept information about the file */
   unsigned calc_dir: 1; /* recalculate size of upload directory */
#ifdef HAVE_FASYNC
   unsigned new_line: 1;
   unsigned key_pressed: 1;
#endif
#ifdef USE_POSIX_THREAD
   unsigned free: 1;
   unsigned RECEIVING: 1;
#endif
   /* Multicast members */
#if defined IPV6_MULTICAST_LOOP || defined IP_MULTICAST_LOOP
   unsigned multicast: 1; /* pftp sends resp. receives multicasted data */
   unsigned int mloop; /* IPV6_MULTICAST_LOOP resp. IP_MULTICAST_LOOP */
   int mttl; /* hop limit resp. time to live */
   char *_INTERFACE_;
   char *_MULTICASTGROUP_;
#endif
   /* End of multicast members */
   short _SKIP_;    /* skip all existing files */
   short _OPTIONS_; /* number of options */
   size_t _STDIN_BUFSIZ_; /* size of stdin buffer */
   size_t bsize; /* size of net buffer */
   char *_HOSTNAME_;
   char *version; /* version of server */
   char *sstatus; /* status of server */
   char *SENDMAKELINKS; /* don't follow symbolic links; send script file */
   int ns; /* client/server port to read from */
   int ws; /* client/server port to write to */
   int fd; /* file descriptor for receive */
   int host_number; /* chosen host number from host name list */
   double mul;
   unsigned long throw_away;
   double testbsize;
   unsigned long _BANDWIDTH_; /* sets the bandwidth in bytes */
   FILE *fp;
   FILE *rp;
   int fad_info; /* number of received file and directory information */
#ifdef HAVE_INET6
   int priority;
   struct addrinfo *adin;
   struct sockaddr_in6 sin;
#else
   struct sockaddr_in sin;
#endif
#ifdef USE_POSIX_THREAD
   long output;
#endif
   char *cwd_last_ch;
   char cwd[LONAME]; 
   char uploaddir[SONAME]; 
   char uploaddir_lock[SONAME]; 
   char uplimit_lock[SONAME]; 
   double last_dir_size;
   double start;
   char pw_dir[LONAME]; 
   char rlogin[SONAME];
   char from[SONAME];
   char pw_name[SONAME];
   char pw_passwd[SONAME];
   uid_t pw_uid;
   gid_t pw_gid;
   int sinlen;
   unsigned int usefilter; /* flag for option '-f' */
#ifndef USE_POSIX_THREAD
   unsigned int no_clients;
#endif
   unsigned int maxclients;
   char REMOTEHOSTNAME[SONAME]; /* name of current remote client host */
#ifdef HAVE_INET6
#ifndef INET6_ADDRSTRLEN
#define INET6_ADDRSTRLEN 46
#endif
   char REMOTEIP[INET6_ADDRSTRLEN]; /* numbers-and-colon notation */
#else
#ifndef INET_ADDRSTRLEN
#define INET_ADDRSTRLEN 16
#endif
   char REMOTEIP[INET_ADDRSTRLEN]; /* numbers-and-dots notation */
#endif
   char incoming_lock[LONAME]; /* let the pfm get informed of incoming data */
   char home[LONAME]; /* location of user's resource file */
} status_type;

/* Client structure */
typedef struct client_type {
   unsigned is_subdir: 1; /* determine if sending() was called recursively */
   unsigned print_wait: 1; /* print "Please wait ..." message */
   char **argv;
   int argc;
   int error_code;  /* client's error code */
} client_type;

typedef struct pftp_tv {
#ifdef OSF1
   time_t tv_sec;
   int tv_usec;
#else
   long tv_sec;
   long tv_usec;
#endif
} pftp_tv;

typedef struct pftp_file_status {
   unsigned info: 1; /* set received file information */
   int      mode;
   uid_t    uid;
   gid_t    gid;
   double   size;
   dev_t    dev;
   pftp_tv  time[2]; /* access and modification time */
   char     *name; /* file/directory name */
   char     *input;
   char     *end;
} pftp_file_status;
#endif /* STATUS_STRUCTURE_H */
