/*
  $Id: op.h,v 1.2 1996/10/22 01:01:47 luik Exp $

  op.h - op for omirrd C header file.
  Copyright (C) 1996, Andreas Luik, <luik@pharao.s.bawue.de>.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef OP_H_INCLUDED
#define OP_H_INCLUDED

#ifdef	__cplusplus
extern "C" {
#endif

#include "conn.h"


/* OpFile - used to save the file attributes like name, timestamp,
   FILE pointer during a write (W, X) - data (D) - writeend (E)
   sequence. Saved in `e->slave_op'.  */
typedef struct OpFile_ {
    FILE *f;			/* file pointer of work file to write */
    char *path;			/* target file name (from request) */
    char *tmppath;		/* temporary work file name */
    int error;			/* error flag */
    time_t timestamp;		/* timestamp (from request) */
} *OpFile, OpFileRec;


/* op.c */
extern OpFile opAllocSlaveOp(void);
extern void opFreeSlaveOp(OpFile op_file);
extern void opSlave(ReqRequest r, ConnEntry e);
extern void opMaster(ReqRequest r, ConnEntry e);

#ifdef	__cplusplus
}
#endif

#endif /* defined(OP_H_INCLUDED) */
