/*
 * makeflash.h  -  Include file for generating a FlashCard boot image file
 *
 * Copyright (C) 1997,1998 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _MAKEFLASH_H_
#define _MAKEFLASH_H_


/*
 * Everything in this file has to be in packed structures.
 */
#ifdef USE_PRAGMA
#pragma pack(1)
#endif
#ifdef USE_PRAGMA_ALIGN
#pragma options align=packed
#endif



/*
 * Size of I/O buffers
 */
#define SECTSIZE	512



/*
 * The bootrom loads the load header to 0x10000, the FlashCard programmer
 * to 0x10400, and the boot rom image at 0x30000.
 */
#define HEADERSEG	0x1000		/* segment for primary load header */
#define HEADERLSIZE	512L		/* maximum load size of load header */
#define HEADERMSIZE	512L		/* maximum memory size of load header */

#define PROGRAMSEG	0x1040		/* segment for FlashCard programmer */
#define PROGRAMLSIZE	64512L		/* maximum load size of programer */
#define PROGRAMMSIZE	64512L		/* maximum memory size of programmer */

#define ROMIMAGESEG	0x3000		/* segment for boot rom image */



/*
 * The boot image has the following header in it's first sector
 */
struct load_header {
  struct i_long magic		PACKED;		/* magic number */
  __u8          hlength		PACKED;		/* length of header */
  __u8          hflags1		PACKED;		/* header flags */
  __u8          hflags2		PACKED;
  __u8          hflags3		PACKED;
  struct i_addr locn		PACKED;		/* location of this header */
  struct i_addr execute		PACKED;		/* execution address */
  __u8          dummy[494];			/* up to full sector */
  __u16         bootsig		PACKED;		/* boot signature */
};

#define HEADER_MAGIC	0x1B031336		/* Magic no for load header */
#define BOOT_SIGNATURE	0xaa55			/* Boot signature */


struct load_record {
  __u8              rlength	PACKED;		/* length of record */
  __u8              rtag1	PACKED;		/* record tags */
  __u8              rtag2	PACKED;
  __u8              rflags	PACKED;		/* record flags */
  struct i_long     address	PACKED;		/* abs addr for part in mem */
  struct i_long     ilength	PACKED;		/* len of part in boot image */
  struct i_long     mlength	PACKED;		/* memory needed for part */
};

#define FLAG_B0		1
#define FLAG_B1		2
#define FLAG_EOF	4



/*
 * Number of each load record.
 */
#define PROGRAMNUM	0		/* FlashCard programmer */
#define ROMIMAGENUM	1		/* boot rom image */

#define NUM_RECORDS	2

#define VENDOR_ID	"GK-makerom"	/* Vendor ID */
#define VENDOR_OFF	16		/* Offset for vendor tags */



/*
 * Turnoff structure packing and return to normal data alignment.
 */
#ifdef USE_PRAGMA
#pragma pack()
#endif
#ifdef USE_PRAGMA_ALIGN
#pragma options align=reset
#endif



/*
 * Data area which holds the FlashCard programming loader
 */
extern unsigned char flash_data[];
extern unsigned int flash_data_size;


#endif

