/*
 *  pqrm.c
 *
 *  Remove job from a print queue on a server
 *
 *  Copyright (C) 1998 by Petr Vandrovec, David Woodhouse
 *  Derived from pqlist.c, (C) 1996 Volker Lendecke
 *
 */

#include "config.h"

#include <stdio.h>
#include <unistd.h>
#include <ctype.h>
#include <stdlib.h>
#include <ncp/nwcalls.h>

#include <libintl.h>
#define _(X) gettext(X)

int
main(int argc, char **argv)
{
	struct ncp_conn *conn;
	struct ncp_bindery_object q;
	long err;
	int i;

	setlocale(LC_ALL, "");
	bindtextdomain(PACKAGE, LOCALEDIR);
	textdomain(PACKAGE);
	
	if ((conn = ncp_initialize(&argc, argv, 1, &err)) == NULL)
	{
		com_err(argv[0], err, _("when initializing"));
		return 1;
	}

	if (argc < 3)
	{
		fprintf(stderr, _("usage: %s <queue> <jobID> [<jobID> ...]\n"), argv[0]);
		return 1;
	}


	if (ncp_get_bindery_object_id(conn, NCP_BINDERY_PQUEUE, 
                                      argv[1], &q) != 0)
	{
		char server[NW_MAX_SERVER_NAME_LEN];
		const char* sptr = server;
		NWCCODE err;

		err = NWCCGetConnInfo(conn, NWCC_INFO_SERVER_NAME,
			sizeof(server), server);
		if (err)
			sptr = "?";

                printf(_("Queue \"%s\" on server %s not found.\n"),
                       argv[1], sptr);
                ncp_close(conn);
                exit(1);

	}

	for (i=2; i<argc; i++) {
		u_int32_t jobID;
		char* end;

		jobID = strtoul(argv[i], &end, 16);
		if (*end) {
			fprintf(stderr, _("Cannot parse \"%s\" - jobID must be hexadecimal number\n"), argv[i]);
		} else {
			int err;

			err = NWRemoveJobFromQueue2(conn, q.object_id, jobID);
			if (err == 0x89D5) {
				fprintf(stderr, _("Job %08X does not exist\n"), jobID);
			} else if (err == 0x89D6) {
				fprintf(stderr, _("You have not rights to cancel job %08X\n"), jobID);
			} else if (err) {
				fprintf(stderr, _("Cannot cancel job %08X: %s\n"), jobID, strnwerror(err));
			}
		}
	}
	ncp_close(conn);
	return 0;
}

