# -*- mode: Perl -*-
######################################################################
### Localization of mrtg output pages
######################################################################
#                                                                    #
#   This is a generated perl module file.                            #
#   Please see the perl script mergelocale.pl and the language       #
#   databasefiles skelton.pm0 and locale.*.pmd in translate/.        #
#   If you want to contribute to mrtg change in the *.pmd files.     #
#   If you just want to change your own mrtg: Go ahead and edit!     #
#                                                                    #
######################################################################
### Defines programs which handles centralized pattern matching and pattern 
### replacements in order to translate the given strings
######################################################################
### Created by:  Morten Storgaard Nielsen <msn@ipt.dtu.dk>
###################################################################
#
# Distributed under the GNU copyleft
#
###################################################################
### Locale by: 
###      Chinese/c
###      => Tate Chen @ <tate@joy-tech.com.tw>
###      Brazil/Brazilian Portuguese
###      => Luiz Felipe R E <luizfelipe@encarnacao.com>
###      Czech/esky
###      => Martin Och <martin@och.cz>
###      Danish/Dansk   
###      => Morten Storgaard Nielsen <msn@ipt.dtu.dk>
###      Dutch/Nederlands
###      => Barry van Dijk <barry@dijk.com>
###      French/Francais
###      => Fabrice Prigent <fabrice.prigent@univ-tlse1.fr>
###         and Stphane Marzloff <secrer@le-bar.fdn.fr>
###      German/Deutsch   
###      => Ilja Pavkovic <illsen@gumblfarz.de>
###      Greek/Ellinika
###      => Simos Xenitellis <S.Xenitellis@rhbnc.ac.uk>
###      Italian/Italiano
###      => Andrea Rossi <rouge@shiny.it>
###      Korean
###      => Kensoon Hwang <lovesh@static.co.kr>
###      Malaysian/Indonesian/Malay   
###      => Assakhof Ab. Satar <assakhof@mimos.my>
###      Polish/Polski
###      => Lukasz Jokiel <Lukasz.Jokiel@po.opole.pl>
###      Russian/
###      =>   <dima@chg.ru>
###      Spanish/Espaol
###      => Marcelo Roccasalva <marcelo@linuxfan.com>
###
### Contributions and fixes by:
###
###      0.05 fixed DARK GREEN entry		(msn@ipt.dtu.dk)
###           fixed credits for native language (msn@ipt.dtu.dk)
###	 0.06 added the PATCHTAGs               (msn@ipt.dtu.dk)
###           fixed several small errors        (msn@ipt.dtu.dk)
###	 0.07 changed PATCHTAG to support 
###           mergelocale.pl                    (msn@ipt.dtu.dk)
###
######################################################################
###
package locales_mrtg;

require 5.002;

use strict;
use vars qw(@ISA @EXPORT $VERSION);
use Exporter;

$VERSION = '0.07';

@ISA = qw(Exporter);

@EXPORT = qw
(
  &english
  &big5
  &brazilian 
  &czech
  &danish
  &dutch
  &french
  &german
  &greek
  &italian
  &korean
  &malay
  &polish
  &russian
  &spanish
);

%lang2tran::LOCALE=  
(
  'english'      => \&english,
  'default'      => \&english, 
  'big5'         => \&big5, 
  'c'     => \&big5,
  'brazil'       => \&brazilian,
  'brazilian'    => \&brazilian,
  'czech' 	 => \&czech,
  'danish'       => \&danish, 
  'dansk'        => \&danish,
  'dutch'        => \&dutch,
  'nederlands'   => \&dutch,
  'french'       => \&french,
  'francais'     => \&french,
  'german'       => \&german, 
  'german'        => \&german,
  'greek'    	 => \&greek,
  'ellinika' 	 => \&greek,
  'italian'    	 => \&italian,
  'italiano' 	 => \&italian,
  'korean'      => \&korean,
  'malay'       => \&malay, 
  'malaysian'   => \&malay,
  'indonesian'  => \&malay, 
  'polish'	 => \&polish,
  'polski'       => \&polish,
  'russian'	 => \&russian,
  ''      => \&russian,
  'spanish'	 => \&spanish,
  'espanol'	 => \&spanish,
);

%credits::LOCALE=
  (
# default
   'default' =>
   "  <HR NOSHADE>
  <TD WIDTH=388 ALIGN=RIGHT><FONT FACE=\"Arial,Helvetica\" SIZE=2>
  Prepared for localization by
    <NOBR><A HREF=\"http://www.ipt.dtu.dk\">Morten S. Nielsen</A>
  <A HREF=\"mailto:msn\@ipt.dtu.dk\">
  &lt;msn\@ipt.dtu.dk&gt;</A></NOBR>",
# Chinese/c
   'big5' =>
   "  <HR NOSHADE>
  <TD WIDTH=388 ALIGN=RIGHT><FONT FACE=\"Arial,Helvetica\" SIZE=2>
  Ƨ@
    <NOBR><A HREF=\"http://www.joy-tech.com.tw/~tate\">Tate Chen</A>
  <A HREF=\"mailto:tate\@joy-tech.com.tw\">
  &lt;tate\@joy-tech.com.tw&gt;</A></NOBR>",
# Brazil/brazilian
   'brazilian' =>
   "  <HR NOSHADE>
  <TD WIDTH=388 ALIGN=RIGHT><FONT FACE=\"Arial,Helvetica\" SIZE=2>
  Localiza&ccedil;&atilde;o efetuada por
    <NOBR><A HREF=\"http://www.encarnacao.com\">Luiz Felipe R E</A>
  <A HREF=\"mailto:luizfelipe\@encarnacao.com\">
  &lt;luizfelipe\@encarnacao.com&gt;</A></NOBR>",
# Czech/esky
   'czech' =>
   "  <HR NOSHADE>
  <TD WIDTH=388 ALIGN=RIGHT><FONT FACE=\"Arial,Helvetica\" SIZE=2>
  esk peklad pipravil
    <NOBR><A HREF=\"http://www.och.cz\">Martin Och</A>
  <A HREF=\"mailto:martin\@och.cz\">
  &lt;martin\@och.cz&gt;</A></NOBR>",
# Danish/dansk
   'danish' =>
   "  <HR NOSHADE>
  <TD WIDTH=388 ALIGN=RIGHT><FONT FACE=\"Arial,Helvetica\" SIZE=2>
  Forberedt for sprog samt oversat til dansk af
    <NOBR><A HREF=\"http://www.ipt.dtu.dk\">Morten S. Nielsen</A>
  <A HREF=\"mailto:msn\@ipt.dtu.dk\">
  &lt;msn\@ipt.dtu.dk&gt;</A></NOBR>",
# the danish string means: "Prepared for languages and translated to danish by"
# Dutch/nederlands
   'dutch' =>
   "  <HR NOSHADE>
  <TD WIDTH=388 ALIGN=RIGHT><FONT FACE=\"Arial,Helvetica\" SIZE=2>
  Vertaald naar het Nederlands door
    <NOBR><A HREF=\"http://doema.peterson.nl\">Barry van Dijk</A>
  <A HREF=\"mailto:barry\@dijk.com\">
  &lt;barry\@dijk.com&gt;</A></NOBR>",
# French/francais
   'french' =>
   "  <HR NOSHADE>
  <TD WIDTH=388 ALIGN=RIGHT><FONT FACE=\"Arial,Helvetica\" SIZE=2>
  Localisation effectu&eacute;e par
    <NOBR><A HREF=\"http://cache.univ-tlse1.fr/les.personnes/fabrice.prigent\">Fabrice Prigent</A>
  <A HREF=\"mailto:fabrice.prigent\@univ-tlse1.fr\">
  &lt;fabrice.prigent\@univ-tlse1.fr&gt;</A></NOBR>",
# German/deutsch
   'german' =>
   "  <HR NOSHADE>
  <TD WIDTH=388 ALIGN=RIGHT><FONT FACE=\"Arial,Helvetica\" SIZE=2>
  Vorbereitet fr die Lokalisation von
    <NOBR><A HREF=\"http://www.gumblfarz.de/~illsen\">Ilja Pavkovic</A>
  <A HREF=\"mailto:illsen\@gumblfarz.de\">
  &lt;illsen\@gumblfarz.de&gt;</A></NOBR>",
# Greek/Ellinika
   'greek' =>
   "  <HR NOSHADE>
  <TD WIDTH=388 ALIGN=RIGHT><FONT FACE=\"Arial,Helvetica\" SIZE=2>
      
    <NOBR><A HREF=\"http://hq.hellug.gr/~nls\"> </A>
  <A HREF=\"mailto:S.Xenitellis\@rhbnc.ac.uk\">
  &lt;S.Xenitellis\@rhbnc.ac.uk&gt;</A></NOBR>",
# Italian/Italiano
   'italian' =>
   "  <HR NOSHADE>
  <TD WIDTH=388 ALIGN=RIGHT><FONT FACE=\"Arial,Helvetica\" SIZE=2>
  Localizzazione effettuata da
    <NOBR><A HREF=\"http://shinystat.shiny.it\">Andrea Rossi</A>
  <A HREF=\"mailto:rouge\@shiny.it\">
  &lt;rouge\@shiny.it&gt;</A></NOBR>",
# korean
   ,'korean' =>
   "  <HR NOSHADE>
  <TD WIDTH=388 ALIGN=RIGHT><FONT FACE=\"Arial,Helvetica\" SIZE=2>
  ѱȭ
    <NOBR><A HREF=\"mailto:lovesh\@static.co.kr\">Keonsoon Hwang</A>
  </NOBR>",
# Malaysian/Indonesian/Malay
   'malay' =>
   "  <HR NOSHADE>
  <TD WIDTH=388 ALIGN=RIGHT><FONT FACE=\"Arial,Helvetica\" SIZE=2>
  Terjemahan ke bahasa Malaysia/Indonesia oleh:
    <NOBR><A HREF=\"http://www.mimos.my\">Assakhof Ab. Satar</A>
  <A HREF=\"mailto:assakhof\@mimos.my\">
  &lt;assakhof\@mimos.my&gt;</A></NOBR>",
# Polish/polski
   'polish' =>
   "  <HR NOSHADE>
  <TD WIDTH=388 ALIGN=RIGHT><FONT FACE=\"Arial,Helvetica\" SIZE=2>
  Polska lokalizacja
    <NOBR><A HREF=\"http://www.po.opole.pl/~lcj\">Lukasz Jokiel</A>
  <A HREF=\"mailto:Lukasz.Jokiel\@po.opole.pl\">
  &lt;Lukasz.Jokiel\@po.opole.pl&gt;</A></NOBR>",
# Russian/
   'russian' =>
   "  <HR NOSHADE>
  <TD WIDTH=388 ALIGN=RIGHT><FONT FACE=\"Arial,Helvetica\" SIZE=2>
     :
    <NOBR><A HREF=\"http://www.chg.ru/~dima/\"> </A>
  <A HREF=\"mailto:dima\@Chg.RU\">
  &lt;dima\@Chg.RU&gt;</A></NOBR>",
# Spanish/espaol
    'spanish' =>
    "  <HR NOSHADE>
   <TD WIDTH=388 ALIGN=RIGHT><FONT FACE=\"Arial,Helvetica\" SIZE=2>
   Preparado para localizacin por
     <NOBR><A HREF=\"mailto:marcelo\@linuxfan.com\">Marcelo Roccasalva</A>
     </NOBR>",
  );

$credits::LOCALE{'c'}=$credits::LOCALE{'big5'};
$credits::LOCALE{'brazil'}=$credits::LOCALE{'brazilian'};
$credits::LOCALE{'czech'}=$credits::LOCALE{'czech'};
$credits::LOCALE{'dansk'}=$credits::LOCALE{'danish'};
$credits::LOCALE{'nederlands'}=$credits::LOCALE{'dutch'};
$credits::LOCALE{'francais'}=$credits::LOCALE{'french'};
$credits::LOCALE{'deutsch'}=$credits::LOCALE{'german'};
$credits::LOCALE{'ellinika'}=$credits::LOCALE{'greek'};
$credits::LOCALE{'italiano'}=$credits::LOCALE{'italian'};
# $credits::LOCALE{'korean'}=$credits::LOCALE{'korean'};
$credits::LOCALE{'malaysian'}=$credits::LOCALE{'malay'};
$credits::LOCALE{'indonesian'}=$credits::LOCALE{'malay'};
$credits::LOCALE{'polski'}=$credits::LOCALE{'polish'};
$credits::LOCALE{''}=$credits::LOCALE{'russian'};
$credits::LOCALE{'espanol'}=$credits::LOCALE{'spanish'};

# English - default
sub english
{
  return pop(@_);
};

# Chinese Big5 Code

sub big5
{
  my($string)=pop(@_);
  my(%translations,%month,%wday);

  my($i,$j);
  my(@dollar,@quux,@foo);

  
  # regexp => replacement string NOTE does not use autovars $1,$2...
  # charset=iso-2022-jp

  %translations =
  (  
     'charset=iso-8859-1'                     => 'charset=iso-8859-1',
     'Maximal 5 Minute Incoming Traffic'      => '5̤jyJq',
     'Maximal 5 Minute Outgoing Traffic'      => '5̤jyXq',
     'the device'                             => '˸m',
     'The statistics were last updated(.*)'   => 'Wέpsɶ: $1',
     ' Average\)</B><BR>'                     => ' )</B><BR>',
     '<TD ALIGN=right><SMALL>Average(.*)'     => '<TD ALIGN=right><SMALL>$1',
     '<TD ALIGN=right><SMALL>Max(.*)'         => '<TD ALIGN=right><SMALL>̤j$1',
     '<TD ALIGN=right><SMALL>Current(.*)'     => '<TD ALIGN=right><SMALL>ثe$1',
     'version'                                => '',
     '<B>`Daily\' Graph \((.*) Minute'        => '<B>C Ϫ ($1 ',
     '<B>`Weekly\' Graph \(30 Minute'         => '<B>Cg Ϫ (30 ' ,
     '<B>`Monthly\' Graph \(2 Hour'           => '<B>C Ϫ (2 p',
     '<B>`Yearly\' Graph \(1 Day'             => '<B>C~ Ϫ (1 ',
     'Incoming Traffic in (\S+) per Second'   => 'CyJq ( $1)',
     'Outgoing Traffic in (\S+) per Second'   => 'CyXq ( $1)',
     'at which time (.*) had been up for(.*)' => ']ƦW $1AwB@ɶ(UPTIME): $2',
     '([kMG]?)([bB])/s'                       => '\$1\$2/',
     '([kMG]?)([bB])/min'                     => '\$1\$2/',
     '([kMG]?)([bB])/h'                       => '$1$2/',
    # 'Bits'                                   => 'Bits',
    # 'Bytes'                                  => 'Bytes'
     '&nbsp;In:</FONT>'                       => '&nbsp;yJ:</FONT>',
     '&nbsp;Out:</FONT>'                      => '&nbsp;yX:</FONT>',
     '&nbsp;Percentage</FONT>'                => '&nbsp;ʤ:</FONT>',
     'Ported to OpenVMS Alpha by'             => 'Ө OpenVM Alpha @',
     'Ported to WindowsNT by'                 => 'Ө WindowsNT @',
     'and'                                    => '',
     '^GREEN'                                 => '',
     'BLUE'                                   => 'Ŧ',
     'DARK GREEN'                             => '',
     'MAGENTA'                                => '',
     'AMBER'                                  => '[Ħ'
  );

# maybe expansions with replacement of whitespace would be more appropriate
foreach $i (keys %translations)
{
  if($string=~/$i/)
  { 
    (@dollar)=($string=~/()$i/); # I hope this prevents the autovars
    $string=$translations{$i};  # And it only works from $1-$9
    for($j=1;@dollar[$j];$j++)   # s/// doesn't do any good with saved "$1"-exprs.
    {
      @quux=();
      (@quux)=split(/\$$j/,$string);
      $string=@quux[0].@dollar[$j].@quux[1];
    } ; 
    return $string;
  };
};

%wday =
    (
      'Sunday'    => 'P',        'Sun' => '',
      'Monday'    => 'P@',        'Mon' => '@',
      'Tuesday'   => 'PG',        'Tue' => 'G',
      'Wednesday' => 'PT',        'Wed' => 'T',
      'Thursday'  => 'P|',        'Thu' => '|',
      'Friday'    => 'P',        'Fri' => '',
      'Saturday'  => 'P',        'Sat' => ''

    );

%month =
    (
      'January'   => '@',   'February'  => 'G',    'March'     => 'T',
      'Jan'       => '@',     'Feb'       => 'G',      'Mar'       => 'T',
      'April'     => '|',   'May'       => '',    'June'      => '',
      'Apr'       => '|',     'May'       => '',      'Jun'       => '',
      'July'      => 'C',   'August'    => 'K',    'September' => 'E',
      'Jul'       => 'C',     'Aug'       => 'K',      'Sep'       => 'E',
      'October'   => 'Q',   'November'  => 'Q@',  'December'  => 'QG',
      'Oct'       => 'Q',     'Nov'       => 'Q@',    'Dec'       => 'QG'

    );


  @foo=($string=~/(\S+),\s+(\S+)\s+(\S+)(.*)/);
  if( $wday{@foo[0]} && $month{@foo[2]} )
    {
	if(@foo[3]=~(/(.*)at(.*)/))
      { 
         @foo[3]=@quux[0];
         @foo[4]=@quux[1];
#        @quux=split(/at/,@foo[3]);
      };
       return "$month{@foo[2]} @foo[1] @foo[4], $wday{@foo[0]}, @foo[3]";
#      return "$wday{@foo[0]} den @foo[1]. $month{@foo[2]} @foo[3]"; 
    };

#
# handle two different time/date formats:  
# return "$wday, $mday $month ".($year+1900)." at $hour:$min";
# return "$wday, $mday $month ".($year+1900)." $hour:$min:$sec GMT";
#

# handle nontranslated strings which ought to be translated
# print STDERR "$_\n" or print DEBUG "not translated $_";
# but then again we might not want/need to translate all strings
  
  return $string;

};
# Brazilian (Portugues)

sub brazilian
{
  my($string)=pop(@_);
  my(%translations,%month,%wday);

  my($i,$j);
  my(@dollar,@quux,@foo);

  
  # regexp => replacement string NOTE does not use autovars $1,$2...
  # charset=iso-2022-jp

  %translations =
  (  
     #'charset=iso-8859-1'                     => 'charset=iso-8859-1',
     'Maximal 5 Minute Incoming Traffic'      => 'Tr&aacute;fego M&aacute;ximo de Entrada em 5 minutos',
     'Maximal 5 Minute Outgoing Traffic'      => 'Tr&aacute;fego M&aacute;ximo de Sa&iacute;da em 5 minutos',
     'the device'                             => 'dispositivo',
     'The statistics were last updated (.*)'  => '&Uacute;ltima atualiza&ccedil;&atilde;o das estat&iacute;sticas: $1',
     ' Average\)</B><BR>'                     => ' - m&eacute;dia)</B><BR>',
     '<TD ALIGN=right><SMALL>Average(.*)'     => '<TD ALIGN=right><SMALL>M&eacute;dia$1',
     '<TD ALIGN=right><SMALL>Max(.*)'         => '<TD ALIGN=right><SMALL>M&aacute;x$1',
     '<TD ALIGN=right><SMALL>Current(.*)'     => '<TD ALIGN=right><SMALL>Atual$1',
     'version'                                => 'vers&atilde;o',
     '<B>`Daily\' Graph \((.*) Minute'        => '<B>Gr&aacute;fico `Di&aacute;rio\' ($1 minutos',
     '<B>`Weekly\' Graph \(30 Minute'         => '<B>Gr&aacute;fico `Semanal\' (30 minutos' ,
     '<B>`Monthly\' Graph \(2 Hour'           => '<B>Gr&aacute;fico `Mensal\' (2 horas',
     '<B>`Yearly\' Graph \(1 Day'             => '<B>Gr&aacute;fico `Anual\' (1 dia', 
     'Incoming Traffic in (\S+) per Second'   => 'Tr&aacute;fego de Entrada em $1 por segundo',
     'Outgoing Traffic in (\S+) per Second'   => 'Tr&aacute;fego de Sa&iacute;da em $1 por segundo',
     'at which time (.*) had been up for(.*)' => 'nesta hora $1 estava online por $2',
     # '([kMG]?)([bB])/s'                     => '\$1\$2/s',
     # '([kMG]?)([bB])/min'                   => '\$1\$2/min',
     # '([kMG]?)([bB])/h'                     => '$1$2/t',
     # 'Bits'                                 => 'Bits',
     # 'Bytes'                                => 'Bytes'
     '&nbsp;In:</FONT>'                       => '&nbsp;Ent:</FONT>',
     '&nbsp;Out:</FONT>'                      => '&nbsp;Sa&iacute;:</FONT>',
     '&nbsp;Percentage</FONT>'                => '&nbsp;Per:</FONT>',
     'Ported to OpenVMS Alpha by'             => 'Adaptado para OpenVMS Alpha por', 
     'Ported to WindowsNT by'                 => 'Adaptado para WindowsNT por',
     'and'                                    => 'e',
     '^GREEN'                                  => 'VERDE',
     'BLUE'                                   => 'AZUL',
     'DARK GREEN'                             => 'VERDE ESCURO',
     'MAGENTA'                                => 'LIL&Aacute;S',
     'AMBER'                                  => 'AMBAR'
  );

# maybe expansions with replacement of whitespace would be more appropriate
foreach $i (keys %translations)
{
  if($string=~/$i/)
  { 
    (@dollar)=($string=~/()$i/); # I hope this prevents the autovars
    $string=$translations{$i};  # And it only works from $1-$9
    for($j=1;@dollar[$j];$j++)   # s/// doesn't do any good with saved "$1"-exprs.
    {
      @quux=();
      (@quux)=split(/\$$j/,$string);
      $string=@quux[0].@dollar[$j].@quux[1];
    } ; 
    return $string;
  };
};

%wday = 
    (
      'Sunday'    => 'Domingo',       'Sun' => 'Dom',
      'Monday'    => 'Segunda',       'Mon' => 'Seg',
      'Tuesday'   => 'Ter&ccedil;a',  'Tue' => 'Ter',
      'Wednesday' => 'Quarta',        'Wed' => 'Qua',
      'Thursday'  => 'Quinta',        'Thu' => 'Qui',
      'Friday'    => 'Sexta',         'Fri' => 'Sex',
      'Saturday'  => 'S&aacute;bado', 'Sat' => 'S&aacute;b' 

    );

%month = 
    (
      'January'   => 'Janeiro',   'February'  => 'Fevereiro' ,  'March'     => 'Mar&ccedil;o',
      'Jan'       => 'Jan',       'Feb'       => 'Fev',         'Mar'       => 'Mar',
      'April'     => 'Abril',     'May'       => 'Maio',        'June'      => 'Junho', 
      'Apr'       => 'Abr',       'May'       => 'Mai',         'Jun'       => 'Jun',
      'July'      => 'Julho',     'August'    => 'Agosto',      'September' => 'Setembro', 
      'Jul'       => 'Jul',       'Aug'       => 'Ago',         'Sep'       => 'Set', 
      'October'   => 'Outubro',   'November'  => 'Novembro',    'December'  => 'Dezembro', 
      'Oct'       => 'Out',       'Nov'       => 'Nov',         'Dec'       => 'Dez' 
    );

  @foo=($string=~/(\S+),\s+(\S+)\s+(\S+)(.*)/);
  if( $wday{@foo[0]} && $month{@foo[2]} )
    {
	if(@foo[3]=~(/(.*)at(.*)/))
      { 
        @quux=split(/at/,@foo[3]);
        @foo[3]=@quux[0]." &agrave;s ".@quux[1]; 
      };
      return "$wday{@foo[0]}, @foo[1] de $month{@foo[2]} de @foo[3]"; 
    };

#
# handle two different time/date formats:  
# return "$wday, $mday $month ".($year+1900)." at $hour:$min";
# return "$wday, $mday $month ".($year+1900)." $hour:$min:$sec GMT";
#

# handle nontranslated strings which ought to be translated
# print STDERR "$_\n" or print DEBUG "not translated $_";
# but then again we might not want/need to translate all strings
  
  return $string;

};
# Czech

sub czech
{
  my($string)=pop(@_);
  my(%translations,%month,%wday);

  my($i,$j);
  my(@dollar,@quux,@foo);

  
  # regexp => replacement string NOTE does not use autovars $1,$2...
  # charset=iso-2022-jp

  %translations =
  (  
     'charset=iso-8859-1'                     => 'charset=windows-1250',
     'Maximal 5 Minute Incoming Traffic'      => 'Maximln 5 minutov pchoz tok',
     'Maximal 5 Minute Outgoing Traffic'      => 'Maximln 5 minutov odchoz tok',
     'the device'                             => 'zazen',
     'The statistics were last updated(.*)'   => 'Posledn aktualizace statistiky:$1',
     ' Average\)</B><BR>'                     => ' prmr)</B><BR>',
     '<TD ALIGN=right><SMALL>Average(.*)'     => '<TD ALIGN=right><SMALL>Prm.$1',
     '<TD ALIGN=right><SMALL>Max(.*)'         => '<TD ALIGN=right><SMALL>Max.$1',
     '<TD ALIGN=right><SMALL>Current(.*)'     => '<TD ALIGN=right><SMALL>Akt.$1',
     'version'                                => 'verze',
     '<B>`Daily\' Graph \((.*) Minute'        => '<B>Denn graf ($1 minutov',
     '<B>`Weekly\' Graph \(30 Minute'         => '<B>Tdenn graf (30 minutov' ,
     '<B>`Monthly\' Graph \(2 Hour'           => '<B>Msn graf (2 hodinov',
     '<B>`Yearly\' Graph \(1 Day'             => '<B>Ron graf (1 denn', 
     'Incoming Traffic in (\S+) per Second'   => 'Pchoz tok v $1 za sec.',
     'Outgoing Traffic in (\S+) per Second'   => 'Odchoz tok v $1 za sec.',
     'at which time (.*) had been up for(.*)' => 'od poslednho restartu $1 ubhlo: $2',
     #'([kMG]?)([bB])/s'                       => '\$1\$2/s',
     #'([kMG]?)([bB])/min'     	      	      => '\$1\$2/min',
     #'([kMG]?)([bB])/h'                       => '$1$2/h',
     'Bits'                                   => 'bitech',
     'Bytes'                                  => 'bajtech',
     #'&nbsp;In:</FONT>'                       => '&nbsp;In:</FONT>',
     #'&nbsp;Out:</FONT>'                      => '&nbsp;Out:</FONT>',
     '&nbsp;Percentage</FONT>'                => '&nbsp;Proc.</FONT>',
     'Ported to OpenVMS Alpha by'             => 'Na OpenVMS portoval', 
     'Ported to WindowsNT by'                 => 'Na WindowsNT portoval',
     'and'                                    => 'a',
     '^GREEN'                                  => 'Zelen',
     'BLUE'                                   => 'Modr',
     'DARK GREEN'                             => 'Tmav zelen',
     'MAGENTA'                                => 'Fialov',
     'AMBER'                                  => 'lut'
  );

# maybe expansions with replacement of whitespace would be more appropriate
foreach $i (keys %translations)
{
  if($string=~/$i/)
  { 
    (@dollar)=($string=~/()$i/); # I hope this prevents the autovars
    $string=$translations{$i};   # And it only works from $1-$9
    for($j=1;@dollar[$j];$j++)   # s/// doesn't do any good with saved "$1"-exprs.
    {
      @quux=();
      (@quux)=split(/\$$j/,$string);
      $string=@quux[0].@dollar[$j].@quux[1];
    } ; 
    return $string;
  };
};

%wday = 
    (
      'Sunday'    => 'Nedle',		'Sun' => 'Ne',
      'Monday'    => 'Pondli',		'Mon' => 'Po',
      'Tuesday'   => 'ter',		'Tue' => 't',
      'Wednesday' => 'Steda',		'Wed' => 'St',
      'Thursday'  => 'tvrtek',		'Thu' => 't',
      'Friday'    => 'Ptek',		'Fri' => 'P',
      'Saturday'  => 'Sobota',		'Sat' => 'So' 
    );

%month = 
    (
 'January' => 'Leden',   'February' => 'nor',      'March'     => 'Bezen',
 'Jan'     => 'Leden',   'Feb'      => 'nor',      'Mar'       => 'Bezen',
 'April'   => 'Duben',   'May'      => 'Kvten',    'June'      => 'erven',
 'Apr'     => 'Duben',   'May'      => 'Kvten',    'Jun'       => 'erven',
 'July'    => 'ervenec','August'   => 'Srpen',     'September' => 'Z',
 'Jul'     => 'ervenec','Aug'      => 'Srpen',     'Sep'       => 'Z', 
 'October' => 'jen',   'November' => 'Listopad',  'December'  => 'Prosinec', 
 'Oct'     => 'jen',   'Nov'      => 'Listopad',  'Dec'       => 'Prosinec' 
    );

  @foo=($string=~/(\S+),\s+(\S+)\s+(\S+)(.*)/);
  if( $wday{@foo[0]} && $month{@foo[2]} )
    {
	if(@foo[3]=~(/(.*)at(.*)/))
      { 
        @quux=split(/at/,@foo[3]);
        @foo[3]=@quux[0].",".@quux[1]." hod."; 
      };
      return "$wday{@foo[0]} @foo[1]. $month{@foo[2]} @foo[3]"; 
    };

#
# handle two different time/date formats:  
# return "$wday, $mday $month ".($year+1900)." at $hour:$min";
# return "$wday, $mday $month ".($year+1900)." $hour:$min:$sec GMT";
#

# handle nontranslated strings which ought to be translated
# print STDERR "$_\n" or print DEBUG "not translated $_";
# but then again we might not want/need to translate all strings

  return $string;

}
#
# Danish

sub danish
{
  my($string)=pop(@_);
  my(%translations,%month,%wday);

  my($i,$j);
  my(@dollar,@quux,@foo);

  
  # regexp => replacement string NOTE does not use autovars $1,$2...
  # charset=iso-2022-jp

  %translations =
  (  
     #'charset=iso-8859-1'                     => 'charset=iso-8859-1',
     'Maximal 5 Minute Incoming Traffic'      => 'Maksimal indg&aring;ende trafik i 5 minutter',
     'Maximal 5 Minute Outgoing Traffic'      => 'Maksimal udg&aring;ende trafik i 5 minutter',
     'the device'                             => 'enheden',
     'The statistics were last updated(.*)'   => 'Statistikken blev sidst opdateret$1',
     ' Average\)</B><BR>'                     => ' Middel)</B><BR>',
     '<TD ALIGN=right><SMALL>Average(.*)'     => '<TD ALIGN=right><SMALL>Middel$1',
     '<TD ALIGN=right><SMALL>Max(.*)'         => '<TD ALIGN=right><SMALL>Max$1',
     '<TD ALIGN=right><SMALL>Current(.*)'     => '<TD ALIGN=right><SMALL>Nu$1',
     'version'                                => 'version',
     '<B>`Daily\' Graph \((.*) Minute'        => '<B>`Daglig\' graf ($1 minuts',
     '<B>`Weekly\' Graph \(30 Minute'         => '<B>`Ugentlig\' graf (30 minuts' ,
     '<B>`Monthly\' Graph \(2 Hour'           => '<B>`M&aring;nedlig\' graf (2 times',
     '<B>`Yearly\' Graph \(1 Day'             => '<B>`&Aring;rlig\' graf (1 dags', 
     'Incoming Traffic in (\S+) per Second'   => 'Indg&aring;ende trafik i $1 per sekund',
     'Outgoing Traffic in (\S+) per Second'   => 'Udg&aring;ende trafik i $1 per sekund',
     'at which time (.*) had been up for(.*)' => 'hvor $1 havde v&aelig;ret oppe i$2',
     # '([kMG]?)([bB])/s'                 => '\$1\$2/s',
     # '([kMG]?)([bB])/min'              => '\$1\$2/min',
     '([kMG]?)([bB])/h'                       => '$1$2/t',
     # 'Bits'                                => 'Bits',
     # 'Bytes'                              => 'Bytes'
     '&nbsp;In:</FONT>'                      => '&nbsp;Ind:</FONT>',
     '&nbsp;Out:</FONT>'                     => '&nbsp;Ud:</FONT>',
     '&nbsp;Percentage</FONT>'               => '&nbsp;Procent:</FONT>',
     'Ported to OpenVMS Alpha by'             => 'Port til OpenVMS af', 
     'Ported to WindowsNT by'                 => 'Port til WindowsNT af',
     'and'                                    => 'og',
     '^GREEN'                                  => 'GR&Oslash;N',
     'BLUE'                                   => 'BL&Aring;',
     'DARK GREEN'                             => 'M\Oslash;RKEGR&Oslash;N',
     'MAGENTA'                                => 'LYSLILLA',
     'AMBER'                                  => 'RAV'
  );

# maybe expansions with replacement of whitespace would be more appropriate
foreach $i (keys %translations)
{
  if($string=~/$i/)
  { 
    (@dollar)=($string=~/()$i/); # I hope this prevents the autovars
    $string=$translations{$i};  # And it only works from $1-$9
    for($j=1;@dollar[$j];$j++)   # s/// doesn't do any good with saved "$1"-exprs.
    {
      @quux=();
      (@quux)=split(/\$$j/,$string);
      $string=@quux[0].@dollar[$j].@quux[1];
    } ; 
    return $string;
  };
};

%wday = 
    (
      'Sunday'    => 'S&oslash;ndag',    'Sun' => 'S&oslash;n',
      'Monday'    => 'Mandag',           'Mon' => 'Man',
      'Tuesday'   => 'Tirsdag',          'Tue' => 'Tir',
      'Wednesday' => 'Onsdag',           'Wed' => 'Ons',
      'Thursday'  => 'Torsdag',          'Thu' => 'Tor',
      'Friday'    => 'Fredag',           'Fri' => 'Fre',
      'Saturday'  => 'L&oslash;rdag',    'Sat' => 'L&oslash;r' 

    );

%month = 
    (
      'January'   => 'Januar',    'February'  => 'Februar' ,    'March'     => 'Marts',
      'Jan'       => 'Jan',       'Feb'       => 'Feb',         'Mar'       => 'Mar',
      'April'     => 'April',     'May'       => 'Maj',         'June'      => 'Juni', 
      'Apr'       => 'Apr',       'May'       => 'Maj',         'Jun'       => 'Jun',
      'July'      => 'Juli',      'August'    => 'August',      'September' => 'September', 
      'Jul'       => 'Jul',       'Aug'       => 'Aug',         'Sep'       => 'Sep', 
      'October'   => 'Oktober',   'November'  => 'November',    'December'  => 'December', 
      'Oct'       => 'Okt',       'Nov'       => 'Nov',         'Dec'       => 'Dec' 
    );

  @foo=($string=~/(\S+),\s+(\S+)\s+(\S+)(.*)/);
  if( $wday{@foo[0]} && $month{@foo[2]} )
    {
	if(@foo[3]=~(/(.*)at(.*)/))
      { 
        @quux=split(/at/,@foo[3]);
        @foo[3]=@quux[0]." kl.".@quux[1]; 
      };
      return "$wday{@foo[0]} den @foo[1]. $month{@foo[2]} @foo[3]"; 
    };

#
# handle two different time/date formats:  
# return "$wday, $mday $month ".($year+1900)." at $hour:$min";
# return "$wday, $mday $month ".($year+1900)." $hour:$min:$sec GMT";
#

# handle nontranslated strings which ought to be translated
# print STDERR "$_\n" or print DEBUG "not translated $_";
# but then again we might not want/need to translate all strings
  
  return $string;

  };

# Dutch

sub dutch
{
  my($string)=pop(@_);
  my(%translations,%month,%wday);

  my($i,$j);
  my(@dollar,@quux,@foo);

  
  # regexp => replacement string NOTE does not use autovars $1,$2...

  %translations =
  (  
     #'charset=iso-8859-1'                     => 'charset=iso-8859-1',
     'Maximal 5 Minute Incoming Traffic'      => 'Maximaal inkomend verkeer per 5 minuten',
     'Maximal 5 Minute Outgoing Traffic'      => 'Maximaal uitgaand verkeer per 5 minuten',
     'the device'                             => 'het apparaat',
     'The statistics were last updated(.*)'   => 'Statistieken voor het laatst bijgewerkt op$1',
     ' Average\)</B><BR>'                     => ' gemiddeld)</B><BR>',
     '<TD ALIGN=right><SMALL>Average(.*)'     => '<TD ALIGN=right><SMALL>Gemiddeld$1',
     '<TD ALIGN=right><SMALL>Max(.*)'         => '<TD ALIGN=right><SMALL>Max$1',
     '<TD ALIGN=right><SMALL>Current(.*)'     => '<TD ALIGN=right><SMALL>Actueel$1',
     'version'                                => 'versie',
     '<B>`Daily\' Graph \((.*) Minute'        => '<B>`Dagelijkse\' grafiek ($1 minuten',
     '<B>`Weekly\' Graph \(30 Minute'         => '<B>`Weekelijkse\' grafiek (30 minuten' ,
     '<B>`Monthly\' Graph \(2 Hour'           => '<B>`Maandelijkse\' grafiek (2 uur',
     '<B>`Yearly\' Graph \(1 Day'             => '<B>`Jaarlijkse\' grafiek (1 dag', 
     'Incoming Traffic in (\S+) per Second'   => 'Inkomend verkeer in $1 per seconde',
     'Outgoing Traffic in (\S+) per Second'   => 'Uitgaand verkeer in $1 per seconde',
     'at which time (.*) had been up for(.*)' => 'op het moment dat $1 reeds actief is voor$2',
     # '([kMG]?)([bB])/s'                 => '\$1\$2/s',
     # '([kMG]?)([bB])/min'              => '\$1\$2/min',
     '([kMG]?)([bB])/h'                       => '$1$2/u',
     # 'Bits'                                => 'Bits',
     # 'Bytes'                              => 'Bytes'
     # '&nbsp;In:</FONT>'                      => '&nbsp;In:</FONT>',
     '&nbsp;Out:</FONT>'                     => '&nbsp;Uit:</FONT>',
     '&nbsp;Percentage</FONT>'               => '&nbsp;Procent:</FONT>',
     'Ported to OpenVMS Alpha by'             => 'Ported naar OpenVMS door', 
     'Ported to WindowsNT by'                 => 'Ported naar WindowsNT door',
     'and'                                    => 'en',
     'DARK GREEN'                             => 'DONKER GROEN',
     '^GREEN'                                  => 'GROEN',
     'BLUE'                                   => 'BLAUW',
     'MAGENTA'                                => 'LILA',
     'AMBER'                                  => 'AMBER'
  );

# maybe expansions with replacement of whitespace would be more appropriate
foreach $i (keys %translations)
{
  if($string=~/$i/)
  { 
    (@dollar)=($string=~/()$i/); # I hope this prevents the autovars
    $string=$translations{$i};  # And it only works from $1-$9
    for($j=1;@dollar[$j];$j++)   # s/// doesn't do any good with saved "$1"-exprs.
    {
      @quux=();
      (@quux)=split(/\$$j/,$string);
      $string=@quux[0].@dollar[$j].@quux[1];
    } ; 
    return $string;
  };
};

%wday = 
    (
      'Sunday'    => 'Zondag',           'Sun' => 'Zon',
      'Monday'    => 'Maandag',          'Mon' => 'Maa',
      'Tuesday'   => 'Dinsdag',          'Tue' => 'Din',
      'Wednesday' => 'Woensdag',         'Wed' => 'Woe',
      'Thursday'  => 'Donderdag',        'Thu' => 'Don',
      'Friday'    => 'Vrijdag',          'Fri' => 'Vri',
      'Saturday'  => 'Zaterdag',         'Sat' => 'Zat' 

    );

%month = 
    (
      'January'   => 'Januari',   'February'  => 'Februari',    'March'     => 'Maart',
      'Jan'       => 'Jan',       'Feb'       => 'Feb',         'Mar'       => 'Mrt',
      'April'     => 'April',     'May'       => 'Mei',         'June'      => 'Juni', 
      'Apr'       => 'Apr',       'May'       => 'Mai',         'Jun'       => 'Jun',
      'July'      => 'Juli',      'August'    => 'Augustus',    'September' => 'September', 
      'Jul'       => 'Jul',       'Aug'       => 'Aug',         'Sep'       => 'Sep', 
      'October'   => 'Oktober',   'November'  => 'November',    'December'  => 'December', 
      'Oct'       => 'Okt',       'Nov'       => 'Nov',         'Dec'       => 'Dec' 
    );

  @foo=($string=~/(\S+),\s+(\S+)\s+(\S+)(.*)/);
  if( $wday{@foo[0]} && $month{@foo[2]} )
    {
        if(@foo[3]=~(/(.*)at(.*)/))
      { 
        @quux=split(/at/,@foo[3]);
        @foo[3]=@quux[0]." om".@quux[1]; 
      };
      return "$wday{@foo[0]} @foo[1] $month{@foo[2]} @foo[3]"; 
    };

#
# handle two different time/date formats:  
# return "$wday, $mday $month ".($year+1900)." at $hour:$min";
# return "$wday, $mday $month ".($year+1900)." $hour:$min:$sec GMT";
#

# handle nontranslated strings which ought to be translated
# print STDERR "$_\n" or print DEBUG "not translated $_";
# but then again we might not want/need to translate all strings
  
  return $string;

};
# French

sub french
{
  my($string)=pop(@_);
  my(%translations,%month,%wday);

  my($i,$j);
  my(@dollar,@quux,@foo);

  
  # regexp => replacement string NOTE does not use autovars $1,$2...
  # charset=iso-2022-jp

  %translations =
  (  
     #'charset=iso-8859-1'                     => 'charset=iso-8859-1',
     'Maximal 5 Minute Incoming Traffic'      => 'Trafic maximal en entr&eacute;e sur 5 minutes',
     'Maximal 5 Minute Outgoing Traffic'      => 'Trafic maximal en sortie sur 5 minutes',
     'the device'                             => 'le mat&eacute;riel',
     'The statistics were last updated(.*)'   => 'Les statistiques ont &eacute;t&eacute; mises &agrave; jour le $1',
     ' Average\)</B><BR>'                     => ' Moyenne)</B><BR>',
     '<TD ALIGN=right><SMALL>Average(.*)'     => '<TD ALIGN=right><SMALL>Moyenne$1',
     '<TD ALIGN=right><SMALL>Max(.*)'         => '<TD ALIGN=right><SMALL>Max$1',
     '<TD ALIGN=right><SMALL>Current(.*)'     => '<TD ALIGN=right><SMALL>Actuel$1',
     'version'                                => 'version',
     '<B>`Daily\' Graph \((.*) Minute'        => '<B>Graphique quotidien (sur $1 minutes :',
     '<B>`Weekly\' Graph \(30 Minute'         => '<B>Graphique hebdomadaire (sur 30 minutes :' ,
     '<B>`Monthly\' Graph \(2 Hour'           => '<B>Graphique mensuel  (sur 2 heures :',
     '<B>`Yearly\' Graph \(1 Day'             => '<B>Graphique annuel (sur 1 jour :', 
     'Incoming Traffic in (\S+) per Second'   => 'Trafic d\'entr&eacute;e en $1 par seconde',
     'Outgoing Traffic in (\S+) per Second'   => 'Trafic de sortie en $1 par seconde',
     'at which time (.*) had been up for(.*)' => '$1 &eacute;tait alors en marche depuis $2',
     # '([kMG]?)([bB])/s'                      => '\$1\$2/s',
     # '([kMG]?)([bB])/min'                    => '\$1\$2/min',
     '([kMG]?)([bB])/h'                       => '$1$2/t',
     # 'Bits'                                  => 'Bits',
     # 'Bytes'                                 => 'Bytes'
     '&nbsp;In:</FONT>'                       => '&nbsp;Entr&eacute;e:</FONT>',
     '&nbsp;Out:</FONT>'                      => '&nbsp;Sortie:</FONT>',
     '&nbsp;Percentage</FONT>'                => '&nbsp;Pourcentage:</FONT>',
     'Ported to OpenVMS Alpha by'             => 'Port&eacute; sur OpenVMS Alpha par',
     'Ported to WindowsNT by'                 => 'Port&eacute; sur WindowsNT par',
     'and'                                    => 'et',
     '^GREEN'                                  => 'VERT',
     'BLUE'                                   => 'BLEU',
     'DARK GREEN'                             => 'VERT SOMBRE',
     'MAGENTA'                                => 'MAGENTA',
     'AMBER'                                  => 'AMBRE'
  );

# maybe expansions with replacement of whitespace would be more appropriate
foreach $i (keys %translations)
{
  if($string=~/$i/)
  { 
    (@dollar)=($string=~/()$i/); # I hope this prevents the autovars
    $string=$translations{$i};  # And it only works from $1-$9
    for($j=1;@dollar[$j];$j++)   # s/// doesn't do any good with saved "$1"-exprs.
    {
      @quux=();
      (@quux)=split(/\$$j/,$string);
      $string=@quux[0].@dollar[$j].@quux[1];
    } ; 
    return $string;
  };
};

%wday = 
    (
      'Sunday'    => 'Dimanche',	'Sun' => 'Dim',
      'Monday'    => 'Lundi',		'Mon' => 'Lun',
      'Tuesday'   => 'Mardi',		'Tue' => 'Mar',
      'Wednesday' => 'Mercredi',	'Wed' => 'Mer',
      'Thursday'  => 'Jeudi',		'Thu' => 'Jeu',
      'Friday'    => 'Vendredi',	'Fri' => 'Ven',
      'Saturday'  => 'Samedi',		'Sat' => 'Sam' 
    );

%month = 
    (
      'January'   => 'Janvier',   'February'  => 'F&eacute;vrier' ,    'March'     => 'Mars',
      'Jan'       => 'Jan',       'Feb'       => 'Fev',         'Mar'       => 'Mar',
      'April'     => 'Avril',     'May'       => 'Mai',         'June'      => 'Juin', 
      'Apr'       => 'Avr',       'May'       => 'Mai',         'Jun'       => 'Jun',
      'July'      => 'Juillet',   'August'    => 'Ao&ucirc;t',        'September' => 'Septembre', 
      'Jul'       => 'Jul',       'Aug'       => 'Aou',         'Sep'       => 'Sep', 
      'October'   => 'Octobre',   'November'  => 'Novembre',    'December'  => 'D&eacute;cembre', 
      'Oct'       => 'Oct',       'Nov'       => 'Nov',         'Dec'       => 'Dec' 
    );

  @foo=($string=~/(\S+),\s+(\S+)\s+(\S+)(.*)/);
  if( $wday{@foo[0]} && $month{@foo[2]} )
    {
	if(@foo[3]=~(/(.*)at(.*)/))
      { 
        @quux=split(/at/,@foo[3]);
        @foo[3]=@quux[0]." &agrave; ".@quux[1]; 
      };
      return "$wday{@foo[0]} @foo[1] $month{@foo[2]} @foo[3]"; 
    };

#
# handle two different time/date formats:  
# return "$wday, $mday $month ".($year+1900)." &agrave; $hour:$min";
# return "$wday, $mday $month ".($year+1900)." $hour:$min:$sec GMT";
#

# handle nontranslated strings which ought to be translated
# print STDERR "$_\n" or print DEBUG "not translated $_";
# but then again we might not want/need to translate all strings
  
  return $string;

};


# German

sub german
{
  my($string)=pop(@_);
  my(%translations,%month,%wday);

  my($i,$j);
  my(@dollar,@quux,@foo);

  
  # regexp => replacement string NOTE does not use autovars $1,$2...
  # charset=iso-2022-jp

  %translations =
  (  
     #'charset=iso-8859-1'                     => 'charset=iso-8859-1',
     'Maximal 5 Minute Incoming Traffic'      => 'Maximaler reinkommender Traffic in 5 Minuten',
     'Maximal 5 Minute Outgoing Traffic'      => 'Maximaler rausgehender Traffic in 5 Minuten',
     'the device'                             => 'das Gert',
     'The statistics were last updated(.*)'   => 'Die Statistiken wurden am $1 zuletzt aktualisiert',
     ' Average\)</B><BR>'                     => '',
     '<TD ALIGN=right><SMALL>Average(.*)'     => '<TD ALIGN=right><SMALL>Mittel$1',
     '<TD ALIGN=right><SMALL>Max(.*)'         => '<TD ALIGN=right><SMALL>Maximal$1',
     '<TD ALIGN=right><SMALL>Current(.*)'     => '<TD ALIGN=right><SMALL>Aktuell$1',
     'version'                                => 'Version',
     '<B>`Daily\' Graph \((.*) Minute'        => '<B>Tages&uuml;bersicht (Skalierung $1 Minute(n))</B><BR>',
     '<B>`Weekly\' Graph \(30 Minute'         => '<B>Wochen&uuml;bersicht (Skalierung 30 Minuten)</B><BR>' ,
     '<B>`Monthly\' Graph \(2 Hour'           => '<B>Monats&uuml;bersicht (Skalierung 2 Stunden)</B><BR>',
     '<B>`Yearly\' Graph \(1 Day'             => '<B>Jahres&uuml;bersicht (Skalierung 1 Tag)</B><BR>', 
     'Incoming Traffic in (\S+) per Second'   => 'Reinkommender Traffic in $1 pro Sekunde',
     'Outgoing Traffic in (\S+) per Second'   => 'Rausgehender Traffic in $1 pro Sekunde',
     'at which time (.*) had been up for(.*)' => 'zu diesem Zeitpunkt lief $1 seit $2',
     '(.+)/s$'                                 => '$1/s',
     # '(.+)/min'                     => '$1/min',
     '(.+)/h$'                       => '$1/std',
     #'([kMG]?)([bB])/s'                       => '$1$2/s',
     #'([kMG]?)([bB])/min'                     => '$1$2/min',
     #'([kMG]?)([bB])/h'                       => '$1$2/std',
     # 'Bits'                                => 'Bits',
     # 'Bytes'                               => 'Bytes'
     '&nbsp;In:</FONT>'                       => '&nbsp;Rein:</FONT>',
     '&nbsp;Out:</FONT>'                      => '&nbsp;Raus:</FONT>',
     '&nbsp;Percentage</FONT>'                => '&nbsp;Prozent:</FONT>',
     'Ported to OpenVMS Alpha by'             => 'Portierung nach OpenVMS von', 
     'Ported to WindowsNT by'                 => 'Portierung nach WindowsNT von',
     'and'                                    => 'und',
     '^GREEN'                                 => 'GR&Uuml;N',
     'BLUE'                                   => 'BLAU',
     'DARK GREEN'                             => 'DUNKELGR&Uuml;N',
     # 'MAGENTA'                                => 'ROSA',
     # 'AMBER'                               => 'AMBER',
  );

# maybe expansions with replacement of whitespace would be more appropriate
foreach $i (keys %translations)
{
  if($string=~/$i/)
  { 
    (@dollar)=($string=~/()$i/); # I hope this prevents the autovars
    $string=$translations{$i};  # And it only works from $1-$9
    for($j=1;@dollar[$j];$j++)   # s/// doesn't do any good with saved "$1"-exprs.
    {
      @quux=();
      (@quux)=split(/\$$j/,$string);
      $string=@quux[0].@dollar[$j].@quux[1];
    } ; 
    return $string;
  };
};

%wday = 
    (
      'Sunday'    => 'Sonntag',     'Sun' => 'So',
      'Monday'    => 'Montag',      'Mon' => 'Mo',
      'Tuesday'   => 'Dienstag',    'Tue' => 'Di',
      'Wednesday' => 'Mittwoch',    'Wed' => 'Mi',
      'Thursday'  => 'Donnerstag',  'Thu' => 'Do',
      'Friday'    => 'Freitag',     'Fri' => 'Fr',
      'Saturday'  => 'Samstag',     'Sat' => 'Sa' 
    );

%month = 
    (
      'January'   => 'Januar',    'February'  => 'Februar' ,    'March'     => 'M&auml;z',
      'Jan'       => 'Jan',       'Feb'       => 'Feb',         'Mar'       => 'M&auml;r',
      'April'     => 'April',     'May'       => 'Mai',         'June'      => 'Juni', 
      'Apr'       => 'Apr',       'May'       => 'Mai',         'Jun'       => 'Jun',
      'July'      => 'Juli',      'August'    => 'August',      'September' => 'September', 
      'Jul'       => 'Jul',       'Aug'       => 'Aug',         'Sep'       => 'Sep', 
      'October'   => 'Oktober',   'November'  => 'November',    'December'  => 'Dezember', 
      'Oct'       => 'Okt',       'Nov'       => 'Nov',         'Dec'       => 'Dez' 
    );

  @foo=($string=~/(\S+),\s+(\S+)\s+(\S+)(.*)/);
  if( $wday{@foo[0]} && $month{@foo[2]} )
    {
	if(@foo[3]=~(/(.*)at(.*)/))
      { 
        @quux=split(/at/,@foo[3]);
        @foo[3]=@quux[0]." um ".@quux[1]; 
      };
      return "$wday{@foo[0]}, den @foo[1]. $month{@foo[2]} @foo[3]"; 
    };

#
# handle two different time/date formats:  
# return "$wday, $mday $month ".($year+1900)." at $hour:$min";
# return "$wday, $mday $month ".($year+1900)." $hour:$min:$sec GMT";
#

# handle nontranslated strings which ought to be translated
# print STDERR "$_\n" or print DEBUG "not translated $_";
# but then again we might not want/need to translate all strings
  
  return $string;

};



# Greek 

sub greek
{
  my($string)=pop(@_);
  my(%translations,%month,%wday);

  my($i,$j);
  my(@dollar,@quux,@foo);

  
  # regexp => replacement string NOTE does not use autovars $1,$2...
  # charset=iso-2022-jp

  %translations =
  (  
     'charset=iso-8859-1'                     => 'charset=iso-8859-7',
     'Maximal 5 Minute Incoming Traffic'      => '    5 ',
     'Maximal 5 Minute Outgoing Traffic'      => '    5 ',
     'the device'                             => ' ',
     'The statistics were last updated(.*)'   => '      $1',
     ' Average\)</B><BR>'                     => '  )</B><BR>',
     '<TD ALIGN=right><SMALL>Average(.*)'     => '<TD ALIGN=right><SMALL> $1',
     '<TD ALIGN=right><SMALL>Max(.*)'         => '<TD ALIGN=right><SMALL>$1',
     '<TD ALIGN=right><SMALL>Current(.*)'     => '<TD ALIGN=right><SMALL>$1',
     'version'                                => '',
     '<B>`Daily\' Graph \((.*) Minute'        => '<B>  ( $1  :',
     '<B>`Weekly\' Graph \(30 Minute'         => '<B>  ( 30  :' ,
     '<B>`Monthly\' Graph \(2 Hour'           => '<B>   ( 2  :',
     '<B>`Yearly\' Graph \(1 Day'             => '<B>  ( 1  :', 
     'Incoming Traffic in (\S+) per Second'   => '   $1  ',
     'Outgoing Traffic in (\S+) per Second'   => '   $1  ',
     'at which time (.*) had been up for(.*)' => '   $1    $2',
     # '([kMG]?)([bB])/s'                      => '\$1\$2/s',
     # '([kMG]?)([bB])/min'                    => '\$1\$2/min',
     '([kMG]?)([bB])/h'                       => '$1$2/t',
     # 'Bits'                                  => 'Bits',
     # 'Bytes'                                 => 'Bytes'
     '&nbsp;In:</FONT>'                       => '&nbsp;:</FONT>',
     '&nbsp;Out:</FONT>'                      => '&nbsp;:</FONT>',
     '&nbsp;Percentage</FONT>'                => '&nbsp;:</FONT>',
     'Ported to OpenVMS Alpha by'             => '  OpenVMS Alpha ',
     'Ported to WindowsNT by'                 => '  WindowsNT ',
     'and'                                    => '',
     '^GREEN'                                  => '',
     'BLUE'                                   => '',
     'DARK GREEN'                             => ' ',
     'MAGENTA'                                => '',
     'AMBER'                                  => ''
  );

# maybe expansions with replacement of whitespace would be more appropriate
foreach $i (keys %translations)
{
  if($string=~/$i/)
  { 
    (@dollar)=($string=~/()$i/); # I hope this prevents the autovars
    $string=$translations{$i};  # And it only works from $1-$9
    for($j=1;@dollar[$j];$j++)   # s/// doesn't do any good with saved "$1"-exprs.
    {
      @quux=();
      (@quux)=split(/\$$j/,$string);
      $string=@quux[0].@dollar[$j].@quux[1];
    } ; 
    return $string;
  };
};

%wday = 
    (
      'Sunday'    => '',		'Sun' => '',
      'Monday'    => '',		'Mon' => '',
      'Tuesday'   => '',		'Tue' => '',
      'Wednesday' => '',		'Wed' => '',
      'Thursday'  => '',		'Thu' => '',
      'Friday'    => '',	'Fri' => '',
      'Saturday'  => '',		'Sat' => '' 
    );

%month = 
    (
      'January'   => '',   'February'  => '' ,  'March'     => '',
      'Jan'       => '',          'Feb'       => '',           'Mar'       => '',
      'April'     => '',     'May'       => '',         'June'      => '', 
      'Apr'       => '',          'May'       => '',           'Jun'       => '',
      'July'      => '',      'August'    => '',     'September' => '', 
      'Jul'       => '',          'Aug'       => '',           'Sep'       => '', 
      'October'   => '',    'November'  => '',     'December'  => '', 
      'Oct'       => '',          'Nov'       => '',           'Dec'       => '' 
    );

  @foo=($string=~/(\S+),\s+(\S+)\s+(\S+)(.*)/);
  if( $wday{@foo[0]} && $month{@foo[2]} )
    {
	if(@foo[3]=~(/(.*)at(.*)/))
      { 
        @quux=split(/at/,@foo[3]);
        @foo[3]=@quux[0]." &agrave; ".@quux[1]; 
      };
      return "$wday{@foo[0]} @foo[1] $month{@foo[2]} @foo[3]"; 
    };

#
# handle two different time/date formats:  
# return "$wday, $mday $month ".($year+1900)." &agrave; $hour:$min";
# return "$wday, $mday $month ".($year+1900)." $hour:$min:$sec GMT";
#

# handle nontranslated strings which ought to be translated
# print STDERR "$_\n" or print DEBUG "not translated $_";
# but then again we might not want/need to translate all strings
  
  return $string;

};
# Italian

sub italian
{
  my($string)=pop(@_);
  my(%translations,%month,%wday);

  my($i,$j);
  my(@dollar,@quux,@foo);

  
  # regexp => replacement string NOTE does not use autovars $1,$2...
  # charset=iso-2022-jp

  %translations =
  (  
     #'charset=iso-8859-1'                    => 'charset=iso-8859-1',
     'Maximal 5 Minute Incoming Traffic'      => 'Traffico massimo in entrata su 5 minuti',
     'Maximal 5 Minute Outgoing Traffic'      => 'Traffico massimo in uscita su 5 minuti',
     'the device'                             => 'Il dispositivo',
     'The statistics were last updated(.*)'   => 'Le statistiche l\' ultima volta sono state aggiornate',
     ' Average\)</B><BR>'                     => ' Media)</B><BR>',
     '<TD ALIGN=right><SMALL>Average(.*)'     => '<TD ALIGN=right><SMALL>Media$1',
     '<TD ALIGN=right><SMALL>Max(.*)'         => '<TD ALIGN=right><SMALL>Max$1',
     '<TD ALIGN=right><SMALL>Current(.*)'     => '<TD ALIGN=right><SMALL>Attuale$1',
     'version'                                => 'versione',
     '<B>`Daily\' Graph \((.*) Minute'        => '<B>Grafico giornaliero (su $1 minuti :',
     '<B>`Weekly\' Graph \(30 Minute'         => '<B>Grafico settimanale (su 30 minuti :' ,
     '<B>`Monthly\' Graph \(2 Hour'           => '<B>Grafico mensile  (su 2 ore :',
     '<B>`Yearly\' Graph \(1 Day'             => '<B>Grafico annuale (su 1 giorno :', 
     'Incoming Traffic in (\S+) per Second'   => 'Traffico in ingresso in $1 per secondo',
     'Outgoing Traffic in (\S+) per Second'   => 'Traffico in uscita in $1 per secondo',
     'at which time (.*) had been up for(.*)' => '$1 &eacute attivo da $2',
     # '([kMG]?)([bB])/s'                      => '\$1\$2/s',
     # '([kMG]?)([bB])/min'                    => '\$1\$2/min',
     '([kMG]?)([bB])/h'                       => '$1$2/t',
     # 'Bits'                                  => 'Bits',
     # 'Bytes'                                 => 'Bytes'
     '&nbsp;In:</FONT>'                       => '&nbsp;Ingresso:</FONT>',
     '&nbsp;Out:</FONT>'                      => '&nbsp;Uscita:</FONT>',
     '&nbsp;Percentage</FONT>'                => '&nbsp;Percentuale:</FONT>',
     'Ported to OpenVMS Alpha by'             => 'Ported su OpenVMS Alpha da',
     'Ported to WindowsNT by'                 => 'Ported su WindowsNT da',
     'and'                                    => 'e',
     '^GREEN'                                  => 'VERDE',
     'BLUE'                                   => 'BLU',
     'DARK GREEN'                             => 'VERDE SCURO',
     'MAGENTA'                                => 'MAGENTA',
     'AMBER'                                  => 'AMBRA'
  );

# maybe expansions with replacement of whitespace would be more appropriate
foreach $i (keys %translations)
{
  if($string=~/$i/)
  { 
    (@dollar)=($string=~/()$i/); # I hope this prevents the autovars
    $string=$translations{$i};  # And it only works from $1-$9
    for($j=1;@dollar[$j];$j++)   # s/// doesn't do any good with saved "$1"-exprs.
    {
      @quux=();
      (@quux)=split(/\$$j/,$string);
      $string=@quux[0].@dollar[$j].@quux[1];
    } ; 
    return $string;
  };
};

%wday = 
    (
      'Sunday'    => 'Domenica',	'Sun' => 'Dom',
      'Monday'    => 'Lunedi',		'Mon' => 'Lun',
      'Tuesday'   => 'Martedi',		'Tue' => 'Mar',
      'Wednesday' => 'Mercoledi',	'Wed' => 'Mer',
      'Thursday'  => 'Giovedi',		'Thu' => 'Gio',
      'Friday'    => 'Venerdi',		'Fri' => 'Ven',
      'Saturday'  => 'Sabato',		'Sat' => 'Sab' 
    );

%month = 
    (
      'January'   => 'Gennaio',   'February'  => 'Febbraio' ,   'March'     => 'Marzo',
      'Jan'       => 'Gen',       'Feb'       => 'Feb',         'Mar'       => 'Mar',
      'April'     => 'Aprile',    'May'       => 'Maggio',      'June'      => 'Giugno', 
      'Apr'       => 'Apr',       'May'       => 'Mag',         'Jun'       => 'Giu',
      'July'      => 'Luglio',    'August'    => 'Agosto',      'September' => 'Settembre', 
      'Jul'       => 'Lug',       'Aug'       => 'Ago',         'Sep'       => 'Set', 
      'October'   => 'Ottobre',   'November'  => 'Novembre',    'December'  => 'Dicembre', 
      'Oct'       => 'Ott',       'Nov'       => 'Nov',         'Dec'       => 'Dic' 
    );

  @foo=($string=~/(\S+),\s+(\S+)\s+(\S+)(.*)/);
  if( $wday{@foo[0]} && $month{@foo[2]} )
    {
	if(@foo[3]=~(/(.*)at(.*)/))
      { 
        @quux=split(/at/,@foo[3]);
        @foo[3]=@quux[0]." alle ".@quux[1]; 
      };
      return "$wday{@foo[0]} @foo[1] $month{@foo[2]} @foo[3]"; 
    };

#
# handle two different time/date formats:  
# return "$wday, $mday $month ".($year+1900)." &agrave; $hour:$min";
# return "$wday, $mday $month ".($year+1900)." $hour:$min:$sec GMT";
#

# handle nontranslated strings which ought to be translated
# print STDERR "$_\n" or print DEBUG "not translated $_";
# but then again we might not want/need to translate all strings
  
   return $string;

};


# Korean

sub korean
{
  my($string)=pop(@_);
  my(%translations,%month,%wday);

  my($i,$j);
  my(@dollar,@quux,@foo);

  
  # regexp => replacement string NOTE does not use autovars $1,$2...
  # charset=iso-2022-jp

  %translations =
  (  
    # 'charset=iso-8859-1'                     => 'charset=ks_c_5601-1987',
     'charset=iso-8859-1'                     => '',
     'Maximal 5 Minute Incoming Traffic'      => '5а ִ ',
     'Maximal 5 Minute Outgoing Traffic'      => '5а ִ ۽',
     'the device'                             => 'ġ',
     'The statistics were last updated(.*)'   => '  Ͻ: $1',
     ' Average\)</B><BR>'                     => ' հ )</B><BR>',
     '<TD ALIGN=right><SMALL>Average(.*)'     => '<TD ALIGN=right><SMALL>$1',
     '<TD ALIGN=right><SMALL>Max(.*)'         => '<TD ALIGN=right><SMALL>ִ$1',
     '<TD ALIGN=right><SMALL>Current(.*)'     => '<TD ALIGN=right><SMALL>$1',
     'version'                                => '',
     '<B>`Daily\' Graph \((.*) Minute'        => '<B>ϰ ׷ ($1  ',
     '<B>`Weekly\' Graph \(30 Minute'         => '<B>ְ ׷ (30  ' ,
     '<B>`Monthly\' Graph \(2 Hour'           => '<B> ׷ (2 ð ',
     '<B>`Yearly\' Graph \(1 Day'             => '<B>Ⱓ ׷ (1  ', 
     'Incoming Traffic in (\S+) per Second'   => 'ʴ ŵ $1',
     'Outgoing Traffic in (\S+) per Second'   => 'ʴ ۽ŵ $1',
     'at which time (.*) had been up for(.*)' => '$1  ð: $2',
     # '([kMG]?)([bB])/s'                 => '\$1\$2/s',
     # '([kMG]?)([bB])/min'              => '\$1\$2/min',
     '([kMG]?)([bB])/h'                       => '$1$2/t',
     # 'Bits'                                => 'Bits',
     # 'Bytes'                              => 'Bytes'
     '&nbsp;In:</FONT>'                      => '&nbsp;:</FONT>',
     '&nbsp;Out:</FONT>'                     => '&nbsp;۽:</FONT>',
     '&nbsp;Percentage</FONT>'               => '&nbsp;ۼƮ:</FONT>',
     'Ported to OpenVMS Alpha by'             => 'OpenVMS Alpha ', 
     'Ported to WindowsNT by'                 => 'WindowsNT ',
     'and'                                    => '׸',
     '^GREEN'                                  => '',
     'BLUE'                                   => 'û',
     'DARK GREEN'                             => 'ѳ',
     'MAGENTA'                                => 'ȫ',
     'AMBER'                                  => 'Ȳ'
  );

# maybe expansions with replacement of whitespace would be more appropriate
foreach $i (keys %translations)
{
  if($string=~/$i/)
  { 
    (@dollar)=($string=~/()$i/); # I hope this prevents the autovars
    $string=$translations{$i};  # And it only works from $1-$9
    for($j=1;@dollar[$j];$j++)   # s/// doesn't do any good with saved "$1"-exprs.
    {
      @quux=();
      (@quux)=split(/\$$j/,$string);
      $string=@quux[0].@dollar[$j].@quux[1];
    } ; 
    return $string;
  };
};

%wday = 
    (
      'Sunday'    => 'Ͽ',    'Sun' => '',
      'Monday'    => '',    'Mon' => '',
      'Tuesday'   => 'ȭ',    'Tue' => 'ȭ',
      'Wednesday' => '',    'Wed' => '',
      'Thursday'  => '',    'Thu' => '',
      'Friday'    => 'ݿ',    'Fri' => '',
      'Saturday'  => '',    'Sat' => '' 

    );

%month = 
    (
      'January'   => '1',  'February'  => '2' ,  'March'     => '3',
      'Jan'       => '1',  'Feb'       => '2',   'Mar'       => '3',
      'April'     => '4',  'May'       => '3',   'June'      => '6', 
      'Apr'       => '4',  'May'       => '3',   'Jun'       => '6',
      'July'      => '7',  'August'    => '8',   'September' => '9', 
      'Jul'       => '7',  'Aug'       => '8',   'Sep'       => '9', 
      'October'   => '10', 'November'  => '11',  'December'  => '12', 
      'Oct'       => '10', 'Nov'       => '11',  'Dec'       => '12' 
    );

  @foo=($string=~/(\S+),\s+(\S+)\s+(\S+)(.*)/);
  if( $wday{@foo[0]} && $month{@foo[2]} )
  {
    if(@foo[3]=~(/(.*)at(.*)/))
    { 
      @quux=split(/at/,@foo[3]);
#      @foo[3]=@quux[0]." kl.".@quux[1]; 
      @foo[3]=@quux[0];
      @foo[4]=@quux[1]; 
    };
    return @foo[3]." $month{@foo[2]} @foo[1] $wday{@foo[0]} @foo[4]";
#    return "$wday{@foo[0]} den @foo[1]. $month{@foo[2]} @foo[3]"; 

  };

#
# handle two different time/date formats:  
# return "$wday, $mday $month ".($year+1900)." at $hour:$min";
# return "$wday, $mday $month ".($year+1900)." $hour:$min:$sec GMT";
#

# handle nontranslated strings which ought to be translated
# print STDERR "$_\n" or print DEBUG "not translated $_";
# but then again we might not want/need to translate all strings
  
 return $string;
};

# Malaysian/Indonesian/Malay

sub malay
{
  my($string)=pop(@_);
  my(%translations,%month,%wday);

  my($i,$j);
  my(@dollar,@quux,@foo);

  
  # regexp => replacement string NOTE does not use autovars $1,$2...
  # charset=iso-2022-jp

  %translations =
  (  
     #'charset=iso-8859-1'                     => 'charset=iso-8859-1',
     'Maximal 5 Minute Incoming Traffic'      => 'Maksimum 5 Minit Trafik Masuk',
     'Maximal 5 Minute Outgoing Traffic'      => 'Maksimum 5 Minit Trafik Keluar',
     'the device'                             => 'alatan',
     'The statistics were last updated(.*)'   => 'Statistik ini kali terakhir dikemaskini pada $1',
     ' Average\)</B><BR>'                     => ' secara purata)</B><BR>',
     '<TD ALIGN=right><SMALL>Average(.*)'     => '<TD ALIGN=right><SMALL>Purata $1',
     '<TD ALIGN=right><SMALL>Max(.*)'         => '<TD ALIGN=right><SMALL>Maksimum $1',
     '<TD ALIGN=right><SMALL>Current(.*)'     => '<TD ALIGN=right><SMALL>Kini $1',
     'version'                                => 'versi',
     '<B>`Daily\' Graph \((.*) Minute'        => '<B>Graf `Harian\' ($1 minit :',
     '<B>`Weekly\' Graph \(30 Minute'         => '<B>Graf `Mingguan\' (30 minit :' ,
     '<B>`Monthly\' Graph \(2 Hour'           => '<B>Graf `Bulanan\' (2 jam :',
     '<B>`Yearly\' Graph \(1 Day'             => '<B>Graf `Tahunan\' (1 hari :',
     'Incoming Traffic in (\S+) per Second'   => 'Trafik Masuk $1 per saat',
     'Outgoing Traffic in (\S+) per Second'   => 'Traffic Keluar $1 per saat',
     'at which time (.*) had been up for(.*)' => 'Sehingga waktu $1 ia telah aktif selama $2',
     # '([kMG]?)([bB])/s'                 => '\$1\$2/s',
     # '([kMG]?)([bB])/min'              => '\$1\$2/min',
     '([kMG]?)([bB])/h'                       => '$1$2/j',
     # 'Bits'                                => 'Bits',
     # 'Bytes'                              => 'Bytes'
     '&nbsp;In:</FONT>'                       => '&nbsp;Masuk</FONT>',
     '&nbsp;Out:</FONT>'                      => '&nbsp;Keluar</FONT>',
     '&nbsp;Percentage</FONT>'                => '&nbsp;Peratus:</FONT>',
     'Ported to OpenVMS Alpha by'             => 'Pengubahsuaian ke  OpenVMS Alpha oleh',
     'Ported to WindowsNT by'                 => 'Pengubahsuaian ke WindowsNT oleh',
     'and'                                    => 'dan',
     '^GREEN'                                 => 'HIJAU',
     'BLUE'                                   => 'BIRU',
     'DARK GREEN'                             => 'HIJAU GELAP',
     'MAGENTA'                                => 'MAGENTA',
     'AMBER'                                  => 'AMBAR'
  );

# maybe expansions with replacement of whitespace would be more appropriate
foreach $i (keys %translations)
{
  if($string=~/$i/)
  { 
    (@dollar)=($string=~/()$i/); # I hope this prevents the autovars
    $string=$translations{$i};  # And it only works from $1-$9
    for($j=1;@dollar[$j];$j++)   # s/// doesn't do any good with saved "$1"-exprs.
    {
      @quux=();
      (@quux)=split(/\$$j/,$string);
      $string=@quux[0].@dollar[$j].@quux[1];
    } ; 
    return $string;
  };
};

%wday =
    (
      'Sunday'    => 'Ahad',    'Sun' => 'Aha',
      'Monday'    => 'Isnin',   'Mon' => 'Isn',
      'Tuesday'   => 'Selasa',  'Tue' => 'Sel',
      'Wednesday' => 'Rabu',    'Wed' => 'Rab',
      'Thursday'  => 'Khamis',  'Thu' => 'Kha',
      'Friday'    => 'Jumaat',  'Fri' => 'Jum',
      'Saturday'  => 'Sabtu',   'Sat' => 'Sab'
    );

%month = 
    (
      'January'   => 'Januari',   'February'  => 'Februari' ,   'March'     => 'Mac',
      'Jan'       => 'Jan',       'Feb'       => 'Feb',         'Mar'       => 'Mac',
      'April'     => 'April',     'May'       => 'Mei',         'June'      => 'Jun', 
      'Apr'       => 'Apr',       'May'       => 'Mei',         'Jun'       => 'Jun',
      'July'      => 'Julai',     'August'    => 'Ogos',        'September' => 'September', 
      'Jul'       => 'Jul',       'Aug'       => 'Ogo',         'Sep'       => 'Sep', 
      'October'   => 'Oktober',   'November'  => 'November',    'December'  => 'Disember', 
      'Oct'       => 'Okt',       'Nov'       => 'Nov',         'Dec'       => 'Dis' 
    );

  @foo=($string=~/(\S+),\s+(\S+)\s+(\S+)(.*)/);
  if( $wday{@foo[0]} && $month{@foo[2]} )
    {
	if(@foo[3]=~(/(.*)at(.*)/))
      { 
        @quux=split(/at/,@foo[3]);
        @foo[3]=@quux[0]." pada ".@quux[1]; 
      };
	return "$wday{@foo[0]} @foo[1] $month{@foo[2]} @foo[3]";
    };

#
# handle two different time/date formats:  
# return "$wday, $mday $month ".($year+1900)." at $hour:$min";
# return "$wday, $mday $month ".($year+1900)." $hour:$min:$sec GMT";
#

# handle nontranslated strings which ought to be translated
# print STDERR "$_\n" or print DEBUG "not translated $_";
# but then again we might not want/need to translate all strings
  
  return $string;

};

sub polish
{
  my($string)=pop(@_);
  my(%translations,%month,%wday);

  my($i,$j);
  my(@dollar,@quux,@foo);


  # regexp => replacement string NOTE does not use autovars $1,$2...
  # charset=iso-2022-jp


  %translations =
  (  
     'charset=iso-8859-1'                     => 'charset=iso-8859-2',
     'Maximal 5 Minute Incoming Traffic'      => 'Maksymalny ruch przychodzcy w cigu 5 minut',
     'Maximal 5 Minute Outgoing Traffic'      => 'Maksymalny ruch wychodzcy w cigu 5 minut',
     'the device'                             => 'urzdzenie',
     'The statistics were last updated(.*)'   => 'Ostatnie uaktualnienie statystyki $1',
     ' Average\)</B><BR>'                     => ' rednia)</B><BR>',
     '<TD ALIGN=right><SMALL>Average(.*)'     => '<TD ALIGN=left><SMALL>rednio$1',
     '<TD ALIGN=right><SMALL>Max(.*)'         => '<TD ALIGN=left><SMALL>Maksymalnie$1',
     '<TD ALIGN=right><SMALL>Current(.*)'     => '<TD ALIGN=left><SMALL>Aktualnie$1',
     'version'                                => 'wersja',
     '<B>`Daily\' Graph \((.*) Minute'        => '<B>`Dzienny\' Graf w cigu ($1 Minut/y - ',
     '<B>`Weekly\' Graph \(30 Minute'         => '<B>`Tygodniowy\' Graf w cigu (30 minut - ' ,
     '<B>`Monthly\' Graph \(2 Hour'           => '<B>`Miesiczny\' Graf w cigu (2 Godzin - ',
     '<B>`Yearly\' Graph \(1 Day'             => '<B>`Roczny\' Graf w  cigu (1 Dnia - ', 
     'Incoming Traffic in (\S+) per Second'   => 'Ruch przychodzcy - $1 na sekund',
     'Outgoing Traffic in (\S+) per Second'   => 'Ruch wychodzcy - $1 na sekund',
     'at which time (.*) had been up for(.*)' => 'gdy $1 by wczony przez $2',
     # '([kMG]?)([bB])/s'                 => '\$1\$2/s',
     # '([kMG]?)([bB])/min'              => '\$1\$2/min',
     '([kMG]?)([bB])/h'                       => '$1$2/g',
     'Bits'                                => 'Bity',
     'Bytes'                              => 'Bajty',
     '&nbsp;In:</FONT>'                      => '&nbsp;Do:</FONT>',
     '&nbsp;Out:</FONT>'                     => '&nbsp;&nbsp;Z:</FONT>',
     '&nbsp;Percentage</FONT>'               => '&nbsp;Procent:</FONT>',
     'Ported to OpenVMS Alpha by'             => 'Port dla OpenVMS Alpha dziki', 
     'Ported to WindowsNT by'                 => 'Post dla WindowsNT dziki',
     'and'                                    => 'i',
     '^GREEN'                                  => 'ZIELONY',
     'BLUE'                                   => 'NIEBIESKI',
     'DARK GREEN'                             => 'CIEMNO ZIELONY',
     'MAGENTA'                                => 'KARMAZYNOWY',
     'AMBER'                                  => 'BURSZTYNOWY'
  );

# maybe expansions with replacement of whitespace would be more appropriate
foreach $i (keys %translations)
{
  if($string=~/$i/)
  { 
    (@dollar)=($string=~/()$i/); # I hope this prevents the autovars
    $string=$translations{$i};  # And it only works from $1-$9
    for($j=1;@dollar[$j];$j++)   # s/// doesn't do any good with saved "$1"-exprs.
    {
      @quux=();
      (@quux)=split(/\$$j/,$string);
      $string=@quux[0].@dollar[$j].@quux[1];
    } ; 
    return $string;
  };
};

%wday = 
    (
      'Sunday'    => 'Niedziela',     'Sun' => 'Nie',
      'Monday'    => 'Poniedziaek',  'Mon' => 'Pon',
      'Tuesday'   => 'Wtorek',        'Tue' => 'Wto',
      'Wednesday' => 'roda',         'Wed' => 'ro',
      'Thursday'  => 'Czwartek',      'Thu' => 'Czw',
      'Friday'    => 'Pitek',        'Fri' => 'Pi',
      'Saturday'  => 'Sobota',        'Sat' => 'Sob' 

    );

%month = 
    (
      'January'   => 'Stycznia',     'February'  => 'Lutego',      'March'     => 'Marca',
      'Jan'       => 'Sty',          'Feb'       => 'Lut',         'Mar'       => 'Mar',
      'April'     => 'Kwietnia',     'May'       => 'Maja',        'June'      => 'Czerwca', 
      'Apr'       => 'Kwi',          'May'       => 'Maj',         'Jun'       => 'Cze',
      'July'      => 'Lipica',       'August'    => 'Sierpnia',    'September' => 'Wrzesnia', 
      'Jul'       => 'Lip',          'Aug'       => 'Sie',         'Sep'       => 'Wrz', 
      'October'   => 'Padziernika', 'November'  => 'Listopada',   'December'  => 'Grudnia', 
      'Oct'       => 'Pa',          'Nov'       => 'Lis',         'Dec'       => 'Gru' 
    );

  @foo=($string=~/(\S+),\s+(\S+)\s+(\S+)(.*)/);
  if( $wday{@foo[0]} && $month{@foo[2]} )
    {
	if(@foo[3]=~(/(.*)at(.*)/))
      { 
        @quux=split(/at/,@foo[3]);
        @foo[3]=@quux[0]." o godzinie".@quux[1]; 
      };
      return "$wday{@foo[0]} dzie @foo[1]. $month{@foo[2]} @foo[3]"; 
    };

#
# handle two different time/date formats:  
# return "$wday, $mday $month ".($year+1900)." at $hour:$min";
# return "$wday, $mday $month ".($year+1900)." $hour:$min:$sec GMT";
#

# handle nontranslated strings which ought to be translated
# print STDERR "$_\n" or print DEBUG "not translated $_";
# but then again we might not want/need to translate all strings
  
  return $string;

};


# Russian

sub russian
{
  my($string)=pop(@_);
  my(%translations,%month,%wday);

  my($i,$j);
  my(@dollar,@quux,@foo);

  
  # regexp => replacement string NOTE does not use autovars $1,$2...
  # charset=iso-2022-jp

  %translations =
  (  
     #'charset=iso-8859-1'                     => 'charset=iso-8859-1',
     'Maximal 5 Minute Incoming Traffic'      => '    5 ',
     'Maximal 5 Minute Outgoing Traffic'      => '    5 ',
     'the device'                             => '',
     'The statistics were last updated(.*)'   => '    $1',
     ' Average\)</B><BR>'                     => ')</B><BR>',
     '<TD ALIGN=right><SMALL>Average(.*)'     => '<TD ALIGN=right><SMALL>$1',
     '<TD ALIGN=right><SMALL>Max(.*)'         => '<TD ALIGN=right><SMALL>.$1',
     '<TD ALIGN=right><SMALL>Current(.*)'     => '<TD ALIGN=right><SMALL>$1',
     'version'                                => '',
     '<B>`Daily\' Graph \((.*) Minute'        => '<B>  (  $1 ',
     '<B>`Weekly\' Graph \(30 Minute'         => '<B>  (  30 ' ,
     '<B>`Monthly\' Graph \(2 Hour'           => '<B>   (  2 ',
     '<B>`Yearly\' Graph \(1 Day'             => '<B>  (  1 ', 
     'Incoming Traffic in (\S+) per Second'   => '   $1  ',
     'Outgoing Traffic in (\S+) per Second'   => '   $1  ',
     'at which time (.*) had been up for(.*)' => '   $1   $2',
     #'([kMG]?)([bB])/s'                      => '$1$1/',
     #'([kMG]?)([bB])/min'                    => '$1$2/',
     '([kMG]?)([bB])/h'                       => '$1$2/',
     'Bits'                                  => '',
     'Bytes'                                 => '',
     '&nbsp;In:</FONT>'                       => '&nbsp;:</FONT>',
     '&nbsp;Out:</FONT>'                      => '&nbsp;:</FONT>',
     '&nbsp;Percentage</FONT>'                => '&nbsp;:</FONT>',
     'Ported to OpenVMS Alpha by'             => '  OpenVMS Alpha',
     'Ported to WindowsNT by'                 => '  WindowsNT',
     'and'                                    => '',
     '^GREEN'                                  => '',
     'BLUE'                                   => '',
     'DARK GREEN'                             => '',
     'MAGENTA'                                => '',
     'AMBER'                                  => ''
  );

# maybe expansions with replacement of whitespace would be more appropriate
foreach $i (keys %translations)
{
  if($string=~/$i/)
  { 
    (@dollar)=($string=~/()$i/); # I hope this prevents the autovars
    $string=$translations{$i};  # And it only works from $1-$9
    for($j=1;@dollar[$j];$j++)   # s/// doesn't do any good with saved "$1"-exprs.
    {
      @quux=();
      (@quux)=split(/\$$j/,$string);
      $string=@quux[0].@dollar[$j].@quux[1];
    } ; 
    return $string;
  };
};

%wday = 
    (
      'Sunday'    => ' ',	'Sun' => '',
      'Monday'    => ' ',		'Mon' => '',
      'Tuesday'   => ' ',		'Tue' => '',
      'Wednesday' => ' ',	'Wed' => '',
      'Thursday'  => ' ',		'Thu' => '',
      'Friday'    => ' ',	'Fri' => '',
      'Saturday'  => ' ',		'Sat' => '' 
    );

%month = 
    (
      'January'   => '',   'February'  => '' ,    'March'     => '',
      'Jan'       => '',       'Feb'       => '',         'Mar'       => '',
      'April'     => '',     'May'       => '',         'June'      => '', 
      'Apr'       => '',       'May'       => '',         'Jun'       => '',
      'July'      => '',   'August'    => '',        'September' => '', 
      'Jul'       => '',       'Aug'       => '',         'Sep'       => '', 
      'October'   => '',   'November'  => '',    'December'  => '', 
      'Oct'       => '',       'Nov'       => '',         'Dec'       => '' 
    );

  @foo=($string=~/(\S+),\s+(\S+)\s+(\S+)(.*)/);
  if( $wday{@foo[0]} && $month{@foo[2]} )
    {
	if(@foo[3]=~(/(.*)at(.*)/))
      { 
        @quux=split(/at/,@foo[3]);
        @foo[3]=@quux[0].".  ".@quux[1]; 
      };
      return "$wday{@foo[0]} @foo[1] $month{@foo[2]} @foo[3]"; 
    };

#
# handle two different time/date formats:  
# return "$wday, $mday $month ".($year+1900)." at $hour:$min";
# return "$wday, $mday $month ".($year+1900)." $hour:$min:$sec GMT";
#

# handle nontranslated strings which ought to be translated
# print STDERR "$_\n" or print DEBUG "not translated $_";
# but then again we might not want/need to translate all strings
  
  return $string;

};
# Spanish

sub spanish
{
  my($string)=pop(@_);
  my(%translations,%month,%wday);

  my($i,$j);
  my(@dollar,@quux,@foo);

  
  # regexp => replacement string NOTE does not use autovars $1,$2...

  %translations =
  (  
     'charset=iso-8859-1'                     => 'charset=iso-8859-1',
     'Maximal 5 Minute Incoming Traffic'      => 'Tr&aacute;fico entrante m&aacute;ximo en 5 minutos',
     'Maximal 5 Minute Outgoing Traffic'      => 'Tr&aacute;fico saliente m&aacute;ximo en 5 minutos',
     'the device'                             => 'el dispositivo',
     'The statistics were last updated(.*)'   => 'Estad&iacute;sticas actualizadas el $1',
     ' Average\)</B><BR>'                     => ' Promedio)</B><BR>',
     '<TD ALIGN=right><SMALL>Average(.*)'     => '<TD ALIGN=right><SMALL>Promedio $1',
     '<TD ALIGN=right><SMALL>Max(.*)'         => '<TD ALIGN=right><SMALL>M&aacute;x$1',
     '<TD ALIGN=right><SMALL>Current(.*)'     => '<TD ALIGN=right><SMALL>Actual$1',
     'version'                                => 'version',
     '<B>`Daily\' Graph \((.*) Minute'        => '<B>Gr&aacute;fico diario ($1 minutos :',
     '<B>`Weekly\' Graph \(30 Minute'         => '<B>Gr&aacute;fico semanal (30 minutos :' ,
     '<B>`Monthly\' Graph \(2 Hour'           => '<B>Gr&aacute;fico mensual (2 horas :',
     '<B>`Yearly\' Graph \(1 Day'             => '<B>Gr&aacute;fico anual (1 d&iacute;a :', 
     'Incoming Traffic in (\S+) per Second'   => 'Tr&aacute;fico entrante en $1 por segundo',
     'Outgoing Traffic in (\S+) per Second'   => 'Tr&aacute;fico saliente en $1 por segundo',
     'at which time (.*) had been up for(.*)' => '$1 ha estado funcionando durante $2',
     # '([kMG]?)([bB])/s'                      => '\$1\$2/s',
     # '([kMG]?)([bB])/min'                    => '\$1\$2/min',
     # '([kMG]?)([bB])/h'                       => '$1$2/t',
     # 'Bits'                                  => 'Bits',
     # 'Bytes'                                 => 'Bytes'
     '&nbsp;In:</FONT>'                       => '&nbsp;Entrante:</FONT>',
     '&nbsp;Out:</FONT>'                      => '&nbsp;Saliente:</FONT>',
     '&nbsp;Percentage</FONT>'                => '&nbsp;Porcentaje:</FONT>',
     'Ported to OpenVMS Alpha by'             => 'Portado a OpenVMS Alpha por',
     'Ported to WindowsNT by'                 => 'Portado a WindowsNT por',
     'and'                                    => 'y',
     '^GREEN'                                  => 'VERDE',
     'BLUE'                                   => 'AZUL',
     'DARK GREEN'                             => 'VERDE OSCURO',
     'MAGENTA'                                => 'MAGENTA',
     'AMBER'                                  => 'AMBAR'
  );

# maybe expansions with replacement of whitespace would be more appropriate
foreach $i (keys %translations)
{
  if($string=~/$i/)
  { 
    (@dollar)=($string=~/()$i/); # I hope this prevents the autovars
    $string=$translations{$i};  # And it only works from $1-$9
    for($j=1;@dollar[$j];$j++)   # s/// doesn't do any good with saved "$1"-exprs.
    {
      @quux=();
      (@quux)=split(/\$$j/,$string);
      $string=@quux[0].@dollar[$j].@quux[1];
    } ; 
    return $string;
  };
};

%wday = 
    (
      'Sunday'    => 'Domingo',		'Sun' => 'Dom',
      'Monday'    => 'Lunes',		'Mon' => 'Lun',
      'Tuesday'   => 'Martes',		'Tue' => 'Mar',
      'Wednesday' => 'Mi&eacute;rcoles','Wed' => 'Mi&eacute;',
      'Thursday'  => 'Jueves',		'Thu' => 'Jue',
      'Friday'    => 'Viernes',		'Fri' => 'Vie',
      'Saturday'  => 'S&aacute;bado',	'Sat' => 'Sab' 
    );

%month = 
    (
 'January' => 'Enero',   'February' => 'Febrero' ,  'March'     => 'Marzo',
 'Jan'     => 'Ene',     'Feb'      => 'Feb',       'Mar'       => 'Mar',
 'April'   => 'Abril',   'May'      => 'Mayo',      'June'      => 'Junio', 
 'Apr'     => 'Abr',     'May'      => 'Mai',       'Jun'       => 'Jun',
 'July'    => 'Julio',   'August'   => 'Agosto',    'September' => 'Setiembre', 
 'Jul'     => 'Jul',     'Aug'      => 'Ago',       'Sep'       => 'Set', 
 'October' => 'Octubre', 'November' => 'Noviembre', 'December'  => 'Diciembre', 
 'Oct'     => 'Oct',     'Nov'       => 'Nov',      'Dec'       => 'Dic' 
    );

  @foo=($string=~/(\S+),\s+(\S+)\s+(\S+)(.*)/);
  if( $wday{@foo[0]} && $month{@foo[2]} )
    {
	if(@foo[3]=~(/(.*)at(.*)/))
      { 
        @quux=split(/at/,@foo[3]);
        @foo[3]=@quux[0]." a las ".@quux[1]; 
      };
      return "$wday{@foo[0]} @foo[1] de $month{@foo[2]} de @foo[3]"; 
    };
}

