/*      
 * iroffer by PMG
 * Copyright (C) 1999 PMG
 * 
 * By using this file, you agree to the terms and conditions set
 * forth in the GNU General Public License.  More information is    
 * available in the README file.
 * 
 */

/* include the headers */
#include "defines.h"
#include "headers.h"
#include "globals.h"

/* display stuff for iroffer */

void initscreen() {
   struct winsize win;
   char *tempstr,*tempstr2;
   
   if (background == 2) return;
   
   /* clear */
   printf("[H[J[r");
   attop = 0;

   if ( ! USESCREEN )
      return;
   
   termcols = 80;
   termcols = 24;
   
   if (ioctl(0, TIOCGWINSZ, &win) == 0) {
      termcols = win.ws_col;
      termlines = win.ws_row;
      }
   
   
   /* last 2 lines */
   tempstr = mycalloc(maxtextlength,"initscreen");
   tempstr2 = mycalloc(maxtextlengthshort,"initscreen");
   getstatusline(tempstr);
   tempstr[min2(maxtextlength-2,termcols-4)] = '\0';
   snprintf(tempstr2,maxtextlengthshort-2,"[%d;1H[ %%-%ds ]",termlines-1,termcols-4);
   printf(tempstr2,tempstr);
   mydelete(tempstr);
   mydelete(tempstr2);

   printf("[%d;1H[ iroffer (%s) >",termlines,(user_nick ? user_nick : ""));
   printf("[%d;%dH]",termlines,termcols);
   
   /* scrolling */
   printf("[1;%dr",termlines-2);
   
   /* set bottom */
   printf("[%d;%dH",termlines,(int)(user_nick ? 16+strlen(user_nick) : 16));
   
   fflush(stdout);
   }

void checktermsize() {
   int notok;
   struct winsize win;
   
   notok = 0;
   if (background == 2) return;
   
   if (ioctl(0, TIOCGWINSZ, &win) == 0) {
      if (termcols != win.ws_col) notok++;
      if (termlines != win.ws_row) notok++;
      if (notok) {
         termcols = win.ws_col;
         termlines = win.ws_row;
         initscreen();
         if (!attop) gototop();
         printf("*** Window Size Changed To: %dx%d\n",termcols,termlines);
         gotobot();
         }
      }
   }

void gototop () {
   if (background == 2) return;
   attop = 1;
   if ( ! USESCREEN )
      return;
   
   printf("[s[%d;1H",termlines-2);
   }

void clearbot () {
   int i;
   if (background == 2) return;
   if ( ! USESCREEN )
      return;

   /* last line */
   printf("[%d;%dH",termlines,(int)(user_nick ? 16+strlen(user_nick) : 16));
   
   for (i=0; i<needsclear; i++)
      printf(" ");
   printf("[%d;%dH[s",termlines,(int)(user_nick ? 16+strlen(user_nick) : 16));
   
   printf("[%d;1H[ iroffer (%s) > ",termlines,(user_nick ? user_nick : ""));
   printf("[%d;%dH]",termlines,termcols);  
   }

void gotobot () {
   if (background == 2) return;
   attop = 0;
   if ( ! USESCREEN )
      return;
   
   printf("[u");
   fflush(stdout);
   }


