/**************************
 Main source file
 (c) 1999 Jeremy Wise
 GnomeICU
***************************/

/*** GnomeICU header files ***/
#include "common.h"

/*** Toplevel header files ***/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/time.h>
#include <fcntl.h>
#include <time.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>
#include <assert.h>
#include <sys/wait.h>
#include <signal.h>
#ifdef HAVE_SOCKS5
#define SOCKS
#include <socks.h>
#endif

/*** XPM files ***/
#ifdef USE_STATUS_MENU
#include "xpms/gnomeicu-away.xpm"
#include "xpms/gnomeicu-na.xpm"
#include "xpms/gnomeicu-occ.xpm"
#include "xpms/gnomeicu-dnd.xpm"
#include "xpms/gnomeicu-ffc.xpm"
#include "xpms/gnomeicu-inv.xpm"
#include "xpms/gnomeicu-online.xpm"
#include "xpms/gnomeicu-offline.xpm"
#endif

gboolean Quit = FALSE;
WORD seq_num = 1;  /* current sequence number */
DWORD our_ip = 0x7f000001; /* localhost for some reason */
DWORD our_port = 0; /* the port to make tcp connections on */
DWORD our_sok; /* The TCP socket */
GSList *Contacts = NULL;
Contact_Member New_Contact;
DWORD Current_Status=STATUS_OFFLINE;
DWORD last_recv_uin=0;
gchar *passwd = NULL;
gchar *server = NULL;
DWORD set_status;
DWORD remote_port;
gboolean Done_Login=FALSE;
gchar *Away_Message = NULL;
gboolean search_in_progress = FALSE;

gboolean sound_disable = FALSE;

BYTE chat_fg_red = 0, chat_fg_green = 0, chat_fg_blue = 0;
BYTE chat_bg_red = 255, chat_bg_green = 255, chat_bg_blue = 255;

GtkWidget *log_list;
GtkWidget *log_window;

GtkWidget *status_button = NULL;
GtkWidget *status_im = NULL;

GdkPixmap *still_eyes_pixmap;
GdkPixmap *icon_blank_pixmap;
GdkPixmap *icon_message_pixmap;
GdkPixmap *icon_url_pixmap;
GdkPixmap *icon_auth_pixmap;
GdkPixmap *icon_away_pixmap;
GdkPixmap *icon_na_pixmap;
GdkPixmap *icon_occ_pixmap;
GdkPixmap *icon_dnd_pixmap;
GdkPixmap *icon_ffc_pixmap;
GdkPixmap *icon_inv_pixmap;
GdkPixmap *icon_online_pixmap;
GdkPixmap *icon_offline_pixmap;
GdkPixmap *icon_chat_pixmap;
GdkPixmap *icon_file_pixmap;
GdkPixmap *icon_info_pixmap;
GdkPixmap *icon_contact_pixmap;
GdkPixmap *icon_hist_pixmap;
GdkPixmap *icon_ok_pixmap;
GdkPixmap *icon_cancel_pixmap;
GdkPixmap *icon_rename_pixmap;

GdkBitmap *still_eyes_bitmap;
GdkBitmap *icon_blank_bitmap;
GdkBitmap *icon_message_bitmap;
GdkBitmap *icon_url_bitmap;
GdkBitmap *icon_auth_bitmap;
GdkBitmap *icon_away_bitmap;
GdkBitmap *icon_na_bitmap;
GdkBitmap *icon_occ_bitmap;
GdkBitmap *icon_dnd_bitmap;
GdkBitmap *icon_ffc_bitmap;
GdkBitmap *icon_inv_bitmap;
GdkBitmap *icon_online_bitmap;
GdkBitmap *icon_offline_bitmap;
GdkBitmap *icon_chat_bitmap;
GdkBitmap *icon_file_bitmap;
GdkBitmap *icon_info_bitmap;
GdkBitmap *icon_contact_bitmap;
GdkBitmap *icon_hist_bitmap;
GdkBitmap *icon_ok_bitmap;
GdkBitmap *icon_cancel_bitmap;
GdkBitmap *icon_rename_bitmap;

gchar *configfilename = NULL;

/* Autohide */
gint autohide_time = 0;
gint autohide_timeout_tag = 0; /* timeout tag, 0 means it's inactive */
gboolean autohide_cbs_are_connected = FALSE;

gint min_tcp_port = 4000;
gint max_tcp_port = 5000;

gboolean Connected = FALSE;

USER_INFO_PTR our_info;

_toggles *toggles;

gboolean is_new_user = FALSE;

gint udp_gdk_input = 0;
gint tcp_gdk_input = 0;

GtkWidget *statusbar;
GtkTooltips *status_tooltip;

gint connecting;

USER_INFO_STRUCT our_user_info;

gchar *WindowTitle = NULL;
gint WindowWidth = 175, WindowHeight = 310;

guint next_resend;

struct sokandlb *MainData;

GdkFont *ChatFont;
gchar *ChatFontString = NULL;

GtkWidget *app;

static char *cfnp;

gboolean been_thru_init = FALSE;

gboolean enable_online_events = FALSE;

GtkWidget *eyes_animated;
GtkWidget *eyes_still;

GtkTargetEntry target_table[] = {
	{ "STRING", 0, TARGET_STRING }
};

/*** Local function declarations ***/
void source_drag_data_get (GtkWidget *widget, GdkDragContext *context,
                           GtkSelectionData *selection_data, guint info,
                           guint time, gpointer data);
void change_userwin( GtkWidget *widget, GtkNotebookPage *page, int num,
                     gpointer data );

                                                                                                                                       
/*** Global functions ***/
void create_tcp_line( void )
{
	gint cx;
	struct sockaddr_in addr;
	gint temp_sok;
	gint l = 1;
	gboolean have_tcp_port = FALSE;

	if( our_sok )
		close( our_sok );

	for( cx = min_tcp_port; cx <= max_tcp_port; cx ++ )
	{
		addr.sin_addr.s_addr = g_htonl( INADDR_ANY );
		addr.sin_family = AF_INET;
		addr.sin_port = g_htons( cx );

		temp_sok = socket( AF_INET, SOCK_STREAM, 0 );
		setsockopt( temp_sok, SOL_SOCKET, SO_REUSEADDR, &l, 4 );

		our_sok = bind( temp_sok, (struct sockaddr *)&addr, sizeof( addr ) );
		if( our_sok != -1 )
			have_tcp_port = TRUE;
		else
			continue;

		our_sok = temp_sok;
		our_port = cx;

		if( -1 == listen( our_sok, 10 ) )
		  g_error( _("Cannot listen to socket, port %u\n"), our_port );

		l = sizeof( addr );

		gdk_input_remove( tcp_gdk_input );

		tcp_gdk_input = gdk_input_add( our_sok, GDK_INPUT_READ, (GdkInputFunction) TCPAcceptIncoming, NULL );

		g_free( our_info->ip );

		our_info->ip = g_strdup_printf( "%u.%u.%u.%u",
		         (BYTE) (our_ip >> 24),
		         (BYTE) (our_ip >> 16),
		         (BYTE) (our_ip >> 8),
		         (BYTE) (our_ip) );

		g_free( our_info->port );

		our_info->port = g_strdup_printf( "%u", our_port );
		break;
	}

	if( have_tcp_port == FALSE )
		g_error( g_strdup_printf( "No TCP port available between %d and %d.\n",
		                          min_tcp_port, max_tcp_port ) );
}

void ready_set( void )
{
	char *sts = NULL;
	GtkWidget *label;
	GtkWidget *pixmap;

#ifdef TRACE_FUNCTION
	g_print( "ready_set(%08X)\n", Current_Status );
#endif

	if ( Current_Status == STATUS_OFFLINE )
	{
		sts = _("  Offline");
	}
	else
	{
		switch ( Current_Status & 0xffff )
		{
			case STATUS_ONLINE:
				sts = _("  Online");
				break;
			case STATUS_DND:
				sts = _("  Do Not Disturb");
				break;
			case STATUS_AWAY:
				sts = _("  Away");
				break;
			case STATUS_OCCUPIED:
				sts = _("  Occupied");
				break;
			case STATUS_NA:
				sts = _("  Not Available");
				break;
			case STATUS_INVISIBLE:
				sts = _("  Invisible");
				break;
			case STATUS_FREE_CHAT:
				sts = _("  Free for Chat");
				break;
			default:
				sts = _(" Not Connected");
				break;
		}
	}

	if( status_im != NULL )
		gtk_container_remove( GTK_CONTAINER( status_button ), status_im );

	status_im = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (status_im);

	pixmap = gtk_pixmap_new( GetIcon_p( Current_Status ), GetIcon_b( Current_Status ) );
	gtk_widget_show (pixmap);
	gtk_box_pack_start (GTK_BOX (status_im), pixmap, FALSE, FALSE, 0);

	label = gtk_label_new ( sts );
	gtk_widget_show (label);
	gtk_box_pack_start (GTK_BOX (status_im), label, TRUE, TRUE, 0);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);

	gtk_container_add( GTK_CONTAINER( status_button ), status_im );
	gtk_widget_show( status_im );
}

void toggle_log_window( GtkWidget *widget, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "toggle_log_window\n" );
#endif

	if( !GTK_WIDGET_VISIBLE( log_window ) )
		gtk_widget_show( log_window );
}

void init( void )
{
#ifdef TRACE_FUNCTION
	g_print( "init\n" );
#endif

	if( is_new_user )
		return;

	Done_Login = TRUE;

	gtk_timeout_add( 120000, (GtkFunction) stay_connected, NULL );
	gtk_timeout_add( 500, (GtkFunction) flash_messages, NULL );
#ifdef USE_AUTOAWAY
	gtk_timeout_add( 1000, (GtkFunction) auto_away, NULL );
#endif

	been_thru_init = TRUE;
}

/*** Local functions ***/

/*** MAIN function ***/
int main( int argc, char *argv[] )
{
	int cx;
	int l = 1;
	int temp_sok;
	struct sockaddr_in addr;

	GnomeClient *client;

	static struct poptOption arguments[] =
	{
		{"uin", 'u', POPT_ARG_STRING, &cfnp, 0, N_("Use the defined UIN"), N_("UIN")},
		{NULL, 'a', POPT_ARG_NONE, 0, 0, N_("Startup without applet support"), NULL},
		{NULL, 0, 0, NULL, 0, NULL, NULL}
	};

#include "menus.h"

	GtkStyle  *style;

	GtkWidget *dialog_vbox1;
	GtkWidget *scrolledwindow1;
	GtkWidget *dialog_action_area1;
	GtkWidget *button1;


	GtkWidget *dock1;
	GtkWidget *vbox1;
	GtkWidget *scrolledwindow2;
	GtkWidget *label5;
	GtkWidget *label6;
	GtkWidget *label3;
	GtkWidget *label4;
	GtkWidget *label7;
	GtkWidget *label8;
	GtkWidget *table1;
	GtkWidget *hbox1;
	GtkWidget *appbar1;

	GSList *contact;

	gchar *str;

	gboolean have_tcp_port = FALSE;

#ifdef TRACE_FUNCTION
	g_print( "main\n" );
#endif

	bindtextdomain(PACKAGE, GNOMELOCALEDIR);  
	textdomain(PACKAGE);

#ifdef HAVE_SOCKS5
	SOCKSinit(argv[0]);
#endif

	our_info = g_new0( USER_INFO_STRUCT, 1 );
	our_info->country = 1; /* USA */

	toggles = g_new0( _toggles, 1 );

	MainData = g_new0( struct sokandlb, 1 );

	WindowTitle = g_strdup( _("GnomeICU") );
	configfilename = g_strdup( "/GnomeICU/" );

	Current_Status = STATUS_OFFLINE;

	make_applet( argc, argv );
	gnome_config_push_prefix( configfilename );

	if( toggles->applet == FALSE )
	{
		cfnp = 0;
		gnome_init_with_popt_table( PACKAGE, VERSION, argc, argv,
		                            arguments, 0, NULL );
		if( cfnp )
		  {
		    g_free( configfilename );
		    configfilename = g_strdup_printf( "/GnomeICU_%s/", cfnp );
		  }
	}

	Get_Unix_Config_Info();

	if ( toggles->applet == FALSE )
	{
		client = gnome_master_client();
		gtk_signal_connect( GTK_OBJECT( client ), "destroy",
		                    GTK_SIGNAL_FUNC( icq_quit ),
		                    NULL );

		gtk_signal_connect( GTK_OBJECT ( client ), "save_yourself",
		                    GTK_SIGNAL_FUNC(app_save_state_cb),
		                    (gpointer)argv[0]);
	}

	/* These two lines are needed for imlib to work properly */
	gtk_widget_push_visual(gdk_imlib_get_visual());
	gtk_widget_push_colormap(gdk_imlib_get_colormap());

	app = gnome_app_new ( "Gnomeicu", WindowTitle );
	gtk_object_set_data (GTK_OBJECT (app), "app", app);
	gtk_window_set_default_size (GTK_WINDOW (app), WindowWidth, WindowHeight );
	gtk_window_set_policy (GTK_WINDOW (app), TRUE, TRUE, FALSE);

	MainData->window = app;

	dock1 = GNOME_APP (app)->dock;
	gtk_widget_ref (dock1);
	gtk_object_set_data_full (GTK_OBJECT (app), "dock1", dock1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (dock1);

	gnome_app_create_menus (GNOME_APP (app), mainmenu );

/*
	gtk_widget_ref (menubar1_uiinfo[0].widget);
	gtk_object_set_data_full (GTK_OBJECT (app), "icq1",
	                          menubar1_uiinfo[0].widget,
	                          (GtkDestroyNotify) gtk_widget_unref);
*/

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (app), "vbox1", vbox1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);
	gnome_app_set_contents (GNOME_APP (app), vbox1);

	MainData->notebook = gtk_notebook_new ();
	gtk_widget_ref (MainData->notebook);
	gtk_object_set_data_full (GTK_OBJECT (app), "notebook1", MainData->notebook,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (MainData->notebook);
	gtk_box_pack_start (GTK_BOX (vbox1), MainData->notebook, TRUE, TRUE, 0);

	gtk_signal_connect( GTK_OBJECT( MainData->notebook ), "switch_page",
	                    GTK_SIGNAL_FUNC( change_userwin ), NULL );

	scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_ref (scrolledwindow2);
	gtk_object_set_data_full (GTK_OBJECT (app), "scrolledwindow2", scrolledwindow2,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (scrolledwindow2);
	gtk_container_add (GTK_CONTAINER (MainData->notebook), scrolledwindow2);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow2), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

	MainData->lb_userwin_online = gtk_clist_new (2);
	gtk_widget_ref (MainData->lb_userwin_online);
	gtk_object_set_data_full (GTK_OBJECT (app), "MainData->lb_userwin_online", MainData->lb_userwin_online,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (MainData->lb_userwin_online);
	gtk_container_add (GTK_CONTAINER (scrolledwindow2), MainData->lb_userwin_online);
	gtk_clist_set_row_height( GTK_CLIST( MainData->lb_userwin_online ), 20 );
	gtk_clist_set_column_width (GTK_CLIST (MainData->lb_userwin_online), 0, 16);
	gtk_clist_set_column_width (GTK_CLIST (MainData->lb_userwin_online), 1, 10);
	gtk_clist_set_selection_mode (GTK_CLIST (MainData->lb_userwin_online), GTK_SELECTION_BROWSE);
	gtk_clist_column_titles_hide (GTK_CLIST (MainData->lb_userwin_online));

	MainData->lb_userwin = MainData->lb_userwin_online;

	gtk_signal_connect( GTK_OBJECT( MainData->lb_userwin_online ), "button_press_event",
	                    GTK_SIGNAL_FUNC( icq_sendmessage_window ), NULL );

	gtk_signal_connect( GTK_OBJECT( MainData->lb_userwin_online ), "key_press_event",
	                    GTK_SIGNAL_FUNC( icq_sendmessage_window ), NULL );

	gtk_drag_source_set( MainData->lb_userwin_online, GDK_BUTTON1_MASK,
	                     target_table, 1, GDK_ACTION_COPY | GDK_ACTION_MOVE );

	gtk_drag_source_set_icon( MainData->lb_userwin_online, gtk_widget_get_colormap (MainData->window),
	                          icon_online_pixmap, icon_online_bitmap );

	gtk_signal_connect( GTK_OBJECT( MainData->lb_userwin_online ), "drag_data_get",
	                    GTK_SIGNAL_FUNC( source_drag_data_get), NULL );

	init_contact_list_drag_drop( MainData->lb_userwin_online );

	label5 = gtk_label_new (_("label5"));
	gtk_widget_ref (label5);
	gtk_object_set_data_full (GTK_OBJECT (app), "label5", label5,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label5);
	gtk_clist_set_column_widget (GTK_CLIST (MainData->lb_userwin_online), 0, label5);

	label6 = gtk_label_new (_("label6"));
	gtk_widget_ref (label6);
	gtk_object_set_data_full (GTK_OBJECT (app), "label6", label6,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label6);
	gtk_clist_set_column_widget (GTK_CLIST (MainData->lb_userwin_online), 1, label6);

	MainData->head_online = gtk_label_new (_("Online"));
	gtk_widget_ref (MainData->head_online);
	gtk_object_set_data_full (GTK_OBJECT (app), "head_online", MainData->head_online,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (MainData->head_online);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (MainData->notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (MainData->notebook), 0), MainData->head_online);

	scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_ref (scrolledwindow1);
	gtk_object_set_data_full (GTK_OBJECT (app), "scrolledwindow1", scrolledwindow1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (scrolledwindow1);
	gtk_container_add (GTK_CONTAINER (MainData->notebook), scrolledwindow1);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

	MainData->lb_userwin_offline = gtk_clist_new (2);
	gtk_widget_ref (MainData->lb_userwin_offline);
	gtk_object_set_data_full (GTK_OBJECT (app), "MainData->lb_userwin_offline", MainData->lb_userwin_offline,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (MainData->lb_userwin_offline);
	gtk_container_add (GTK_CONTAINER (scrolledwindow1), MainData->lb_userwin_offline);
	gtk_clist_set_row_height( GTK_CLIST( MainData->lb_userwin_offline ), 20 );
	gtk_clist_set_column_width (GTK_CLIST (MainData->lb_userwin_offline), 0, 16);
	gtk_clist_set_column_width (GTK_CLIST (MainData->lb_userwin_offline), 1, 10);
	gtk_clist_set_selection_mode (GTK_CLIST (MainData->lb_userwin_offline), GTK_SELECTION_BROWSE);
	gtk_clist_column_titles_hide (GTK_CLIST (MainData->lb_userwin_offline));

	gtk_signal_connect( GTK_OBJECT( MainData->lb_userwin_offline ), "button_press_event",
	                    GTK_SIGNAL_FUNC( icq_sendmessage_window ), NULL );

	gtk_signal_connect( GTK_OBJECT( MainData->lb_userwin_offline ), "key_press_event",
	                    GTK_SIGNAL_FUNC( icq_sendmessage_window ), NULL );

	gtk_drag_source_set( MainData->lb_userwin_offline, GDK_BUTTON1_MASK,
	                     target_table, 1, GDK_ACTION_COPY | GDK_ACTION_MOVE );

	gtk_drag_source_set_icon( MainData->lb_userwin_offline, gtk_widget_get_colormap (MainData->window),
	                          icon_online_pixmap, icon_online_bitmap );

	gtk_signal_connect( GTK_OBJECT( MainData->lb_userwin_offline ), "drag_data_get",
	                    GTK_SIGNAL_FUNC( source_drag_data_get), NULL );

	init_contact_list_drag_drop( MainData->lb_userwin_offline );

	if( toggles->applet == FALSE )
	{
		gtk_signal_connect( GTK_OBJECT( app ), "destroy",
		                    GTK_SIGNAL_FUNC( icq_quit ), NULL );
		style = gtk_widget_get_style( MainData->lb_userwin );

		init_pixmaps( style, app );
	}
	else
		gtk_signal_connect( GTK_OBJECT( app ), "delete_event",
		                    GTK_SIGNAL_FUNC( applet_hide_main ), 0 );

	if( toggles->show_window )
		gtk_widget_show_all( app );

	label3 = gtk_label_new (_("label3"));
	gtk_widget_ref (label3);
	gtk_object_set_data_full (GTK_OBJECT (app), "label3", label3,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label3);
	gtk_clist_set_column_widget (GTK_CLIST (MainData->lb_userwin_offline), 0, label3);

	label4 = gtk_label_new (_("label4"));
	gtk_widget_ref (label4);
	gtk_object_set_data_full (GTK_OBJECT (app), "label4", label4,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label4);
	gtk_clist_set_column_widget (GTK_CLIST (MainData->lb_userwin_offline), 1, label4);

	MainData->head_offline = gtk_label_new (_("Offline"));
	gtk_widget_ref (MainData->head_offline);
	gtk_object_set_data_full (GTK_OBJECT (app), "head_offline", MainData->head_offline,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (MainData->head_offline);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (MainData->notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (MainData->notebook), 1), MainData->head_offline);

	MainData->not_contents = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_ref (MainData->not_contents);
	gtk_object_set_data_full (GTK_OBJECT (app), "scrolledwindow3", MainData->not_contents,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (MainData->not_contents);
/*	gtk_container_add (GTK_CONTAINER (MainData->notebook), MainData->not_contents);*/
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (MainData->not_contents), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

	MainData->lb_userwin_notinlist = gtk_clist_new (2);
	gtk_widget_ref (MainData->lb_userwin_notinlist);
	gtk_object_set_data_full (GTK_OBJECT (app), "MainData->lb_userwin_notinlist", MainData->lb_userwin_notinlist,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (MainData->lb_userwin_notinlist);
	gtk_container_add (GTK_CONTAINER (MainData->not_contents), MainData->lb_userwin_notinlist);
	gtk_clist_set_row_height( GTK_CLIST( MainData->lb_userwin_notinlist ), 20 );
	gtk_clist_set_column_width (GTK_CLIST (MainData->lb_userwin_notinlist), 0, 16);
	gtk_clist_set_column_width (GTK_CLIST (MainData->lb_userwin_notinlist), 1, 10);
	gtk_clist_set_selection_mode (GTK_CLIST (MainData->lb_userwin_notinlist), GTK_SELECTION_BROWSE);
	gtk_clist_column_titles_hide (GTK_CLIST (MainData->lb_userwin_notinlist));

	gtk_signal_connect( GTK_OBJECT( MainData->lb_userwin_notinlist ), "button_press_event",
	                    GTK_SIGNAL_FUNC( icq_sendmessage_window ), NULL );

	gtk_signal_connect( GTK_OBJECT( MainData->lb_userwin_notinlist ), "key_press_event",
	                    GTK_SIGNAL_FUNC( icq_sendmessage_window ), NULL );

	gtk_drag_source_set( MainData->lb_userwin_notinlist, GDK_BUTTON1_MASK,
	                     target_table, 1, GDK_ACTION_COPY | GDK_ACTION_MOVE );

	gtk_drag_source_set_icon( MainData->lb_userwin_notinlist, gtk_widget_get_colormap (MainData->window),
	                          icon_online_pixmap, icon_online_bitmap );

	gtk_signal_connect( GTK_OBJECT( MainData->lb_userwin_notinlist ), "drag_data_get",
	                    GTK_SIGNAL_FUNC( source_drag_data_get), NULL );

	init_contact_list_drag_drop( MainData->lb_userwin_notinlist );

	label7 = gtk_label_new (_("label7"));
	gtk_widget_ref (label7);
	gtk_object_set_data_full (GTK_OBJECT (app), "label7", label7,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label7);
	gtk_clist_set_column_widget (GTK_CLIST (MainData->lb_userwin_notinlist), 0, label7);

	label8 = gtk_label_new (_("label8"));
	gtk_widget_ref (label8);
	gtk_object_set_data_full (GTK_OBJECT (app), "label8", label8,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label8);
	gtk_clist_set_column_widget (GTK_CLIST (MainData->lb_userwin_notinlist), 1, label8);

	MainData->head_notinlist = gtk_label_new (_("Not In List"));
	gtk_widget_ref (MainData->head_notinlist);
	gtk_object_set_data_full (GTK_OBJECT (app), "head_notinlist", MainData->head_notinlist,
	                          (GtkDestroyNotify) gtk_widget_unref);
/*	gtk_widget_show (MainData->head_notinlist);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (MainData->notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (MainData->notebook), 2), MainData->head_notinlist);
*/
	table1 = gtk_table_new (1, 2, FALSE);
	gtk_widget_ref (table1);
	gtk_object_set_data_full (GTK_OBJECT (app), "table1", table1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (table1);
	gtk_box_pack_start (GTK_BOX (vbox1), table1, FALSE, FALSE, 0);

	status_button = gtk_button_new ();
	GTK_WIDGET_UNSET_FLAGS (status_button, GTK_CAN_FOCUS);
	gtk_button_set_relief (GTK_BUTTON (status_button), GTK_RELIEF_NONE);

	gtk_widget_ref (status_button);
	gtk_object_set_data_full (GTK_OBJECT (app), "status_button", status_button,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (status_button);
	gtk_table_attach (GTK_TABLE (table1), status_button, 0, 1, 0, 1,
	                  (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
	                  (GtkAttachOptions) (0), 0, 0);

	gtk_signal_connect( GTK_OBJECT( status_button ), "clicked",
	                    GTK_SIGNAL_FUNC( popup_status_menu ), NULL );

	hbox1 = gtk_hbox_new( FALSE, 0 );
	gtk_widget_show( hbox1 );
	gtk_table_attach( GTK_TABLE( table1 ), hbox1, 1, 2, 0, 1,
	                  (GtkAttachOptions) (GTK_FILL | GTK_EXPAND | GTK_SHRINK),
	                  (GtkAttachOptions) (GTK_FILL | GTK_EXPAND | GTK_SHRINK), 0, 0 );

	eyes_still = gtk_pixmap_new( still_eyes_pixmap, still_eyes_bitmap );
	gtk_widget_ref (eyes_still);
	gtk_object_set_data_full (GTK_OBJECT (app), "eyes_still", eyes_still,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (eyes_still);
	gtk_box_pack_end( GTK_BOX( hbox1 ), eyes_still, FALSE, FALSE, 0 );

	eyes_animated = gnome_animator_new_with_size( 29, 14 );

	str = gnome_pixmap_file( "gnomeicu/animeyes.png" );

	if( str == NULL )
		str = gnome_pixmap_file( "animeyes.png" );

	gnome_animator_append_frames_from_file( GNOME_ANIMATOR( eyes_animated ),
	                                        str, 0, 0, 100, 29 );
	g_free( str );

	gtk_box_pack_end( GTK_BOX( hbox1 ), eyes_animated, FALSE, FALSE, 0 );

	appbar1 = gnome_appbar_new (FALSE, FALSE, GNOME_PREFERENCES_NEVER);
	gtk_widget_ref (appbar1);
	gtk_object_set_data_full (GTK_OBJECT (app), "appbar1", appbar1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (appbar1);
	gnome_app_set_statusbar (GNOME_APP (app), appbar1);

	if ( toggles->autohide )
	{
		gtk_signal_connect( GTK_OBJECT (app), "focus_in_event",
				    GTK_SIGNAL_FUNC (stop_autohide_timeout_cb), NULL );

		gtk_signal_connect( GTK_OBJECT (app), "focus_out_event",
				    GTK_SIGNAL_FUNC (start_autohide_timeout_cb), NULL );

		gtk_signal_connect( GTK_OBJECT (app), "expose_event",
				    GTK_SIGNAL_FUNC (start_autohide_timeout_cb), NULL );

		autohide_cbs_are_connected = TRUE;	
	}

	init_colors();

	ready_set();

/*** New log window ***/
	log_window = gnome_dialog_new (_("GnomeICU: Connection History"), NULL);
	gtk_object_set_data (GTK_OBJECT (log_window), "log_window", log_window);
	gtk_window_set_default_size (GTK_WINDOW (log_window), 500, 300);
	gtk_window_set_policy (GTK_WINDOW (log_window), TRUE, TRUE, FALSE);

	dialog_vbox1 = GNOME_DIALOG (log_window)->vbox;
	gtk_object_set_data (GTK_OBJECT (log_window), "dialog_vbox1", dialog_vbox1);
	gtk_widget_show (dialog_vbox1);

	scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_ref (scrolledwindow1);
	gtk_object_set_data_full (GTK_OBJECT (log_window), "scrolledwindow1", scrolledwindow1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (scrolledwindow1);
	gtk_box_pack_start (GTK_BOX (dialog_vbox1), scrolledwindow1, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

	log_list = gtk_clist_new (4);
	gtk_widget_ref (log_list);
	gtk_object_set_data_full (GTK_OBJECT (log_window), "log_list", log_list,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (log_list);
	gtk_container_add (GTK_CONTAINER (scrolledwindow1), log_list);
	gtk_clist_set_column_width (GTK_CLIST (log_list), 0, 80);
	gtk_clist_set_column_width (GTK_CLIST (log_list), 1, 80);
	gtk_clist_set_column_width (GTK_CLIST (log_list), 2, 80);
	gtk_clist_set_column_width (GTK_CLIST (log_list), 3, 80);
	gtk_clist_column_titles_show (GTK_CLIST (log_list));

	label5 = gtk_label_new (_("Time"));
	gtk_widget_ref (label5);
	gtk_object_set_data_full (GTK_OBJECT (log_window), "label5", label5,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label5);
	gtk_clist_set_column_widget (GTK_CLIST (log_list), 0, label5);
	gtk_label_set_justify (GTK_LABEL (label5), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (label5), 7.45058e-09, 0.5);

	label6 = gtk_label_new (_("Date"));
	gtk_widget_ref (label6);
	gtk_object_set_data_full (GTK_OBJECT (log_window), "label6", label6,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label6);
	gtk_clist_set_column_widget (GTK_CLIST (log_list), 1, label6);
	gtk_label_set_justify (GTK_LABEL (label6), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (label6), 7.45058e-09, 0.5);

	label3 = gtk_label_new (_("User"));
	gtk_widget_ref (label3);
	gtk_object_set_data_full (GTK_OBJECT (log_window), "label3", label3,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label3);
	gtk_clist_set_column_widget (GTK_CLIST (log_list), 2, label3);
	gtk_label_set_justify (GTK_LABEL (label3), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (label3), 7.45058e-09, 0.5);

	label4 = gtk_label_new (_("Action"));
	gtk_widget_ref (label4);
	gtk_object_set_data_full (GTK_OBJECT (log_window), "label4", label4,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label4);
	gtk_clist_set_column_widget (GTK_CLIST (log_list), 3, label4);
	gtk_label_set_justify (GTK_LABEL (label4), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (label4), 7.45058e-09, 0.5);

	dialog_action_area1 = GNOME_DIALOG (log_window)->action_area;
	gtk_object_set_data (GTK_OBJECT (log_window), "dialog_action_area1", dialog_action_area1);
	gtk_widget_show (dialog_action_area1);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);
	gtk_button_box_set_spacing (GTK_BUTTON_BOX (dialog_action_area1), 8);

	gnome_dialog_append_button (GNOME_DIALOG (log_window), GNOME_STOCK_BUTTON_CLOSE);
	button1 = g_list_last (GNOME_DIALOG (log_window)->buttons)->data;
	gtk_widget_ref (button1);
	gtk_object_set_data_full (GTK_OBJECT (log_window), "button1", button1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (button1);
	GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);

	gtk_signal_connect_object (GTK_OBJECT (button1), "clicked",
	                           GTK_SIGNAL_FUNC (gtk_widget_hide_on_delete),
	                           GTK_OBJECT( log_window ));
/*** End new log window ***/

	contact = Contacts;

	while( contact != NULL )
	{
		((CONTACT_PTR)contact->data)->icon_p = icon_offline_pixmap;
		((CONTACT_PTR)contact->data)->icon_b = icon_offline_bitmap;
		contact = contact->next;
	}

	Show_Quick_Status();

	msg_queue_init();

	if( toggles->applet == FALSE )
		gtk_widget_show( GTK_WIDGET( app ) );

	while( gtk_events_pending() )
		gtk_main_iteration();

	MainData->sok = 0;
	MainData->sok = Connect_Remote( server, remote_port, STDERR );

	for( cx = min_tcp_port; cx < max_tcp_port; cx ++ )
	{
		addr.sin_addr.s_addr = g_htonl( INADDR_ANY );
		addr.sin_family = AF_INET;
		addr.sin_port = g_htons( cx );

		temp_sok = socket( AF_INET, SOCK_STREAM, 0 );
		setsockopt( temp_sok, SOL_SOCKET, SO_REUSEADDR, &l, 4 );

		our_sok = bind( temp_sok, (struct sockaddr *)&addr, sizeof( addr ) );
		if( our_sok != -1 )
			have_tcp_port = TRUE;
		else
			continue;

		our_sok = temp_sok;
		our_port = cx;

		if( -1 == listen( our_sok, 10 ) )
		  g_error( _("Cannot listen to socket, port %u\n"), our_port );

		l = sizeof( addr );

		tcp_gdk_input = gdk_input_add( our_sok, GDK_INPUT_READ, (GdkInputFunction) TCPAcceptIncoming, NULL );

		our_info->ip = g_strdup_printf( "%u.%u.%u.%u",
		         (BYTE) (our_ip >> 24),
		         (BYTE) (our_ip >> 16),
		         (BYTE) (our_ip >> 8),
		         (BYTE) (our_ip) );

		our_info->port = g_strdup_printf( "%u", our_port );
		break;
	}

	if( have_tcp_port == FALSE )
		g_error( g_strdup_printf( "No TCP port available between %d and %d.\n",
		                          min_tcp_port, max_tcp_port ) );

	if ( MainData->sok > 0 )
	{
		udp_gdk_input = gdk_input_add( MainData->sok, GDK_INPUT_READ, (GdkInputFunction) icq_refresh, NULL );

		Connected = TRUE;

		if( is_new_user )
		{
			Init_New_User();
			Save_RC();
		}

		Login( passwd, our_ip, our_port );
	}

	if( toggles->applet )
	{
		applet_update( STATUS_OFFLINE, NULL );
		applet_widget_gtk_main();
	}
	else
		gtk_main();

	Quit_ICQ();
	return 0;
}

void
source_drag_data_get  (GtkWidget	*widget, GdkDragContext *context,
                       GtkSelectionData *selection_data, guint info,
                       guint time, gpointer data)
{
	gchar *str;
	GSList *contact;
	GtkCList *clist = GTK_CLIST( MainData->lb_userwin );

	contact = Contacts;

	while( contact != NULL )
	{
		if( GPOINTER_TO_INT( gtk_clist_get_row_data( GTK_CLIST( clist ), GPOINTER_TO_INT( clist->selection->data ) ) ) ==
		    ((CONTACT_PTR)contact->data)->uin )
			break;
		contact = contact->next;
	}

	if( contact == NULL )
		return;

	str = g_strdup_printf( "%d\n%s", ((CONTACT_PTR)contact->data)->uin,
	                       ((CONTACT_PTR)contact->data)->nick );
	gtk_selection_data_set( selection_data,
	                        selection_data->target,
	                        8, str, strlen( str ) );
}

void change_userwin( GtkWidget *widget, GtkNotebookPage *page, int num,
                     gpointer data )
{
	if( num == 0 )
		MainData->lb_userwin = MainData->lb_userwin_online;
	else if( num == 1 )
		MainData->lb_userwin = MainData->lb_userwin_offline;
	else if( num == 2 )
		MainData->lb_userwin = MainData->lb_userwin_notinlist;
}
