/***************************************
 Functions to operate the panel applet
 (c) 1999 Jeremy Wise
 GnomeICU
****************************************/

/*** GnomeICU header files ***/
#include "common.h"

/*** Toplevel header files ***/
#include <string.h>
#include <gdk_imlib.h>
#include <applet-widget.h>

GtkWidget *frame;
GtkWidget *frame_outline;
GtkWidget *frame_outline2;
GtkWidget *mess_label;
GtkWidget *mess_pm;
GtkWidget *applet;

gboolean have_read_config = FALSE;

static PanelOrientType orient;

static char *cfnp;

/*** Local function declarations ***/
static gint applet_save_state_cb( GtkWidget *w, const char *privcfgpath, const char *globcfgpath, gpointer data );
static void applet_exposed_cb( GtkWidget *widget, gpointer data );
static GtkWidget *create_applet( void );
static void init_applet_signals( GtkWidget *window );
static void applet_change_orient( GtkWidget *w, PanelOrientType o, gpointer data );

/*** Global functions ***/
void make_applet( int argc, char *argv[] )
{
	int cx;

	GtkStyle *style;

	static struct poptOption arguments[] =
	{
		{"uin", 'u', POPT_ARG_STRING, &cfnp, 0, N_("Use the defined UIN"), N_("UIN")},
		{"noapplet", 'a', POPT_ARG_NONE, 0, 0, N_("startup without applet support"), NULL},
		{NULL, 0, 0, NULL, 0, NULL, NULL}
	};

	GtkWidget *widget;

#ifdef TRACE_FUNCTION
	g_print( "make_applet\n" );
#endif

	toggles->applet = TRUE;

	for( cx = 0; cx < argc; cx ++ )
	{
		if( !strcmp( "-a", argv[ cx ] ) ||
		    !strcmp( "--noapplet", argv[ cx ] ) )
			toggles->applet = FALSE;
	}

	if( toggles->applet == FALSE )
		return;

	cfnp = 0;
	applet_widget_init( PACKAGE, VERSION, argc, argv,
	                    arguments, 0, NULL );

	if( cfnp )
	{
		g_free( configfilename );
		configfilename = g_strdup_printf( "/GnomeICU_%s/", cfnp );
	}

	applet = applet_widget_new( PACKAGE );
	if ( !applet )
		g_error( _("Can't create applet!\n" ) );

	style = gtk_widget_get_style( applet );

	init_applet_signals( applet );
	gtk_widget_realize( applet );
	init_pixmaps( style, applet );
	widget = create_applet();
	gtk_widget_show( widget );

	applet_widget_add( APPLET_WIDGET( applet ), widget );

	gtk_widget_show( applet );

	gtk_signal_connect( GTK_OBJECT(applet), "save_session",
	                    GTK_SIGNAL_FUNC(applet_save_state_cb),
	                    NULL);

	gtk_signal_connect( GTK_OBJECT( applet ), "destroy",
	                    GTK_SIGNAL_FUNC( icq_quit ),
	                    NULL );
}

void applet_update( DWORD status, GdkPixmap *flash )
{
	GdkPixmap *status_pix;
	GdkBitmap *status_bit;
	gchar *message_count = NULL;
	int num_messages = 0;
	gchar *tooltips_str = NULL;
	gint type = 0;
	gint online = 0;

	gchar *names_str = NULL;
	gchar *temp;

	GSList *contact;

	if( toggles->applet == FALSE )
		return;

	if( status == STATUS_OFFLINE )
	{
		status_pix = icon_offline_pixmap;
		status_bit = icon_offline_bitmap;
	}
	else switch( status & 0xffff )
	{
		case STATUS_ONLINE:
			status_pix = icon_online_pixmap;
			status_bit = icon_online_bitmap;
			break;
		case STATUS_AWAY:
			status_pix = icon_away_pixmap;
			status_bit = icon_away_bitmap;
			break;
		case STATUS_NA:
			status_pix = icon_na_pixmap;
			status_bit = icon_na_bitmap;
			break;
		case STATUS_DND:
			status_pix = icon_dnd_pixmap;
			status_bit = icon_dnd_bitmap;
			break;
		case STATUS_FREE_CHAT:
			status_pix = icon_ffc_pixmap;
			status_bit = icon_ffc_bitmap;
			break;
		case STATUS_OCCUPIED:
			status_pix = icon_occ_pixmap;
			status_bit = icon_occ_bitmap;
			break;
		case STATUS_INVISIBLE:
			status_pix = icon_inv_pixmap;
			status_bit = icon_inv_bitmap;
			break;
		default:
			status_pix = icon_offline_pixmap;
			status_bit = icon_offline_bitmap;
			break;
	}

	contact = Contacts;

	while( contact != NULL )
	{
		if( g_slist_length( ((CONTACT_PTR)contact->data)->stored_messages ) && !type )
			type = ((STORED_MESSAGE_PTR)((CONTACT_PTR)contact->data)->stored_messages->data)->type;
		num_messages += g_slist_length( ((CONTACT_PTR)contact->data)->stored_messages );
		contact = contact->next;
	}

	if( flash != NULL )
		switch( type )
		{
			case MESSAGE_CONT_LIST:
				gtk_pixmap_set( GTK_PIXMAP( mess_pm ), icon_contact_pixmap,
				                icon_contact_bitmap );
				break;
			case MESSAGE_CHAT_REQ:
				gtk_pixmap_set( GTK_PIXMAP( mess_pm ), icon_chat_pixmap,
				                icon_chat_bitmap );
				break;
			case MESSAGE_FILE_REQ:
				gtk_pixmap_set( GTK_PIXMAP( mess_pm ), icon_file_pixmap,
				                icon_file_bitmap );
				break;
			case MESSAGE_URL:
				gtk_pixmap_set( GTK_PIXMAP( mess_pm ), icon_url_pixmap,
				                icon_url_bitmap );
				break;
			case MESSAGE_AUTH_REQ:
			case MESSAGE_USER_ADD:
			case MESSAGE_USER_AUTHD:
				gtk_pixmap_set( GTK_PIXMAP( mess_pm ), icon_auth_pixmap,
				                icon_auth_bitmap );
				break;
			default:
				gtk_pixmap_set( GTK_PIXMAP( mess_pm ), icon_message_pixmap,
				                icon_message_bitmap );
		}

	else if( num_messages )
		gtk_pixmap_set( GTK_PIXMAP( mess_pm ), icon_blank_pixmap,
		                icon_blank_bitmap );
	else
		gtk_pixmap_set( GTK_PIXMAP( mess_pm ), status_pix,
		                status_bit );


	message_count = g_strdup_printf( "%d", num_messages );

	gtk_label_set( GTK_LABEL( mess_label ), message_count );

	/* adding code to display contacts in a tooltip, dwb 11-3-1999
	   severely modified by Jeremy Wise, 11-10-1999 */

	contact = Contacts;

	while( contact != NULL )
	{
		if( ((CONTACT_PTR)contact->data)->status != STATUS_OFFLINE &&
		    ((CONTACT_PTR)contact->data)->ignore_list != TRUE )
		{
			/* Add nick to string */
			temp = names_str;
			if( names_str )
				names_str = g_strdup_printf( "%s%s\n", names_str, ((CONTACT_PTR)contact->data)->nick );
			else
				names_str = g_strdup_printf( "%s\n", ((CONTACT_PTR)contact->data)->nick );
			g_free( temp );

			online ++;
		}
		contact = contact->next;
	}

	if ( num_messages == 0 )
	/* [BV 27-Oct-99] show number of online contacts instead */
	{
		message_count = g_strdup_printf( "%d", online );
		gtk_label_set( GTK_LABEL( mess_label ), message_count );
	}

	if( names_str == NULL )
		tooltips_str = g_strdup_printf( _("%u: 0 Users Online"), our_info->uin );
	else if( online == 1 )
		tooltips_str = g_strdup_printf( _("%u: %u User Online\n%s"), our_info->uin, online, names_str );
	else
		tooltips_str = g_strdup_printf( _("%u: %u Users Online\n%s"), our_info->uin, online, names_str );

	if( names_str )
		g_free( names_str );

	applet_widget_set_tooltip( APPLET_WIDGET( applet ), tooltips_str );

	g_free( message_count );
	g_free( tooltips_str );
}

void applet_clicked_cb( GtkWidget *widget, GdkEventButton *ev, gpointer data )
{
	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "applet_clicked_cb\n" );
#endif

	if( ev == NULL )
		return;

	if( ev->button != 1 || ev->type != GDK_BUTTON_PRESS )
		return;

	contact = Contacts;

	while( contact != NULL && g_slist_length( ((CONTACT_PTR)contact->data)->stored_messages ) == 0 )
		contact = contact->next;

	if( contact == NULL )
		applet_hide_main( widget, NULL );
	else
		show_contact_message( contact );
}

gboolean applet_hide_main( GtkWidget *widget, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "applet_hide_main\n" );
#endif

	if( !toggles->applet )
		return TRUE;

	if( !GTK_WIDGET_VISIBLE( app ) ) {
		gtk_widget_show( app );
	} else {
		gtk_widget_hide( app );
		if( autohide_timeout_tag ) {
			gtk_timeout_remove( autohide_timeout_tag );
			/* so we know it's not running anymore */
			autohide_timeout_tag = 0;
		}
	}
	return TRUE; /* don't emit "destroy" signal */
}

/*** Local functions ***/
gint applet_save_state_cb( GtkWidget *w, const char *privcfgpath, const char *globcfgpath, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "applet_save_state_cb\n");
#endif

	if( have_read_config )
		Save_RC();

	gnome_config_sync();
	gnome_config_drop_all();

	return FALSE;
}

void applet_exposed_cb( GtkWidget *widget, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "applet_exposed_cb(%d)\n", Current_Status );
#endif
	applet_update( Current_Status, NULL );
}

GtkWidget *create_applet( void )
{
	GtkWidget *table;
	GtkWidget *eventbox;

#ifdef TRACE_FUNCTION
	g_print( "create_applet\n" );
#endif

	if( mess_label == NULL )
		mess_label = gtk_label_new( "0" );

	if( mess_pm == NULL )
		mess_pm = gtk_pixmap_new( icon_blank_pixmap, icon_blank_bitmap );

	gtk_widget_push_visual (gdk_imlib_get_visual ());
	gtk_widget_push_colormap (gdk_imlib_get_colormap ());

	table = gtk_table_new( 2, 1, FALSE );
	eventbox = gtk_event_box_new();
	frame_outline = gtk_frame_new( NULL );
	frame_outline2 = gtk_frame_new( NULL );
	gtk_container_add( GTK_CONTAINER( eventbox ), frame_outline );
	
	frame = gtk_fixed_new();
	gtk_widget_set_usize( frame, 26, 44 );

	gtk_container_add( GTK_CONTAINER( frame_outline ), frame_outline2 );
	gtk_container_add( GTK_CONTAINER( frame_outline2 ), frame );
	gtk_frame_set_shadow_type( GTK_FRAME( frame_outline ), GTK_SHADOW_IN );
	gtk_frame_set_shadow_type( GTK_FRAME( frame_outline2 ), GTK_SHADOW_OUT );
	gtk_widget_set_usize( frame_outline, 28, 48 );
	gtk_widget_show( frame_outline );
	gtk_widget_show( frame_outline2 );

	gtk_widget_show( table );
	gtk_widget_show( frame );

	gtk_fixed_put( GTK_FIXED( frame ), mess_pm, 2, 3 );
	gtk_widget_show( mess_pm );

	gtk_misc_set_alignment( GTK_MISC( mess_label ), 0.5, 0.5 );
	gtk_fixed_put( GTK_FIXED( frame ), mess_label, 5, 22 );
	gtk_widget_show( mess_label );

	gtk_widget_pop_colormap ();
	gtk_widget_pop_visual ();
        return eventbox;
}

void init_applet_signals( GtkWidget *window )
{
	gtk_widget_set_events( window, gtk_widget_get_events( window ) |
	                       GDK_BUTTON_PRESS_MASK | GDK_EXPOSURE_MASK );

	gtk_signal_connect( GTK_OBJECT( window ), "expose_event",
	                    GTK_SIGNAL_FUNC( applet_exposed_cb ), NULL );

	gtk_signal_connect( GTK_OBJECT( window ), "button_press_event",
	                    GTK_SIGNAL_FUNC( applet_clicked_cb ), NULL );

	gtk_signal_connect( GTK_OBJECT( window ), "change_orient",
	                    GTK_SIGNAL_FUNC( applet_change_orient ), NULL );

	applet_widget_register_stock_callback( APPLET_WIDGET( applet ),
	                                       "about",
	                                       GNOME_STOCK_MENU_ABOUT,
	                                       _("About..."),
	                                       (AppletCallbackFunc)about,
	                                       NULL );
	applet_widget_register_stock_callback( APPLET_WIDGET( applet ),
	                                       "options",
	                                       GNOME_STOCK_MENU_PROP,
	                                       _("Options..."),
	                                       (AppletCallbackFunc)configure_window,
	                                       MainData );

	applet_widget_register_stock_callback( APPLET_WIDGET( applet ),
	                                       "set_online",
	                                       "gnomeicu/gnomeicu-online.xpm",
	                                       _("Online"),
	                                       (AppletCallbackFunc)icq_set_status_online,
	                                       MainData );

	applet_widget_register_stock_callback( APPLET_WIDGET( applet ),
	                                       "set_away",
	                                       "gnomeicu/gnomeicu-away.xpm",
	                                       _("Away"),
	                                       (AppletCallbackFunc)icq_set_status_away,
	                                       MainData );

	applet_widget_register_stock_callback( APPLET_WIDGET( applet ),
	                                       "set_na",
	                                       "gnomeicu/gnomeicu-na.xpm",
	                                       _("Not Available"),
	                                       (AppletCallbackFunc)icq_set_status_na,
	                                       MainData );

	applet_widget_register_stock_callback( APPLET_WIDGET( applet ),
	                                       "set_ffc",
	                                       "gnomeicu/gnomeicu-ffc.xpm",
	                                       _("Free for Chat"),
	                                       (AppletCallbackFunc)icq_set_status_ffc,
	                                       MainData );

	applet_widget_register_stock_callback( APPLET_WIDGET( applet ),
	                                       "set_occupied",
	                                       "gnomeicu/gnomeicu-occ.xpm",
	                                       _("Occupied"),
	                                       (AppletCallbackFunc)icq_set_status_occ,
	                                       MainData );

	applet_widget_register_stock_callback( APPLET_WIDGET( applet ),
	                                       "set_dnd",
	                                       "gnomeicu/gnomeicu-dnd.xpm",
	                                       _("Do Not Disturb"),
	                                       (AppletCallbackFunc)icq_set_status_dnd,
	                                       MainData );

	applet_widget_register_stock_callback( APPLET_WIDGET( applet ),
	                                       "set_invisible",
	                                       "gnomeicu/gnomeicu-inv.xpm",
	                                       _("Invisible"),
	                                       (AppletCallbackFunc)icq_set_status_invisible,
	                                       MainData );

	applet_widget_register_stock_callback( APPLET_WIDGET( applet ),
	                                       "set_offline",
	                                       "gnomeicu/gnomeicu-offline.xpm",
	                                       _("Offline"),
	                                       (AppletCallbackFunc)icq_set_status_offline,
	                                       MainData );

	applet_widget_register_stock_callback( APPLET_WIDGET( applet ),
	                                       "hide_show",
	                                       GNOME_STOCK_MENU_CONVERT,
	                                       _("Hide/Show Main Window"),
	                                       (AppletCallbackFunc)applet_hide_main,
	                                       MainData );
}

static void applet_change_orient( GtkWidget *w, PanelOrientType o, gpointer data )
{
	orient = o;

	if( orient == ORIENT_LEFT || orient == ORIENT_RIGHT )
	{
		gtk_widget_set_usize( frame, 44, 26 );
		gtk_widget_set_usize( frame_outline, 48, 28 );
		gtk_fixed_move( GTK_FIXED( frame ), mess_label, 30, 2 );
	}
	else
	{
		gtk_widget_set_usize( frame, 26, 44 );
		gtk_widget_set_usize( frame_outline, 28, 48 );
		gtk_fixed_move( GTK_FIXED( frame ), mess_label, 6, 22 );
	}
}

void about( GtkWidget *widget, gpointer data )
{
	GtkWidget *about;
	const gchar *authors[] =
	{
		"Jeremy Wise <jwise@pathwaynet.com>",
		"As inspired by our Lord Jesus Christ",
		NULL
	};

#ifdef TRACE_FUNCTION
	g_print( "about\n" );
#endif

	about = gnome_about_new( "GnomeICU", VERSION,
	                         "(C) 1999 Jeremy Wise",
	                         authors,
	                         _("GnomeICU is a small, fast and functional "
	                         "clone of Mirabilis' ICQ program, specifically "
	                         "designed for Linux and X."),
	                         NULL );

	gtk_widget_show( about );

	return;
}
