/*
 status.c : GMasqDialer

    Copyright (C) 1998-1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "gmasqdialer.h"

static gchar *old_connection = NULL;
static gboolean server_time_got;

static int pids = 0;

static int pidcheck_func(void)
{
    if (waitpid(-1, NULL, WNOHANG) > 0) pids--;
    return pids > 0;
}

void status_connection_lost(void)
{
    animation_stop();
    maxcps = -1;
    server_time_got = FALSE;
    old_connection = NULL;
    connected_at = 0;

    gtk_label_set(GTK_LABEL(connlabel), _("Not connected"));
#ifdef HAVE_GNOME_PANEL
    if (appletlabel != NULL) gtk_label_set(GTK_LABEL(appletlabel), _("No conn."));
#endif
    gtk_widget_hide(output.label);
    gtk_widget_hide(input.label);
}

static void callback_servertime(CALLBACK_DATA *data)
{
    server_time_got = TRUE;
    if (data->status == 0)
    {
        /* Old server, didn't understand us.. */
        server_time_diff = 0;
        return;
    }

    server_time_diff = (time_t) data->u.digit - time(NULL);
}

void callback_status(CALLBACK_DATA *data)
{
    gchar *newconn;
    GString *str;

    if (data->status == 0)
    {
        /* STAT didn't work ?? we surely aren't connected to mserver.. */
        masqerror(_("Looks like we didn't connect to masqdialer server.."));
        menu_disconnect();
        callback_err = TRUE;
        return;
    }

    callback_err = FALSE;
    newconn = data->u.connection.connection;
    if ((newconn == NULL && old_connection == NULL) ||
        (newconn != NULL && old_connection != NULL && strcmp(newconn, old_connection) == 0))
    {
        /* Same connection state as last time, no need to do anything.. */
        if (newconn != NULL) g_free(newconn);
        return;
    }

    if (old_connection != NULL) g_free(old_connection);
    old_connection = newconn;

    if (newconn == NULL)
    {
	/* Not connected */
	if (beep_connects) gdk_beep();
	gtk_statusbar_pop(GTK_STATUSBAR(statusbar), 1);
	gtk_statusbar_push(GTK_STATUSBAR(statusbar), 1, _("Not connected"));
	set_dial_sensitive(TRUE, FALSE);
        status_connection_lost();
        return;
    }

    animation_stop();
    if (strncmp(newconn, "Connection Pending", 18) == 0)
    {
	/* Dialing .. */
	animation_start();
	maxcps = -1; server_time_got = FALSE; connected_at = 0;
	gtk_label_set(GTK_LABEL(connlabel), _("Dialing.."));
	gtk_statusbar_pop(GTK_STATUSBAR(statusbar), 1);
	gtk_statusbar_push(GTK_STATUSBAR(statusbar), 1, newconn);
	set_dial_sensitive(FALSE, FALSE);
	return;
    }

    /* Connected */
    gtk_label_set(GTK_LABEL(output.label), "");
    gtk_label_set(GTK_LABEL(input.label), "");

    gtk_widget_show(output.label);
    gtk_widget_show(input.label);

    maxcps = data->u.connection.bps / 8;
    if (maxcps <= 0) maxcps = -1;

    str = g_string_new(NULL);
    g_string_sprintf(str, _("Connected to %s (%d bps)"),
                     data->u.connection.connection, data->u.connection.bps);

    if (!server_time_got)
        mserver_time(callback_servertime);

    gtk_statusbar_pop(GTK_STATUSBAR(statusbar), 1);
    gtk_statusbar_push(GTK_STATUSBAR(statusbar), 1, str->str);
    g_string_free(str, TRUE);

    set_dial_sensitive(FALSE, TRUE);

    if (beep_connects) gdk_beep();
    if (*autorun != '\0')
    {
	/* automatically run command */
	if (fork() == 0)
	{
	    system(autorun);
	    _exit(0);
	}
	if (pids > 0)
	    pids++;
	else
	{
	    gtk_timeout_add(2000, (GtkFunction) pidcheck_func, NULL);
	    pids = 1;
	}
    }
}
