#!/usr/bin/perl5

# read values from the command line and update a running bind 8 named

# location for nsupdate command
my $NSUPDATE="/usr/bin/nsupdate";

# nsupdate command strings
my $IFEXIST="prereq yxdomain";
my $IFNOTEXIST="prereq nxdomain";
my $ADD="update add";
my $DELETE="update delete";
my $TTL="3600";

my $DEBUG = 0;

my ($action,$machine,$address,$arpa,$file,@FILE);

use English;

($action,$machine)=check_action(@ARGV);

if ($action=~m/add/) {
    $address=check_address($ARGV[2]);
}
else {
    $address=get_address($machine);
}

# at this point we must have a valid value for $address
if ($address == "") {
    exit (1);
}

# now we should be ready to construct a command file for nsupdate
if ($action=~m/add/) {
    @commands = add_record($machine,$address);
}
else {
    @commands = delete_record($machine,$address);
}

if ($DEBUG == 1) {
  print @commands;
  exit 0;
}

$file = "update$PID";
open FILE, ">$file" or die "Unable to open $file\n";
print FILE @commands;
close FILE;

$command="$NSUPDATE $file";
`$command`;

# clean up after ourselves
$command="rm $file";
`$command`;

#
# delete a record
#
sub delete_record {
    my ($machine,$address) = @_;
    my @c,$arpa;

# get the reverse lookup value
    $arpa = get_arpa($address);
# first delete the forward lookup
    push @c, "$IFEXIST $machine\n";
    push @c, "$DELETE $machine\n\n";
# then delete the backward lookup
    push @c, "$IFEXIST $arpa\n";
    push @c, "$DELETE $arpa\n\n";
    return @c;
}

#
# add/update a record
#
sub add_record {
    my ($machine,$address) = @_;
    my ($xaddress,@c,$arpa);

# an add/update must first delete any records that already exist.
    $xaddress = get_address($machine);
    unless ($xaddress == "") {
	@c = delete_record($machine,$xaddress);
    }
# get reverse lookup for the new address
    $arpa=get_arpa($address);
# add the forward record
    push @c, "$ADD $machine $TTL IN A $address\n\n";
# add teh reverse record
    push @c, "$ADD $arpa $TTL IN PTR $machine\n\n";
    return @c;
}

#
# get the reverse lookup value for an address
#
sub get_arpa {
    my ($address) = @_;
    my ($arpa,$a,$b,$c,$d);

   ($a,$b,$c,$d) = split /\./, $address;
    $arpa = "$d.$c.$b.$a.in-addr.arpa";
    return $arpa;
}

# 
# get an address for an existing machine
# 
sub get_address {
    my ($machine) = @_;
    my ($address,$a,$b,$c,$d);

    ($a,$b,$c,$d)= unpack('C4', gethostbyname($machine));
    $address = "$a.$b.$c.$d";
    return check_address($address);
}

# check the action.  
# ARGV[0] - Only "add" and "delete" are allowed
# ARGV[1] - machine name
# ARGV[2] - address (required for add but not for delete)
sub check_action {

    my ($action,$machine,$address)=@_;
    unless ($action=~m/add|delete/) {
	print "Bad Action\n";
	exit (1);
    }
    return $action,$machine;
}

# check if an address has a reasonable format
#
sub check_address {
    my ($address)=@_;

    if ($address=~m/\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}/) {
	return $address;
    }
    return "";
}





